<x-app-layout>

  
<!-- Page container -->
      <div class="container pt-5 pb-lg-5 pb-md-4 pb-2 my-5">
        
        <!-- Breadcrumb -->
        <nav aria-label="breadcrumb">
          <ol class="pt-lg-3 pb-lg-4 pb-2 breadcrumb">
            <li class="breadcrumb-item"><a href=" {{ route('dashboard') }} ">Home</a></li>
            <li class="breadcrumb-item"><a href=" {{ route('empresas.index') }} ">Empresas</a></li>
            <li class="breadcrumb-item active" aria-current="page">{{ $perfilEmpresarial->id }}</li>
          </ol>
        </nav>

        <div class="row mb-md-2 mb-xl-4">

          <!-- Blog posts -->
          <div class="col-lg-9 pe-lg-4 pe-xl-5">

            <div class="d-flex align-items-center pb-3 pb-lg-4 gap-3">

                @if (auth()->user()->tienePermiso('Logo'))
                <img src="{{ asset('storage/' . $perfilEmpresarial->logo_path) }}" alt="Logo" width="80" class="">
                @endif

                @if (auth()->user()->tienePermiso('Nombre Comercial'))
                    <h1 class="m-0">{{ $perfilEmpresarial->nombre_comercial }}</h1>
                @endif
                
            </div>

                @if (auth()->user()->tienePermiso('Nombre'))
                <p><strong>Nombre: </strong>{{ $perfilEmpresarial->nombre }}</p>
                @endif

                @if (auth()->user()->tienePermiso('Pagina web'))
                <p><strong>Página web: </strong><a href="{{ $perfilEmpresarial->pagina_web }}" target="_blank">{{ $perfilEmpresarial->pagina_web }}</a></p>
                @endif
                {{-- Lada + Telefono de oficina --}}
                    @if (auth()->user()->tienePermiso('Telefono Oficina'))
                    <span>
                        <strong>Número teléfonico:</strong>
                        +{{ $perfilEmpresarial->lada_telefono }}
                    </span>
                    <span>
                        {{ $perfilEmpresarial->telefono_oficina }}
                    </span>
                    <br>
                    @endif
                
                @if (auth()->user()->tienePermiso('Email-Empresa'))
                <p><strong>Correo electrónico:</strong> {{ $perfilEmpresarial->email }}</p>
                @endif

                @if (auth()->user()->tienePermiso('Razon Social'))
                <p><strong>Razón social:</strong> {{ $perfilEmpresarial->razon_social }}</p>
                @endif

                @if (auth()->user()->tienePermiso('Descripción Breve'))
                <p><strong>Descripción breve:</strong> {{ $perfilEmpresarial->descripcion_breve }}</p>
                @endif

                @if (auth()->user()->tienePermiso('Descripción Detallada'))
                <p><strong>Descripción detallada:</strong></p>
                <p>{{ $perfilEmpresarial->descripcion_detallada }}</p>
                @endif

                @if (auth()->user()->tienePermiso('Tipo de membresia'))
                <p><strong>Tipo de membresía:</strong> {{ $perfilEmpresarial->tipoMembresia->nombre ?? 'No especificada' }}</p>
                @endif

                @if (auth()->user()->tienePermiso('Documentos'))
                <p><strong>Documentos:</strong></p>
                <ul>
                    @foreach ($perfilEmpresarial->documentos as $ruta)
                        <li>
                            <a href="{{ asset('storage/' . $ruta) }}" target="_blank">
                                {{ $perfilEmpresarial->nombres_documentos[$ruta] ?? basename($ruta) }}
                            </a>
                        </li>
                    @endforeach
                </ul>
                @endif
        {{-- Seccion para los contactos clave de cada perfil empresarial --}}
        @if (auth()->user()->tienePermiso('Contactos Clave'))
            <h4>Contactos Clave:</h4>
            <ul>
                @forelse ($perfilEmpresarial->contactosClave as $contacto)
                    <li>
                        @if (auth()->user()->tienePermiso('Puesto'))
                        <strong>{{ $contacto->puesto_departamento }}:</strong>
                        @endif

                        @if (auth()->user()->tienePermiso('Nombre Completo'))
                        {{ $contacto->nombre }} {{ $contacto->apellidos }}
                        @endif

                        @if(auth()->user()->tienePermiso('Logo Contacto'))
                            <img src="{{ asset('storage/' . $contacto->logo_path) }}" width="40" class="ms-2 rounded-circle" alt="Logo del contacto">
                        @endif
                    </li>

                    @if (auth()->user()->tienePermiso('Email'))
                    <span>
                        <strong>Correo electrónico:</strong>
                        {{ $contacto->email }}
                    </span>
                    <br>
                    @endif
                    {{-- Lada + Telefono --}}
                    @if (auth()->user()->tienePermiso('Telefono a localizar'))
                    <span>
                        <strong>Número teléfonico:</strong>
                        +{{ $contacto->lada_telefono }}
                    </span>
                    <span>
                        {{ $contacto->telefono }}
                    </span>
                    <br>
                    @endif

                    @if (auth()->user()->tienePermiso('Pagina web Contacto'))
                    <span>
                        <strong>Página web:</strong>
                        <a href="{{ $contacto->pagina_web }}" target="_blank">{{ $contacto->pagina_web }}</a>
                    </span>
                    @endif

                @empty
                    <li>No hay contactos clave registrados.</li>
                @endforelse
            </ul>
        @endif
        

        {{-- Seccion para Registros, acreditaciones y certificaciones del perfil empresarial --}}
        @if (auth()->user()->tienePermiso('Registros, Acreditaciones y Certificaciones'))
            <h4>Registros, Acreditaciones y Certificaciones</h4>
                <ul>
                    @forelse ($perfilEmpresarial->registros_acreditaciones_certificaciones as $rac)

                    <li>
                        <span class="badge bg-primary me-2 mb-2">
                        <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor" class="bi bi-file-earmark-medical-fill" viewBox="0 0 16 16">
                        <path d="M9.293 0H4a2 2 0 0 0-2 2v12a2 2 0 0 0 2 2h8a2 2 0 0 0 2-2V4.707A1 1 0 0 0 13.707 4L10 .293A1 1 0 0 0 9.293 0M9.5 3.5v-2l3 3h-2a1 1 0 0 1-1-1m-3 2v.634l.549-.317a.5.5 0 1 1 .5.866L7 7l.549.317a.5.5 0 1 1-.5.866L6.5 7.866V8.5a.5.5 0 0 1-1 0v-.634l-.549.317a.5.5 0 1 1-.5-.866L5 7l-.549-.317a.5.5 0 0 1 .5-.866l.549.317V5.5a.5.5 0 1 1 1 0m-2 4.5h5a.5.5 0 0 1 0 1h-5a.5.5 0 0 1 0-1m0 2h5a.5.5 0 0 1 0 1h-5a.5.5 0 0 1 0-1"/>
                        </svg>
                        {{ $rac->nombre }}
                        </span>
                    </li>
                        
                    @empty

                    <span>Esta empresa no tiene registros, acreditaciones ni certificaciones.</span>
                        
                    @endforelse
                </ul>
        @endif

        {{-- Seccion para Sectores de experiencia y conocimiento --}}
        @if (auth()->user()->tienePermiso('Sectores de Experiencia y Conocimiento'))
        <h4>Sectores de Experiencia y Conocimiento</h4>
        <ul>
            @forelse ($perfilEmpresarial->sectores_de_experiencia_conocimiento as $syc)
                <li>
                    <span class="badge bg-primary me-2 mb-2">
                    <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor" class="bi bi-briefcase-fill" viewBox="0 0 16 16">
                        <path d="M6.5 1A1.5 1.5 0 0 0 5 2.5V3H1.5A1.5 1.5 0 0 0 0 4.5v1.384l7.614 2.03a1.5 1.5 0 0 0 .772 0L16 5.884V4.5A1.5 1.5 0 0 0 14.5 3H11v-.5A1.5 1.5 0 0 0 9.5 1zm0 1h3a.5.5 0 0 1 .5.5V3H6v-.5a.5.5 0 0 1 .5-.5"/>
                        <path d="M0 12.5A1.5 1.5 0 0 0 1.5 14h13a1.5 1.5 0 0 0 1.5-1.5V6.85L8.129 8.947a.5.5 0 0 1-.258 0L0 6.85z"/>
                    </svg>
                    {{ $syc->nombre }}
                </li>
            @empty
                <span> Esta empresa no tiene Sectores de Experiencia y/o Conocimiento registrados. </span>
            @endforelse
        </ul>
        @endif

        @if (auth()->user()->tienePermiso('Categorias Empresariales'))
        {{-- Seccion para las categorias --}}
        <h4>CategorIas</h4>
        <ul>
            @forelse ($perfilEmpresarial->categorias as $categoria)
                <li>
                    <span class="badge bg-primary me-2 mb-2">
                    <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor" class="bi bi-record-fill" viewBox="0 0 16 16">
                        <path fill-rule="evenodd" d="M8 13A5 5 0 1 0 8 3a5 5 0 0 0 0 10"/>
                    </svg>
                        {{ $categoria->nombre }}
                    </span>
                </li>
            @empty
                
            @endforelse
        </ul>
        @endif
    </div>
</x-app-layout>


