<x-app-layout>

  
<!-- Page container -->
      <div class="container pt-5 pb-lg-5 pb-md-4 pb-2 my-5">
        
        <!-- Breadcrumb -->
        <nav aria-label="breadcrumb">
          <ol class="pt-lg-3 pb-lg-4 pb-2 breadcrumb">
            {{-- <li class="breadcrumb-item"><a href=" {{ route('dashboard') }} ">Home</a></li> --}}
            <li class="breadcrumb-item active" aria-current="page">Noticias</li>
          </ol>
        </nav>

        <div class="row mb-md-2 mb-xl-4">

          <!-- Blog noticias -->
          <div class="col-lg-9 pe-lg-4 pe-xl-5">
            <h1 class="pb-3 pb-lg-4">Noticias</h1>

            <!-- noticias list -->
            <div class="container my-5">
              <div class="row g-4">
                @foreach ($noticias as $noticia)
                  <div class="col-md-6 col-lg-4"> 
                    <div class="card border-0 shadow-sm h-100" style="border-radius: 0; display: flex; flex-direction: column;">
                      
                      {{-- Imagen cuadrada responsiva --}}
                      <a href="{{ route('noticias.show', $noticia) }}" class="d-block">
                        <div class="ratio ratio-1x1 overflow-hidden rounded-0">
                          <img 
                            src="{{ $noticia->image_path ? asset('storage/' . $noticia->image_path) : 'https://thumb.ac-illust.com/b1/b170870007dfa419295d949814474ab2_t.jpeg' }}" 
                            class="w-100 h-100"
                            alt="imagen-noticia"
                            style="object-fit: cover;">
                        </div>
                      </a>


                      {{-- Contenido --}}
                      <div class="card-body flex-grow-1">
                        <h6 class="text-uppercase text-primary fw-bold small mb-2">
                          {{ $noticia->categoria->nombre ?? 'Noticias' }}
                        </h6>
                        <h5 class="card-title fw-bold">
                          <a href="{{ route('noticias.show', $noticia) }}" class="text-dark text-decoration-none">
                            {{ $noticia->title }}
                          </a>
                        </h5>
                        <p class="card-text text-muted">
                          {{ Str::limit($noticia->resumen, 120) }}
                        </p>
                      </div>

                      {{-- Footer --}}
                      <div class="card-footer border-0 small text-muted">
                        Publicado por <strong>{{ $noticia->user->name }}</strong><br>
                        @if($noticia->published_at)
                          {{ $noticia->published_at->format('d/m/Y') }}
                        @else
                          <em>(No publicado)</em>
                        @endif
                      </div>

                    </div>
                  </div>
                @endforeach
              </div>
          </div>


            
            <!-- Links de paginación -->
           <!-- Pagination -->
            <div class="col col-md-4 col-6 order-md-3 order-2">
                <nav aria-label="Page navigation">
                  {{ $noticias->links('pagination::bootstrap-4') }}
                </nav>
              </div>

             
          </div>
          <x-partials.sidebar/>
         </div>
         



</x-app-layout>
