<x-app-layout>
    <x-slot name="header">
        <h2 class="font-semibold text-xl text-gray-800 leading-tight">
            {{ __('Publicaciones') }}
        </h2>
    </x-slot>

    <div class="py-8">
        <div class="max-w-7xl mx-auto sm:px-6 lg:px-8">

            @if ($posts->count())
                <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-6">
                    @foreach ($posts as $post)
                        <div class="bg-white overflow-hidden shadow-sm sm:rounded-lg p-6">
                            <h3 class="text-lg font-bold text-gray-900">{{ $post->title }}</h3>
                            <p class="text-sm text-gray-600 mb-2">
                                Publicado por <strong>{{ $post->user->name }}</strong>
                                @if($post->published_at)
                                    el {{ $post->published_at->format('d/m/Y') }}
                                @else
                                    <em>(No publicado)</em>
                                @endif
                            </p>
                            <p class="text-gray-700 mb-3">{{ Str::limit($post->content, 100) }}</p>
                            <a href="{{ route('posts.show', $post->id) }}"
                               class="inline-block bg-indigo-600 text-white px-4 py-2 rounded hover:bg-indigo-700 text-sm">
                                Leer más
                            </a>
                        </div>
                    @endforeach
                </div>

               <div class="row gy-3 align-items-center mt-lg-5 pt-2 pt-md-4 pt-lg-0">
  <div class="col-12 d-flex justify-content-center">
    {{ $posts->links('vendor.pagination.bootstrap-5') }}
  </div>
</div>

            @else
                <div class="bg-yellow-100 border-l-4 border-yellow-500 text-yellow-700 p-4" role="alert">
                    <p class="font-bold">Aviso</p>
                    <p>No hay publicaciones disponibles.</p>
                </div>
            @endif

        </div>
    </div>
</x-app-layout>