<x-app-layout>
<!-- Page container -->
<div class="container pt-5 pb-lg-5 pb-md-4 pb-2 my-5">
        <!-- Breadcrumb -->
        <nav aria-label="breadcrumb">
          <ol class="pt-lg-3 pb-lg-4 pb-2 breadcrumb">
            <li class="breadcrumb-item"><a href=" {{ route('dashboard') }} ">Home</a></li>
            <li class="breadcrumb-item active" aria-current="page">Eventos</li>
          </ol>
        </nav>
        <div class="row mb-md-2 mb-xl-4">

          <!-- Blog posts -->
          <div class="col-lg-9 pe-lg-4 pe-xl-5">
    <style>
            .post-card {
                border: 1px solid #dee2e6;
                border-radius: 1rem;
                background: #fff;
                box-shadow: 0 2px 6px rgba(0,0,0,0.04);
                margin-bottom: 2rem;
            }
            .post-image {
                width: 100%;
                height: 220px;
                object-fit: cover;
                border-radius: 0.5rem;
            }
            .comment-card {
                background: #f8f9fa;
                border: 1px solid #dee2e6;
                border-radius: 0.5rem;
                padding: 0.75rem 1rem;
                margin-bottom: 0.75rem;
                box-shadow: 0 1px 2px rgba(0,0,0,0.03);
            }
            .form-comment input {
                border-radius: 2rem;
            }
            .fb-gallery {
                width: 100%;
                margin-bottom: 1rem;
                display: flex;
                flex-direction: column;
                gap: 4px;
            }

            .fb-row {
                display: flex;
                gap: 4px;
            }

            .fb-col {
                display: flex;
                flex-direction: column;
                gap: 4px;
                flex: 1;
            }

            .fb-grid {
                display: grid;
                grid-template-columns: repeat(2, 1fr);
                gap: 4px;
            }

            .fb-img {
                position: relative;
                overflow: hidden;
                border-radius: 10px;
            }

            .fb-img img {
                width: 100%;
                height: 100%;
                object-fit: cover;
                display: block;
                aspect-ratio: 1/1;
            }

            .fb-img-1 img {
                aspect-ratio: 4/3;
                border-radius: 10px;
            }

            .fb-img-half {
                flex: 1;
            }

            .fb-img-small {
                flex: 1;
                height: 100%;
            }

            .fb-overlay {
                position: absolute;
                inset: 0;
                background: rgba(0, 0, 0, 0.6);
                color: white;
                font-weight: bold;
                font-size: 2rem;
                display: flex;
                justify-content: center;
                align-items: center;
                border-radius: 10px;
            }

            /* Responsive: 100% ancho en móviles */
            @media (max-width: 600px) {
                .fb-row,
                .fb-grid {
                    flex-direction: column;
                    display: flex;
                }

                .fb-col {
                    flex-direction: row;
                }

                .fb-img img {
                    aspect-ratio: 1/1;
                }
            }
    </style>
    <h2 class="mb-4">📰 Eventos recientes</h2>
    @php
        $posts2 = [
            (object)[
                'id' => 1,
                'title' => 'Festival Cultural 2025',
                'content' => 'Disfruta del festival con música, arte y gastronomía local. ¡Todos están invitados!',
                'images' => [
    'https://i0.wp.com/cruce.iteso.mx/wp-content/uploads/2023/10/PORTADA-FESTIVAL-CULTURAL.jpg?resize=1024%2C640&ssl=1?fit=crop&w=600&h=400',
    'https://images.unsplash.com/photo-1492684223066-81342ee5ff30?fit=crop&w=600&h=400',
    'https://images.unsplash.com/photo-1492684223066-81342ee5ff30?fit=crop&w=600&h=400',
    'https://images.unsplash.com/photo-1492684223066-81342ee5ff30?fit=crop&w=600&h=400',
    'https://images.unsplash.com/photo-1506744038136-46273834b3fb?fit=crop&w=600&h=400',
    ],
                'published_at' => now()->subHours(6),
                'user' => (object)['name' => 'Gabriel Cruz'],
                'categorias' => [(object)['nombre' => 'Cultura'], (object)['nombre' => 'Eventos']],
                'comments' => [
                    (object)[
                        'body' => '¡Nos vemos allá!',
                        'user' => (object)['name' => 'Ana Torres'],
                        'created_at' => now()->subHours(2),
                    ],
                    (object)[
                        'body' => '¿Dónde será exactamente?',
                        'user' => (object)['name' => 'Luis Martínez'],
                        'created_at' => now()->subHour(),
                    ],
                ],
                'likes_count' => 31
            ],
            (object)[
                'id' => 2,
                'title' => 'Concierto de Jazz al Aire Libre',
                'content' => 'Una noche mágica con lo mejor del jazz local. Entrada libre.',
                'images' => [
                    'https://via.placeholder.com/600x400?text=Jazz+1',
                    'https://via.placeholder.com/600x400?text=Jazz+2',
                ],
                'published_at' => now()->subDays(1),
                'user' => (object)['name' => 'María López'],
                'categorias' => [],
                'comments' => [],
                'likes_count' => 12
            ]
        ];
    @endphp

    @foreach ($posts2 as $post)
    <div class="post-card p-4">
        {{-- Encabezado --}}
        <div class="d-flex justify-content-between align-items-center mb-3">
            <div>
                <h5 class="mb-0">{{ $post->title }}</h5>
                <small class="text-muted">Publicado por <strong>{{ $post->user->name }}</strong> • {{ $post->published_at->diffForHumans() }}</small>
            </div>
            <div>
                @forelse ($post->categorias as $cat)
                    <span class="badge bg-primary">{{ $cat->nombre }}</span>
                @empty
                    <span class="badge bg-secondary">Sin categoría</span>
                @endforelse
            </div>
        </div>

        {{-- Contenido --}}
        <p>{{ $post->content }}</p>

        {{-- Grid de imágenes estilo Facebook --}}
        @php
            $images = $post->images;
           $total = count($images);
        @endphp

    <div class="fb-gallery">

        @if ($total === 1)
            <div class="fb-img fb-img-1">
                <img src="{{ $images[0] }}" alt="img1">
            </div>

        @elseif ($total === 2)
            <div class="fb-row">
                @foreach ($images as $img)
                    <div class="fb-img fb-img-half">
                        <img src="{{ $img }}" alt="">
                    </div>
                @endforeach
            </div>

        @elseif ($total === 3)
            <div class="fb-row">
                <div class="fb-img fb-img-half">
                    <img src="{{ $images[0] }}" alt="">
                </div>
                <div class="fb-col">
                    <div class="fb-img fb-img-small"><img src="{{ $images[1] }}" alt=""></div>
                    <div class="fb-img fb-img-small"><img src="{{ $images[2] }}" alt=""></div>
                </div>
            </div>

        @elseif ($total === 4)
            <div class="fb-grid">
                @foreach ($images as $img)
                    <div class="fb-img">
                        <img src="{{ $img }}" alt="">
                    </div>
                @endforeach
            </div>

        @else
            <div class="fb-grid">
                @foreach (array_slice($images, 0, 4) as $i => $img)
                    <div class="fb-img">
                        <img src="{{ $img }}" alt="">
                        @if ($i === 3)
                            <div class="fb-overlay">
                                +{{ $total - 4 }}
                            </div>
                        @endif
                    </div>
                @endforeach
            </div>
        @endif

    </div>

        {{-- Reacciones --}}
        <div class="d-flex gap-3 text-muted small mb-3">
            <span>👍 {{ $post->likes_count }} Me gusta</span>
            <span>💬 {{ count($post->comments) }} Comentarios</span>
        </div>

        {{-- Comentarios --}}
        <div class="mb-3">
            @forelse ($post->comments as $comment)
                <div class="comment-card">
                    <strong>{{ $comment->user->name }}</strong>: {{ $comment->body }}
                    <div class="text-muted small mt-1">{{ $comment->created_at->diffForHumans() }}</div>
                </div>
            @empty
                <div class="text-muted">Sé el primero en comentar.</div>
            @endforelse
        </div>

        {{-- Caja de nuevo comentario --}}
        <form class="form-comment d-flex gap-2">
            <input type="text" class="form-control" placeholder="Escribe un comentario...">
            <button class="btn btn-outline-primary" type="submit">Enviar</button>
        </form>
</div>
    @endforeach


            
            {{-- <div class="row gy-3 align-items-center mt-lg-5 pt-2 pt-md-4 pt-lg-0">
              <div class="col-12 d-flex justify-content-center">
                {{ $posts->links() }}
              </div>
            </div> --}}

             <!-- Pagination -->
            <div class="row gy-3 align-items-center mt-lg-5 pt-2 pt-md-4 pt-lg-0">
              <div class="col col-md-4 col-6 order-md-1 order-1">
                <div class="d-flex align-items-center">
                  <span class="text-body-secondary fs-sm">Show</span>
                  <select class="form-select form-select-flush w-auto">
                    <option value="5">5</option>
                    <option value="10">10</option>
                    <option value="15">15</option>
                    <option value="25">25</option>
                  </select>
                </div>
              </div>
              <div class="col col-md-4 col-12 order-md-2 order-3 text-center">
                <button class="btn btn-primary w-md-auto w-100" type="button">Load more posts</button>
              </div>
              <div class="col col-md-4 col-6 order-md-3 order-2">
                <nav aria-label="Page navigation">
                  {{ $posts->links('pagination::bootstrap-4') }}
                </nav>
              </div>
            </div>
          </div>
          <x-partials.sidebar/>
         </div>
         



</x-app-layout>
