<x-app-layout>

  
<!-- Page container -->
      <div class="container pt-5 pb-lg-5 pb-md-4 pb-2 my-5">
        
        <!-- Breadcrumb -->
        <nav aria-label="breadcrumb">
          <ol class="pt-lg-3 pb-lg-4 pb-2 breadcrumb">
            <li class="breadcrumb-item"><a href=" {{ route('dashboard') }} ">Home</a></li>
            <li class="breadcrumb-item"><a href=" {{ route('posts.index') }} ">Posts</a></li>
            <li class="breadcrumb-item active" aria-current="page">{{ $post->id }}</li>
          </ol>
        </nav>

        <div class="row mb-md-2 mb-xl-4">

          <!-- Blog posts -->
          <div class="col-lg-9 pe-lg-4 pe-xl-5">
            <h1 class="pb-3 pb-lg-4">Posts </h1>

            <!-- Posts list -->
           
                
            
            <article class="row g-0 border-0 mb-4">
              <a class="col-sm-5 bg-repeat-0 bg-size-cover bg-position-center rounded-5" href="{{ route('posts.show', $post) }}" style="background-image: url({{ $post->image_path ? asset('storage/' . $post->image_path) : 'https://thumb.ac-illust.com/b1/b170870007dfa419295d949814474ab2_t.jpeg' }}); min-height: 14rem" aria-label="Post image"></a>
              <div class="col-sm-7">
                <div class="pt-4 pb-sm-4 ps-sm-4 pe-lg-4">
                  <h3>
                    <a href="{{ route('posts.show', $post) }}">{{ $post->title }}</a>
                  </h3>
                  <p class="d-sm-none d-md-block">{{  Str::limit($post->content, 100) }}</p>
                  <div class="d-flex flex-wrap align-items-center mt-n2">
                    <a class="nav-link text-body-secondary fs-sm fw-normal p-0 mt-2 me-3" href="#">
                      6
                      <i class="ai-share fs-lg ms-1"></i>
                    </a>
                    <a class="nav-link text-body-secondary fs-sm fw-normal d-flex align-items-end p-0 mt-2" href="#">
                      12
                      <i class="ai-message fs-lg ms-1"></i>
                    </a>
                    <span class="fs-xs opacity-20 mt-2 mx-3">|</span>
                    <span class="fs-sm text-body-secondary mt-2">
                      @if($post->published_at)
                                   Publicado el {{ $post->published_at->format('d/m/Y') }}
                                @else
                                    <em>(No publicado)</em>
                                @endif
                    </span>
                    <span class="fs-xs opacity-20 mt-2 mx-3">|</span>
                    
                    {{-- <a class="badge text-nav fs-xs border mt-2" href="#">Business</a> --}}
                  </div>
                  Publicado por <strong>{{ $post->user->name }}</strong>
                </div>
              </div>
            </article>
            {!! str($post->content)->sanitizeHtml() !!}
            
            
            
            

</x-app-layout>


