<!DOCTYPE html>
<html lang="en" data-bs-theme="light">
  
<!-- Mirrored from stackbros.in/around/blog-list-sidebar.html by HTTrack Website Copier/3.x [XR&CO'2014], Wed, 23 Apr 2025 16:26:43 GMT -->
<head>
  <!-- Scripts y Select2 -->
  <link href="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/css/select2.min.css" rel="stylesheet" />
  <script src="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/js/select2.min.js"></script>
  <script src="https://unpkg.com/cropperjs"></script>
    <meta charset="utf-8">

    <!-- Viewport -->
    <meta name="viewport" content="width=device-width, initial-scale=1, minimum-scale=1, maximum-scale=1, viewport-fit=cover">
    
    <!-- SEO meta tags -->
    <title>Tecolli Carbon Cluster</title>
    <meta name="description" content="Juntos para disminuir nuestra huella de carbono">
    <meta name="keywords" content="bootstrap, business, corporate, coworking space, services, creative agency, dashboard, e-commerce, mobile app showcase, saas, multipurpose, product landing, shop, software, ui kit, web studio, landing, light and dark mode, html5, css3, javascript, gallery, slider, touch, creative">
    <meta name="author" content="StackBros">

    <!-- Webmanifest + Favicon / App icons -->
    <link rel="manifest" href="manifest.json">
    <link rel="icon" type="image/png" href="{{ asset('assets/tecolli-hojita.png') }}" sizes="32x32">
    <link rel="apple-touch-icon" href="{{ asset('assets/tecolli180x180.png') }}">
    
    <!-- Imagen al compartir (Open Graph) -->
    <meta property="og:image" content="{{ asset('assets/tecolli180x180.png') }}">
    <meta property="og:image:type" content="image/png">
    <meta property="og:image:width" content="180">
    <meta property="og:image:height" content="180">
        
    <!-- Theme switcher (color modes) -->
    <script src="{{ asset('assets/js/theme-switcher.js') }}"></script>
    <link rel="stylesheet" href="{{ asset('css/gradiante.css') }}">

    <!-- Import Google font (Inter) -->
    <link rel="preconnect" href="https://fonts.googleapis.com/">
    <link rel="preconnect" href="https://fonts.gstatic.com/" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@400;500;600;700;800&amp;display=swap" rel="stylesheet" id="google-font">

    <!-- Font icons -->
    <link rel="stylesheet" href="{{ asset('assets/icons/around-icons.min.css') }}">

    <!-- Theme styles + Bootstrap -->
    <link rel="stylesheet" media="screen" href="{{ asset('assets/css/theme.min.css') }}">

    <!-- Page loading scripts -->
    <script>
      (function () {
        window.onload = function () {
          const preloader = document.querySelector('.page-loading')
          preloader.classList.remove('active')
          setTimeout(function () {
            preloader.remove()
          }, 1500)
        }
      })()
    </script>
</head>
  <body>
    {{-- Menu --}}
    <section class="navbar navbar-expand-lg bg-light">
      <!-- Theme switcher -->
      <div class="container">
        
              <a class="navbar-brand pe-sm-3" href="{{ url('/') }}">
            <span class="text-primary flex-shrink-0 me-2">
              <img src="{{ asset('assets/logo.png') }}" alt="Logo" class="img-fluid" style="max-height: 30px;">
            </span>
          </a>
              <div class="form-check form-switch mode-switch order-lg-2 me-3 me-lg-4 ms-auto" data-bs-toggle="mode">
                <input class="form-check-input" type="checkbox" id="theme-mode">
                <label class="form-check-label" for="theme-mode">
                  <i class="ai-sun fs-lg"></i>
                </label>
                <label class="form-check-label" for="theme-mode">
                  <i class="ai-moon fs-lg"></i>
                </label>
              </div>
              
            </div>
          
    </section>
    
    <!-- Header / Jumbotron -->
    <section class="text-center py-5" id="welcome-message">
      <div class="container">
        <h1 class="text-white display-4 fw-bold mb-4">
        Registro completado
        </h1>
        <p class="lead mb-4">
          En breve recibirás en tu correo 2 documentos PDF exclusivos, con insights del Mercado de Carbono que no te puedes perder.
        </p>
        <p>
            <b>
                Gracias por contribuir a diseñar una plataforma más útil y una red de colaboración más sólida para todo el sector.
            </b>
        </p>
      </div>
      <div class="d-flex flex-column flex-sm-row justify-content-center gap-2">
          <a class="btn btn-primary btn-lg d-inline-flex align-items-center"
          id="btn-comenzar" href="{{route('welcome')}}">
            Regresar
            <svg
              class="ms-2"
              xmlns="http://www.w3.org/2000/svg"
              fill="none"
              viewBox="0 0 14 10"
              width="14"
              height="14"
            >
              <path
                stroke="currentColor"
                stroke-linecap="round"
                stroke-linejoin="round"
                stroke-width="2"
                d="M1 5h12m0 0L9 1m4 4L9 9"
              />
            </svg>
        </a>
         <!-- Botón secundario (descargar documento) -->
    <a class=" btn btn-outline-secondary btn-lg d-inline-flex align-items-center"
       href="{{ asset('storage/documents-tecolli/TECOLLI - ONE-PAGER Founding Cohort.pdf') }}"
       download>
        Descargar documento
        <svg class="ms-2" xmlns="http://www.w3.org/2000/svg" fill="none"
             viewBox="0 0 20 20" width="18" height="18">
            <path stroke="currentColor" stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                  d="M4 14v2h12v-2M10 3v9m0 0l-3-3m3 3l3-3" />
        </svg>
    </a>
        </div>
    </section>
  <!-- Redirección automática después de 15 segundos -->
  <script>
    document.addEventListener("DOMContentLoaded", function() {
      setTimeout(function() {
        window.location.href = '/';
      }, 15000);
    });
  </script>
</body>

  </body>
  <script>
  document.addEventListener("DOMContentLoaded", function() {
    const btn = document.getElementById("btn-comenzar");
    const welcome = document.getElementById("welcome-message");
    const form = document.getElementById("formulario");

    btn.addEventListener("click", function() {
      welcome.style.display = "none";   // Oculta el mensaje de bienvenida
      form.style.display = "block";     // Muestra el formulario
      //form.scrollIntoView({ behavior: "smooth" });
      window.scrollTo({ top: 0, behavior: "smooth" }); // Opcional: sube la pantalla al inicio
    });
  });
</script>
<style>
  #welcome-message {
    min-height: 100vh;            /* ocupa todo el alto de la pantalla */
    display: flex;                /* activa flexbox */
    flex-direction: column;       /* apila título, párrafo y botón */
    justify-content: center;      /* centra verticalmente */
    align-items: center;          /* centra horizontalmente */
    text-align: center;           /* centra el texto */
    padding: 2rem;                /* algo de espacio interno */
  }
#welcome-message {
  min-height: 100vh;
  display: flex;
  flex-direction: column;
  justify-content: center;
  align-items: center;
  text-align: center;
  padding: 2rem;
  color: white;
  background: 
    linear-gradient(rgba(0, 0, 0, 0.5), rgba(0, 0, 0, 0.5)), 
    url("https://images.unsplash.com/photo-1632235967169-ebff04d451d2?q=80&w=1169&auto=format&fit=crop&ixlib=rb-4.1.0&ixid=M3wxMjA3fDB8MHxwaG90by1wYWdlfHx8fGVufDB8fHx8fA%3D%3D");
  background-size: cover;
  background-position: center;
}

#final-message {
  display: none; /* oculto por defecto */
}
</style>
<script>
  document.addEventListener("DOMContentLoaded", function() {
    // Cambia la ruta al PDF en tu servidor
    const pdfUrl = "{{ asset('storage/documents-tecolli/TECOLLI - ONE-PAGER Founding Cohort.pdf') }}";

    // Crea un link temporal y simula el clic
    const link = document.createElement('a');
    link.href = pdfUrl;
    link.download = 'TECOLLI - ONE-PAGER Founding Cohort.pdf'; // nombre con el que se descargará
    document.body.appendChild(link);
    link.click();
    document.body.removeChild(link);
  });
</script>
