<!DOCTYPE html>
<html lang="en" data-bs-theme="light">
  
<!-- Mirrored from stackbros.in/around/blog-list-sidebar.html by HTTrack Website Copier/3.x [XR&CO'2014], Wed, 23 Apr 2025 16:26:43 GMT -->
<head>
  <!-- Scripts y Select2 -->
  <link href="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/css/select2.min.css" rel="stylesheet" />
  <script src="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/js/select2.min.js"></script>
  <script src="https://unpkg.com/cropperjs"></script>
    <meta charset="utf-8">

    <!-- Viewport -->
    <meta name="viewport" content="width=device-width, initial-scale=1, minimum-scale=1, maximum-scale=1, viewport-fit=cover">
    
    <!-- SEO meta tags -->
    <title>Tecolli Carbon Cluster</title>
    <meta name="description" content="Juntos para disminuir nuestra huella de carbono">
    <meta name="keywords" content="bootstrap, business, corporate, coworking space, services, creative agency, dashboard, e-commerce, mobile app showcase, saas, multipurpose, product landing, shop, software, ui kit, web studio, landing, light and dark mode, html5, css3, javascript, gallery, slider, touch, creative">
    <meta name="author" content="StackBros">

    <!-- Webmanifest + Favicon / App icons -->
    <link rel="manifest" href="manifest.json">
    <link rel="icon" type="image/png" href="{{ asset('assets/tecolli-hojita.png') }}" sizes="32x32">
    <link rel="apple-touch-icon" href="{{ asset('assets/tecolli180x180.png') }}">
    
    <!-- Imagen al compartir (Open Graph) -->
    <meta property="og:image" content="{{ asset('assets/tecolli180x180.png') }}">
    <meta property="og:image:type" content="image/png">
    <meta property="og:image:width" content="180">
    <meta property="og:image:height" content="180">
        
    <!-- Theme switcher (color modes) -->
    <script src="{{ asset('assets/js/theme-switcher.js') }}"></script>
    <link rel="stylesheet" href="{{ asset('css/gradiante.css') }}">

    <!-- Import Google font (Inter) -->
    <link rel="preconnect" href="https://fonts.googleapis.com/">
    <link rel="preconnect" href="https://fonts.gstatic.com/" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@400;500;600;700;800&amp;display=swap" rel="stylesheet" id="google-font">

    <!-- Font icons -->
    <link rel="stylesheet" href="{{ asset('assets/icons/around-icons.min.css') }}">

    <!-- Theme styles + Bootstrap -->
    <link rel="stylesheet" media="screen" href="{{ asset('assets/css/theme.min.css') }}">

    <!-- Page loading scripts -->
    <script>
      (function () {
        window.onload = function () {
          const preloader = document.querySelector('.page-loading')
          preloader.classList.remove('active')
          setTimeout(function () {
            preloader.remove()
          }, 1500)
        }
      })()
    </script>
</head>
  <body>
    {{-- Menu --}}
    <section class="navbar navbar-expand-lg bg-light">
      <!-- Theme switcher -->
      <div class="container">
        
              <a class="navbar-brand pe-sm-3" href="{{ url('/') }}">
            <span class="text-primary flex-shrink-0 me-2">
              <img src="{{ asset('assets/logo.png') }}" alt="Logo" class="img-fluid" style="max-height: 30px;">
            </span>
          </a>
              <div class="form-check form-switch mode-switch order-lg-2 me-3 me-lg-4 ms-auto" data-bs-toggle="mode">
                <input class="form-check-input" type="checkbox" id="theme-mode">
                <label class="form-check-label" for="theme-mode">
                  <i class="ai-sun fs-lg"></i>
                </label>
                <label class="form-check-label" for="theme-mode">
                  <i class="ai-moon fs-lg"></i>
                </label>
              </div>
              
            </div>
          
    </section>
    
    <!-- Header / Jumbotron -->
    <section class="text-center py-5" id="welcome-message">
      <div class="container">
        <h1 class="text-white display-4 fw-bold mb-4">
        Compártenos tus necesidades como actor del Mercado de Carbono
        </h1>
        <p class="lead mb-4">
          Y accede a <b>La Guía para el Registro de Proyectos</b> y más información de <b>Las Entidades Involucradas.</b>
        </p>
      </div>
      <div class="d-flex flex-column flex-sm-row justify-content-center gap-2">
          <button class="btn btn-primary btn-lg d-inline-flex align-items-center"
          id="btn-comenzar">
            Comenzar
            <svg
              class="ms-2"
              xmlns="http://www.w3.org/2000/svg"
              fill="none"
              viewBox="0 0 14 10"
              width="14"
              height="14"
            >
              <path
                stroke="currentColor"
                stroke-linecap="round"
                stroke-linejoin="round"
                stroke-width="2"
                d="M1 5h12m0 0L9 1m4 4L9 9"
              />
            </svg>
          </button>
        </div>
    </section>
    <!-- Formulario -->
    <section class="py-5" id="formulario" style="display:none;">
               
      <div class="container">
              <h2 class="pb-4">
                <svg xmlns="http://www.w3.org/2000/svg" width="28" height="28" fill="currentColor" class="bi bi-clipboard-pulse pb-1" viewBox="0 0 16 16">
                  <path fill-rule="evenodd" d="M10 1.5a.5.5 0 0 0-.5-.5h-3a.5.5 0 0 0-.5.5v1a.5.5 0 0 0 .5.5h3a.5.5 0 0 0 .5-.5zm-5 0A1.5 1.5 0 0 1 6.5 0h3A1.5 1.5 0 0 1 11 1.5v1A1.5 1.5 0 0 1 9.5 4h-3A1.5 1.5 0 0 1 5 2.5zm-2 0h1v1H3a1 1 0 0 0-1 1V14a1 1 0 0 0 1 1h10a1 1 0 0 0 1-1V3.5a1 1 0 0 0-1-1h-1v-1h1a2 2 0 0 1 2 2V14a2 2 0 0 1-2 2H3a2 2 0 0 1-2-2V3.5a2 2 0 0 1 2-2m6.979 3.856a.5.5 0 0 0-.968.04L7.92 10.49l-.94-3.135a.5.5 0 0 0-.895-.133L4.232 10H3.5a.5.5 0 0 0 0 1h1a.5.5 0 0 0 .416-.223l1.41-2.115 1.195 3.982a.5.5 0 0 0 .968-.04L9.58 7.51l.94 3.135A.5.5 0 0 0 11 11h1.5a.5.5 0 0 0 0-1h-1.128z"/>
                </svg>
                Formulario de necesidades
              </h2>
              <form method="POST" action="{{ route('prerregistros.store') }}">
                    @csrf
                    <!-- Pregunta 1: alcance_geografico -->
                    <div class="mb-4">
                       <div class="d-flex flex-column mb-3">
                        {{-- Badge --}}
                        <span class="badge text-primary bg-primary-subtle text-small px-2 py-1 rounded mb-1" style="width:100px;">
                          <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor" class="bi bi-compass" viewBox="0 0 16 16">
                            <path d="M8 16.016a7.5 7.5 0 0 0 1.962-14.74A1 1 0 0 0 9 0H7a1 1 0 0 0-.962 1.276A7.5 7.5 0 0 0 8 16.016m6.5-7.5a6.5 6.5 0 1 1-13 0 6.5 6.5 0 0 1 13 0"/>
                            <path d="m6.94 7.44 4.95-2.83-2.83 4.95-4.949 2.83 2.828-4.95z"/>
                          </svg>
                          Alcance
                        </span>
                        <h4>
                          1. ¿Cuál es el alcance geográfico de sus servicios? (Puede elegir más de una opción)
                        </h4>
                      </div>
                      <div class="form-check">
                        <input class="form-check-input" type="checkbox" name="alcance_geografico[]" value="Latinoamérica" id="latam">
                        <label class="form-check-label" for="latam">Latinoamérica</label>
                      </div>
                      <div class="form-check">
                        <input class="form-check-input" type="checkbox" name="alcance_geografico[]" value="Norteamérica" id="norteamerica">
                        <label class="form-check-label" for="norteamerica">Norteamérica</label>
                      </div>
                      <!-- agrega los demás con value -->
                      <div class="form-check">
                        <input class="form-check-input" type="checkbox" name="alcance_geografico[]" value="Europa" id="europa">
                        <label class="form-check-label" for="europa">Europa</label>
                      </div>
                      <div class="form-check">
                        <input class="form-check-input" type="checkbox" name="alcance_geografico[]" value="África" id="africa">
                        <label class="form-check-label" for="africa">África</label>
                      </div>
                      <div class="form-check">
                        <input class="form-check-input" type="checkbox" name="alcance_geografico[]" value="Asia" id="asia">
                        <label class="form-check-label" for="asia">Asia</label>
                      </div>
                      <div class="form-check">
                        <input class="form-check-input" type="checkbox" name="alcance_geografico[]" value="Australia" id="australia">
                        <label class="form-check-label" for="australia">Australia</label>
                      </div>
                    </div>

                    <!-- Pregunta 2: servicios -->
                    <div class="mb-4">
                      <div class="d-flex flex-column mb-3">
                        {{-- Badge --}}
                          <span class="badge text-primary bg-primary-subtle text-small px-2 py-1 rounded mb-1" style="width:100px;">
                            <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor" class="bi bi-question-circle me-2" viewBox="0 0 16 16">
                              <path d="M8 15A7 7 0 1 1 8 1a7 7 0 0 1 0 14m0 1A8 8 0 1 0 8 0a8 8 0 0 0 0 16"/>
                              <path d="M5.255 5.786a.237.237 0 0 0 .241.247h.825c.138 0 .248-.113.266-.25.09-.656.54-1.134 1.342-1.134.686 0 1.314.343 1.314 1.168 0 .635-.374.927-.965 1.371-.673.489-1.206 1.06-1.168 1.987l.003.217a.25.25 0 0 0 .25.246h.811a.25.25 0 0 0 .25-.25v-.105c0-.718.273-.927 1.01-1.486.609-.463 1.244-.977 1.244-2.056 0-1.511-1.276-2.241-2.673-2.241-1.267 0-2.655.59-2.75 2.286m1.557 5.763c0 .533.425.927 1.01.927.609 0 1.028-.394 1.028-.927 0-.552-.42-.94-1.029-.94-.584 0-1.009.388-1.009.94"/>
                            </svg>
                            Servicios
                          </span>

                        <h4>
                          2. ¿Cuáles son los servicios que ofrece? (Puede elegir más de una opción)
                        </h4>
                      </div>
                      @php
                        $services = [
                          'Consultoría','Auditoría','Desarrollo de proyectos',
                          'Desarrollo de tecnologías/ soluciones climáticas','Estándar de carbono',
                          'Compra de créditos de carbono','Venta de créditos de carbono',
                          'Política climática','Investigación','Fondeo a proyectos/Banca','Otro (especifique)'
                        ];
                      @endphp
                      @foreach($services as $i => $service)
                        <div class="form-check">
                          <input class="form-check-input" type="checkbox" name="servicios[]" value="{{ $service }}" id="service{{ $i }}">
                          <label class="form-check-label" for="service{{ $i }}">{{ $service }}</label>
                        </div>
                      @endforeach
                    </div>

                    <!-- Pregunta 3: necesidades -->
                    <div class="mb-4">
                       <div class="d-flex flex-column mb-3">
                          {{-- Badge --}}
                            <span class="badge text-primary bg-primary-subtle text-small px-2 py-1 rounded mb-1" style="width:100px;">
                              <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor" class="bi bi-info-circle" viewBox="0 0 16 16">
                                <path d="M8 15A7 7 0 1 1 8 1a7 7 0 0 1 0 14m0 1A8 8 0 1 0 8 0a8 8 0 0 0 0 16"/>
                                <path d="m8.93 6.588-2.29.287-.082.38.45.083c.294.07.352.176.288.469l-.738 3.468c-.194.897.105 1.319.808 1.319.545 0 1.178-.252 1.465-.598l.088-.416c-.2.176-.492.246-.686.246-.275 0-.375-.193-.304-.533zM9 4.5a1 1 0 1 1-2 0 1 1 0 0 1 2 0"/>
                              </svg>
                              Urgente
                            </span>

                          <h4>
                            3. De las siguientes, ¿cuáles son sus necesidades más urgentes? (Puede elegir más de una opción)
                          </h4>
                        </div>
                      @php
                        $needs = [
                          'Formar parte de un directorio especializado de proveedores de servicios del mercado de carbono para una mejor captación de clientes calificados',
                          'Tener acceso a proveedores del mercado de carbono confiables',
                          'Un foro especializado para publicar requerimientos específicos de mi empresa',
                          'Un foro especializado para consultar requerimientos de otras empresas',
                          'Encontrar personal calificado',
                          'Encontrar un empleo en el área de la acción climática',
                          'Tener visibilidad y presencia en un medio especializado en mercados de carbono',
                          'Generar alianzas y hacer networking'
                        ];
                      @endphp
                      @foreach($needs as $i => $need)
                        <div class="form-check">
                          <input class="form-check-input" type="checkbox" name="necesidades[]" value="{{ $need }}" id="need{{ $i }}">
                          <label class="form-check-label" for="need{{ $i }}">{{ $need }}</label>
                        </div>
                      @endforeach
                    </div>

                    <!-- Pregunta 4-6: datos -->
                    <div class="mb-3">
                      <h3>4. Nombre y apellido</h3>
                      <input type="text" name="nombre_completo" class="form-control" required placeholder="Nombre completo">
                    </div>
                    <div class="mb-3">
                      <h3>5. Nombre de su empresa</h3>
                      <input type="text" name="nombre_empresa" class="form-control" required placeholder="Nombre de la empresa">
                    </div>
                    <div class="mb-3">
                      <h3>6. Correo</h3>
                      <input type="email" name="email" class="form-control" required placeholder="Email">
                    </div>

                    <!-- Pregunta 7: permiso_imagen -->
                    <div class="mb-4">
                      <h4>7. Durante el México Carbon Forum, ¿podríamos usar su imagen si fuera elegida para este fin?</h4>
                      <div class="form-check">
                        <input class="form-check-input" type="radio" name="permiso_imagen" value="1" id="imagenSi" required>
                        <label class="form-check-label" for="imagenSi">Sí</label>
                      </div>
                      <div class="form-check">
                        <input class="form-check-input" type="radio" name="permiso_imagen" value="0" id="imagenNo">
                        <label class="form-check-label" for="imagenNo">No</label>
                      </div>
                    </div>

                    <!-- Pregunta 8: fundador -->
                    <div class="mb-4">
                      <h4>8. Tecolli está buscando su “Founding Cohort”. ¿Desea ser parte de este grupo fundador?</h4>
                      <div class="form-check">
                        <input class="form-check-input" type="radio" name="fundador" value="1" id="foundingSi" required>
                        <label class="form-check-label" for="foundingSi">Sí, envíenme más información</label>
                      </div>
                      <div class="form-check">
                        <input class="form-check-input" type="radio" name="fundador" value="0" id="foundingNo">
                        <label class="form-check-label" for="foundingNo">No, gracias</label>
                      </div>
                    </div>

                    <div class="d-flex flex-column flex-sm-row justify-content-center gap-2">
                    <!-- Botón enviar -->
                    <button type="submit" class="btn btn-primary btn-lg d-inline-flex align-items-center">
                      Enviar
                       <svg
                        class="ms-2"
                        xmlns="http://www.w3.org/2000/svg"
                        fill="none"
                        viewBox="0 0 14 10"
                        width="14"
                        height="14"
                        >
                        <path
                        stroke="currentColor"
                        stroke-linecap="round"
                        stroke-linejoin="round"
                        stroke-width="2"
                        d="M1 5h12m0 0L9 1m4 4L9 9"
                        />
                      </svg>
                    </button>
                    </div>
        </form>
      </div>
  </section>
  </body>
  <script>
  document.addEventListener("DOMContentLoaded", function() {
    const btn = document.getElementById("btn-comenzar");
    const welcome = document.getElementById("welcome-message");
    const form = document.getElementById("formulario");

    btn.addEventListener("click", function() {
      welcome.style.display = "none";   // Oculta el mensaje de bienvenida
      form.style.display = "block";     // Muestra el formulario
      //form.scrollIntoView({ behavior: "smooth" });
      window.scrollTo({ top: 0, behavior: "smooth" }); // Opcional: sube la pantalla al inicio
    });
  });
</script>
<style>
  #welcome-message {
    min-height: 100vh;            /* ocupa todo el alto de la pantalla */
    display: flex;                /* activa flexbox */
    flex-direction: column;       /* apila título, párrafo y botón */
    justify-content: center;      /* centra verticalmente */
    align-items: center;          /* centra horizontalmente */
    text-align: center;           /* centra el texto */
    padding: 2rem;                /* algo de espacio interno */
  }
#welcome-message {
  min-height: 100vh;
  display: flex;
  flex-direction: column;
  justify-content: center;
  align-items: center;
  text-align: center;
  padding: 2rem;
  color: white;
  background: 
    linear-gradient(rgba(0, 0, 0, 0.5), rgba(0, 0, 0, 0.5)), 
    url("https://images.unsplash.com/photo-1632235967169-ebff04d451d2?q=80&w=1169&auto=format&fit=crop&ixlib=rb-4.1.0&ixid=M3wxMjA3fDB8MHxwaG90by1wYWdlfHx8fGVufDB8fHx8fA%3D%3D");
  background-size: cover;
  background-position: center;
}

#final-message {
  display: none; /* oculto por defecto */
}
</style>
