<x-action-section>
    <x-slot name="title" class="mt-4">
        <i class="ai-trash text-danger me-2"></i>
        {{ __('Delete Account') }}
    </x-slot>

    <x-slot name="description">
        {{ __('Permanently delete your account.') }}
    </x-slot>

    <x-slot name="content">
        <div class="card border-0 shadow-sm rounded-3 p-4 w-100">
            <div class="card-body">
                <div class="alert alert-warning">
                    {{ __('Once your account is deleted, all of its resources and data will be permanently deleted. Before deleting your account, please download any data or information that you wish to retain.') }}
                </div>

                <div class="d-flex justify-content-end mt-3">
                    <button class="btn btn-danger" wire:click="confirmUserDeletion" wire:loading.attr="disabled">
                        {{ __('Delete Account') }}
                    </button>
                </div>
            </div>
        </div>

        <!-- Delete User Confirmation Modal -->
        <x-dialog-modal wire:model.live="confirmingUserDeletion">
            <x-slot name="title">
                <i class="ai-trash text-danger me-2"></i>
                {{ __('Delete Account') }}
            </x-slot>

            <x-slot name="content">
                <p>{{ __('Are you sure you want to delete your account? Once your account is deleted, all of its resources and data will be permanently deleted. Please enter your password to confirm you would like to permanently delete your account.') }}</p>

                <div class="mt-3" x-data="{}" x-on:confirming-delete-user.window="setTimeout(() => $refs.password.focus(), 250)">
                    <input type="password" 
                           class="form-control w-75" 
                           placeholder="{{ __('Password') }}" 
                           x-ref="password"
                           wire:model="password"
                           wire:keydown.enter="deleteUser">
                    
                    <x-input-error for="password" class="text-danger mt-2" />
                </div>
            </x-slot>

            <x-slot name="footer">
                <div class="d-flex justify-content-end">
                    <button class="btn btn-secondary me-2" wire:click="$toggle('confirmingUserDeletion')" wire:loading.attr="disabled">
                        {{ __('Cancel') }}
                    </button>

                    <button class="btn btn-danger" wire:click="deleteUser" wire:loading.attr="disabled">
                        {{ __('Delete Account') }}
                    </button>
                </div>
            </x-slot>
        </x-dialog-modal>
    </x-slot>
</x-action-section>
