<x-action-section>
    <x-slot name="title">
        <svg xmlns="http://www.w3.org/2000/svg" width="32" height="32" fill="currentColor" class="bi bi-pc-display" viewBox="0 0 16 16">
            <path d="M8 1a1 1 0 0 1 1-1h6a1 1 0 0 1 1 1v14a1 1 0 0 1-1 1H9a1 1 0 0 1-1-1zm1 13.5a.5.5 0 1 0 1 0 .5.5 0 0 0-1 0m2 0a.5.5 0 1 0 1 0 .5.5 0 0 0-1 0M9.5 1a.5.5 0 0 0 0 1h5a.5.5 0 0 0 0-1zM9 3.5a.5.5 0 0 0 .5.5h5a.5.5 0 0 0 0-1h-5a.5.5 0 0 0-.5.5M1.5 2A1.5 1.5 0 0 0 0 3.5v7A1.5 1.5 0 0 0 1.5 12H6v2h-.5a.5.5 0 0 0 0 1H7v-4H1.5a.5.5 0 0 1-.5-.5v-7a.5.5 0 0 1 .5-.5H7V2z"/>
        </svg>
        {{ __('Browser Sessions') }}
    </x-slot>

    <x-slot name="description">
        {{ __('Manage and log out your active sessions on other browsers and devices.') }}
    </x-slot>

    <x-slot name="content">
        
            <div>
                {{ __('If necessary, you may log out of all of your other browser sessions across all of your devices. Some of your recent sessions are listed below; however, this list may not be exhaustive. If you feel your account has been compromised, you should also update your password.') }}
            </div>
      

        @if (count($this->sessions) > 0)
            <div class="mt-5">
                @foreach ($this->sessions as $session)
                    <div class="d-flex align-items-center mb-3 p-2">
                        <div class="flex-shrink-0 fs-3 text-secondary">
                            <i class="ai-browser"></i>
                        </div>

                        <div class="ms-3">
                            <div class="fw-semibold">
                                {{ $session->agent->platform() ?? __('Unknown') }} - {{ $session->agent->browser() ?? __('Unknown') }}
                            </div>

                            <div class="text-muted small">
                                {{ $session->ip_address }},
                                @if ($session->is_current_device)
                                    <span class="text-success fw-bold">{{ __('This device') }}</span>
                                @else
                                    {{ __('Last active') }} {{ $session->last_active }}
                                @endif
                            </div>
                        </div>
                    </div>
                @endforeach
            </div>
        @endif

        <div class="d-flex justify-content-end mt-3">
            <button class="btn btn-primary d-flex align-items-center" wire:click="confirmLogout" wire:loading.attr="disabled">
                <i class="ai-logout me-1"></i> {{ __('Log Out Other Browser Sessions') }}
            </button>

            <x-action-message class="ms-3 mt-2 mt-sm-0" on="loggedOut">
                <i class="ai-check-circle text-success me-1"></i>{{ __('Done.') }}
            </x-action-message>
        </div>

        <!-- Log Out Other Devices Confirmation Modal -->
        <x-dialog-modal wire:model.live="confirmingLogout">
            <x-slot name="title">
                <i class="ai-browser text-primary me-2 fs-4"></i>
                {{ __('Log Out Other Browser Sessions') }}
            </x-slot>

            <x-slot name="content">
                <p>
                    <i class="ai-info-circle me-1"></i>
                    {{ __('Please enter your password to confirm you would like to log out of your other browser sessions across all of your devices.') }}
                </p>

                <div class="mt-3" x-data="{}" x-on:confirming-logout-other-browser-sessions.window="setTimeout(() => $refs.password.focus(), 250)">
                    <input type="password"
                           class="form-control w-75"
                           placeholder="{{ __('Password') }}"
                           x-ref="password"
                           wire:model="password"
                           wire:keydown.enter="logoutOtherBrowserSessions">

                    <x-input-error for="password" class="text-danger mt-2" />
                </div>
            </x-slot>

            <x-slot name="footer">
                <div class="d-flex justify-content-end">
                    <button class="btn btn-secondary me-2 d-flex align-items-center" wire:click="$toggle('confirmingLogout')" wire:loading.attr="disabled">
                        <i class="ai-x-circle me-1"></i> {{ __('Cancel') }}
                    </button>

                    <button class="btn btn-primary d-flex align-items-center" wire:click="logoutOtherBrowserSessions" wire:loading.attr="disabled">
                        <i class="ai-logout me-1"></i> {{ __('Log Out Other Browser Sessions') }}
                    </button>
                </div>
            </x-slot>
        </x-dialog-modal>
    </x-slot>
</x-action-section>
