<x-action-section>
    <x-slot name="title" class="mt-4">
        <svg xmlns="http://www.w3.org/2000/svg" width="32" height="32" fill="currentColor" class="bi bi-shield-check" viewBox="0 0 16 16">
            <path d="M5.338 1.59a61 61 0 0 0-2.837.856.48.48 0 0 0-.328.39c-.554 4.157.726 7.19 2.253 9.188a10.7 10.7 0 0 0 2.287 2.233c.346.244.652.42.893.533q.18.085.293.118a1 1 0 0 0 .101.025 1 1 0 0 0 .1-.025q.114-.034.294-.118c.24-.113.547-.29.893-.533a10.7 10.7 0 0 0 2.287-2.233c1.527-1.997 2.807-5.031 2.253-9.188a.48.48 0 0 0-.328-.39c-.651-.213-1.75-.56-2.837-.855C9.552 1.29 8.531 1.067 8 1.067c-.53 0-1.552.223-2.662.524zM5.072.56C6.157.265 7.31 0 8 0s1.843.265 2.928.56c1.11.3 2.229.655 2.887.87a1.54 1.54 0 0 1 1.044 1.262c.596 4.477-.787 7.795-2.465 9.99a11.8 11.8 0 0 1-2.517 2.453 7 7 0 0 1-1.048.625c-.28.132-.581.24-.829.24s-.548-.108-.829-.24a7 7 0 0 1-1.048-.625 11.8 11.8 0 0 1-2.517-2.453C1.928 10.487.545 7.169 1.141 2.692A1.54 1.54 0 0 1 2.185 1.43 63 63 0 0 1 5.072.56"/>
            <path d="M10.854 5.146a.5.5 0 0 1 0 .708l-3 3a.5.5 0 0 1-.708 0l-1.5-1.5a.5.5 0 1 1 .708-.708L7.5 7.793l2.646-2.647a.5.5 0 0 1 .708 0"/>
        </svg>
            {{ __('Two Factor Authentication') }}
        
    </x-slot>

    <x-slot name="description">
        <p class="text-muted">
            {{ __('Add additional security to your account using two factor authentication.') }}
        </p>
    </x-slot>

    <x-slot name="content" class="card">
        <div class="card shadow-sm border-0">
            <div class="card-body">
                <h6 class="fw-bold">
                    @if ($this->enabled)
                        @if ($showingConfirmation)
                            {{ __('Finish enabling two factor authentication.') }}
                        @else
                            {{ __('You have enabled two factor authentication.') }}
                        @endif
                    @else
                        {{ __('You have not enabled two factor authentication.') }}
                    @endif
                </h6>

                <p class="text-muted small mt-2">
                    {{ __('When two factor authentication is enabled, you will be prompted for a secure, random token during authentication. You may retrieve this token from your phone\'s Google Authenticator application.') }}
                </p>

                @if ($this->enabled)
                    @if ($showingQrCode)
                        <div class="alert alert-info mt-3">
                            <strong>
                                @if ($showingConfirmation)
                                    {{ __('To finish enabling two factor authentication, scan the following QR code using your phone\'s authenticator application or enter the setup key and provide the generated OTP code.') }}
                                @else
                                    {{ __('Two factor authentication is now enabled. Scan the following QR code using your phone\'s authenticator application or enter the setup key.') }}
                                @endif
                            </strong>
                        </div>

                        <div class="bg-white p-3 d-inline-block rounded shadow-sm my-3">
                            {!! $this->user->twoFactorQrCodeSvg() !!}
                        </div>

                        <p class="small fw-bold mt-2">
                            {{ __('Setup Key') }}: {{ decrypt($this->user->two_factor_secret) }}
                        </p>

                        @if ($showingConfirmation)
                            <div class="form-group mt-3">
                                <x-label for="code" value="{{ __('Code') }}" />
                                <x-input id="code" type="text" name="code"
                                    class="form-control mt-1 w-50"
                                    inputmode="numeric" autofocus autocomplete="one-time-code"
                                    wire:model="code"
                                    wire:keydown.enter="confirmTwoFactorAuthentication" />
                                <x-input-error for="code" class="text-danger small mt-2" />
                            </div>
                        @endif
                    @endif

                    @if ($showingRecoveryCodes)
                        <div class="alert alert-warning mt-3">
                            <strong>Guarde estos códigos de recuperación en un administrador de contraseñas seguro.</strong>
                            <p class="small mb-0">
                                Se pueden utilizar para recuperar el acceso a su cuenta si pierde su dispositivo de autenticación de dos factores.
                            </p>
                        </div>

                        <div class="bg-light border rounded p-3 mt-3">
                            <div class="row row-cols-2 g-1 font-monospace small">
                                @foreach (json_decode(decrypt($this->user->two_factor_recovery_codes), true) as $code)
                                    <div>{{ $code }}</div>
                                @endforeach
                            </div>
                        </div>
                    @endif
                @endif

                <div class="mt-4 d-flex flex-wrap gap-2">
                    @if (! $this->enabled)
                        <x-confirms-password wire:then="enableTwoFactorAuthentication">
                            <x-button type="button" class="btn btn-primary" wire:loading.attr="disabled">
                                {{ __('Enable') }}
                            </x-button>
                        </x-confirms-password>
                    @else
                        @if ($showingRecoveryCodes)
                            <x-confirms-password wire:then="regenerateRecoveryCodes">
                                <x-secondary-button class="btn btn-outline-secondary me-2">
                                    {{ __('Regenerate Recovery Codes') }}
                                </x-secondary-button>
                            </x-confirms-password>
                        @elseif ($showingConfirmation)
                            <x-confirms-password wire:then="confirmTwoFactorAuthentication">
                                <x-button type="button" class="btn btn-success me-2" wire:loading.attr="disabled">
                                    {{ __('Confirm') }}
                                </x-button>
                            </x-confirms-password>
                        @else
                            <x-confirms-password wire:then="showRecoveryCodes">
                                <x-secondary-button class="btn btn-outline-secondary me-2">
                                    {{ __('Show Recovery Codes') }}
                                </x-secondary-button>
                            </x-confirms-password>
                        @endif

                        @if ($showingConfirmation)
                            <x-confirms-password wire:then="disableTwoFactorAuthentication">
                                <x-secondary-button class="btn btn-warning" wire:loading.attr="disabled">
                                    {{ __('Cancel') }}
                                </x-secondary-button>
                            </x-confirms-password>
                        @else
                            <x-confirms-password wire:then="disableTwoFactorAuthentication">
                                <x-danger-button class="btn btn-danger" wire:loading.attr="disabled">
                                    {{ __('Disable') }}
                                </x-danger-button>
                            </x-confirms-password>
                        @endif
                    @endif
                </div>
            </div>
        </div>
    </x-slot>
</x-action-section>
