<section class="">

    <div class="d-flex align-items-center pb-4">
      <svg xmlns="http://www.w3.org/2000/svg" width="32" height="32" fill="currentColor" class="bi bi-key" viewBox="0 0 16 16">
        <path d="M0 8a4 4 0 0 1 7.465-2H14a.5.5 0 0 1 .354.146l1.5 1.5a.5.5 0 0 1 0 .708l-1.5 1.5a.5.5 0 0 1-.708 0L13 9.207l-.646.647a.5.5 0 0 1-.708 0L11 9.207l-.646.647a.5.5 0 0 1-.708 0L9 9.207l-.646.647A.5.5 0 0 1 8 10h-.535A4 4 0 0 1 0 8m4-3a3 3 0 1 0 2.712 4.285A.5.5 0 0 1 7.163 9h.63l.853-.854a.5.5 0 0 1 .708 0l.646.647.646-.647a.5.5 0 0 1 .708 0l.646.647.646-.647a.5.5 0 0 1 .708 0l.646.647.793-.793-1-1h-6.63a.5.5 0 0 1-.451-.285A3 3 0 0 0 4 5"/>
        <path d="M4 8a1 1 0 1 1-2 0 1 1 0 0 1 2 0"/>
      </svg>
      <h2 class="h4 mb-0 ml-2">Actualizar contraseña</h2>
    </div>

    <form wire:submit.prevent="updatePassword" class="row g-3 g-sm-4 pb-3">
      <!-- Current Password -->
      <div class="col-sm-6">
        <label class="form-label" for="current_password">Contraseña actual</label>
        <div class="password-toggle">
          <input id="current_password" type="password"
                 class="form-control @error('current_password') is-invalid @enderror"
                 wire:model="state.current_password"
                 autocomplete="current-password">
          <label class="password-toggle-btn" aria-label="{{ __('Show/hide password') }}">
            <input class="password-toggle-check" type="checkbox">
            <span class="password-toggle-indicator"></span>
          </label>
        </div>
        <x-input-error for="current_password" class="invalid-feedback d-block" />
      </div>

      <div class="col-sm-6 d-flex align-items-end">
        <a class="d-inline-block fs-sm fw-semibold text-decoration-none mt-sm-4" href="{{ route('password.request') }}">
          ¿Olvidaste tu contraseña?
        </a>
      </div>

      <!-- New Password -->
      <div class="col-sm-6">
        <label class="form-label" for="password">Nueva contraseña</label>
        <div class="password-toggle">
          <input id="password" type="password"
                 class="form-control @error('password') is-invalid @enderror"
                 wire:model="state.password"
                 autocomplete="new-password">
          <label class="password-toggle-btn" aria-label="{{ __('Show/hide password') }}">
            <input class="password-toggle-check" type="checkbox">
            <span class="password-toggle-indicator"></span>
          </label>
        </div>
        <x-input-error for="password" class="invalid-feedback d-block" />
      </div>

      <!-- Confirm New Password -->
      <div class="col-sm-6">
        <label class="form-label" for="password_confirmation">Confirmar nueva contraseña</label>
        <div class="password-toggle">
          <input id="password_confirmation" type="password"
                 class="form-control @error('password_confirmation') is-invalid @enderror"
                 wire:model="state.password_confirmation"
                 autocomplete="new-password">
          <label class="password-toggle-btn" aria-label="{{ __('Show/hide password') }}">
            <input class="password-toggle-check" type="checkbox">
            <span class="password-toggle-indicator"></span>
          </label>
        </div>
        <x-input-error for="password_confirmation" class="invalid-feedback d-block" />
      </div>

      <!-- Info -->
      <div class="col-12">
        <div class="alert alert-info d-flex my-3 my-sm-4">
          <i class="ai-circle-info fs-xl me-2"></i>
          <p class="mb-0">La contraseña debe estar conformada por al menos 8 caracteres.</p>
        </div>
      </div>

      <!-- Actions -->
      <div class="col-12 d-flex justify-content-end pt-3">
        <x-action-message class="me-3 text-success" on="saved">
          {{ __('Saved.') }}
        </x-action-message>

        <button type="submit" class="btn btn-primary">
          Guardar
        </button>
      </div>
    </form>

</section>
