<section style="padding-top: 80px;">
    <div class="d-flex align-items-center ">
      <svg xmlns="http://www.w3.org/2000/svg" width="32" height="32" fill="currentColor" class="bi bi-person" viewBox="0 0 16 16">
        <path d="M8 8a3 3 0 1 0 0-6 3 3 0 0 0 0 6m2-3a2 2 0 1 1-4 0 2 2 0 0 1 4 0m4 8c0 1-1 1-1 1H3s-1 0-1-1 1-4 6-4 6 3 6 4m-1-.004c-.001-.246-.154-.986-.832-1.664C11.516 10.68 10.289 10 8 10s-3.516.68-4.168 1.332c-.678.678-.83 1.418-.832 1.664z"/>
      </svg>
      <h2 class="h4 mb-0">Información del usuario</h2>
    </div>

    <form wire:submit.prevent="updateProfileInformation" class="row g-3 g-sm-4 mt-0 mt-lg-2">

      <!-- Profile Photo -->
      @if (Laravel\Jetstream\Jetstream::managesProfilePhotos())
        <div class="col-12 d-flex align-items-center">
          <div x-data="{photoName: null, photoPreview: null}" class="dropdown">
            
            <!-- Current profile photo -->
            <a class="d-flex flex-column justify-content-end position-relative overflow-hidden rounded-circle bg-size-cover bg-position-center flex-shrink-0"
               href="#" data-bs-toggle="dropdown" aria-expanded="false"
               style="width: 80px; height: 80px; background-image: url({{ $this->user->profile_photo_url }});"
               aria-label="{{ __('Upload picture') }}">
              <span class="d-block text-light text-center lh-1 pb-1" style="background-color: rgba(0,0,0,.5)">
                <i class="ai-camera"></i>
              </span>
            </a>

            <!-- File input (hidden) -->
            <input type="file" id="photo" class="d-none"
                   wire:model.live="photo"
                   x-ref="photo"
                   x-on:change="
                        photoName = $refs.photo.files[0].name;
                        const reader = new FileReader();
                        reader.onload = (e) => { photoPreview = e.target.result; };
                        reader.readAsDataURL($refs.photo.files[0]);
                   " />

            <!-- Dropdown actions -->
            <div class="dropdown-menu my-1">
              <a class="dropdown-item fw-normal" href="#" x-on:click.prevent="$refs.photo.click()">
                <i class="ai-camera fs-base opacity-70 me-2"></i>
                {{ __('Upload new photo') }}
              </a>

              @if ($this->user->profile_photo_path)
                <a class="dropdown-item text-danger fw-normal" href="#"
                   wire:click.prevent="deleteProfilePhoto">
                  <i class="ai-trash fs-base me-2"></i>
                  {{ __('Delete photo') }}
                </a>
              @endif
            </div>
          </div>

          <div class="ps-3">
            <h3 class="h6 mb-1">{{ __('Profile picture') }}</h3>
            <p class="fs-sm text-body-secondary mb-0">{{ __('PNG or JPG no bigger than 1000px wide and tall.') }}</p>
            <x-input-error for="photo" class="text-danger mt-2" />
          </div>
        </div>
      @endif

      <!-- Name -->
      <div class="col-sm-6">
        <label class="form-label" for="name">{{ __('Name') }}</label>
        <input id="name" type="text"
               class="form-control @error('name') is-invalid @enderror"
               wire:model="state.name" required autocomplete="name">
        <x-input-error for="name" class="invalid-feedback d-block" />
      </div>

      <!-- Email -->
      <div class="col-sm-6">
        <label class="form-label" for="email">Email</label>
        <input id="email" type="email"
               class="form-control @error('email') is-invalid @enderror"
               wire:model="state.email" required autocomplete="username">
        <x-input-error for="email" class="invalid-feedback d-block" />

        @if (Laravel\Fortify\Features::enabled(Laravel\Fortify\Features::emailVerification()) && ! $this->user->hasVerifiedEmail())
          <p class="small text-muted mt-2">
            {{ __('Your email address is unverified.') }}
            <button type="button" class="btn btn-link p-0 align-baseline"
                    wire:click.prevent="sendEmailVerification">
              {{ __('Click here to re-send the verification email.') }}
            </button>
          </p>

          @if ($this->verificationLinkSent)
            <p class="small text-success mt-2">
              {{ __('A new verification link has been sent to your email address.') }}
            </p>
          @endif
        @endif
      </div>

      <!-- Actions -->
      <div class="col-12 d-flex justify-content-end pt-3">
        <x-action-message class="me-3 text-success" on="saved">
          {{ __('Saved.') }}
        </x-action-message>

        <button type="submit" class="btn btn-primary"
                wire:loading.attr="disabled" wire:target="photo">
          Guardar
        </button>
      </div>
    </form>

</section>
