{{-- Copia del header --}}
<!DOCTYPE html>
<html lang="en" data-bs-theme="light">
  
<!-- Mirrored from stackbros.in/around/blog-list-sidebar.html by HTTrack Website Copier/3.x [XR&CO'2014], Wed, 23 Apr 2025 16:26:43 GMT -->
<head>
    <meta charset="utf-8">

    <!-- Viewport -->
    <meta name="viewport" content="width=device-width, initial-scale=1, minimum-scale=1, maximum-scale=1, viewport-fit=cover">
    
    <!-- SEO meta tags -->
    <title>Around | Blog List with Sidebar</title>
    <meta name="description" content="Around - Multipurpose Bootstrap HTML Template">
    <meta name="keywords" content="bootstrap, business, corporate, coworking space, services, creative agency, dashboard, e-commerce, mobile app showcase, saas, multipurpose, product landing, shop, software, ui kit, web studio, landing, light and dark mode, html5, css3, javascript, gallery, slider, touch, creative">
    <meta name="author" content="StackBros">

    <!-- Webmanifest + Favicon / App icons -->
    <link rel="manifest" href="manifest.json">
    <link rel="icon" type="image/png" href="{{ asset('assets/app-icons/icon-32x32.png') }}" sizes="32x32">
    <link rel="apple-touch-icon" href="{{ asset('assets/app-icons/icon-180x180.png') }}">
        
    <!-- Theme switcher (color modes) -->
    <script src="{{ asset('assets/js/theme-switcher.js') }}"></script>

    <!-- Import Google font (Inter) -->
    <link rel="preconnect" href="https://fonts.googleapis.com/">
    <link rel="preconnect" href="https://fonts.gstatic.com/" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@400;500;600;700;800&amp;display=swap" rel="stylesheet" id="google-font">

    <!-- Font icons -->
    <link rel="stylesheet" href="{{ asset('assets/icons/around-icons.min.css') }}">

    <!-- Theme styles + Bootstrap -->
    <link rel="stylesheet" media="screen" href="{{ asset('assets/css/theme.min.css') }}">

    <!-- Page loading styles -->
    <style>
      .page-loading {
        position: fixed;
        top: 0;
        right: 0;
        bottom: 0;
        left: 0;
        width: 100%;
        height: 100%;
        -webkit-transition: all .4s .2s ease-in-out;
        transition: all .4s .2s ease-in-out;
        background-color: #fff;
        opacity: 0;
        visibility: hidden;
        z-index: 9999;
      }
      [data-bs-theme="dark"] .page-loading {
        background-color: #121519;
      }
      .page-loading.active {
        opacity: 1;
        visibility: visible;
      }
      .page-loading-inner {
        position: absolute;
        top: 50%;
        left: 0;
        width: 100%;
        text-align: center;
        -webkit-transform: translateY(-50%);
        transform: translateY(-50%);
        -webkit-transition: opacity .2s ease-in-out;
        transition: opacity .2s ease-in-out;
        opacity: 0;
      }
      .page-loading.active > .page-loading-inner {
        opacity: 1;
      }
      .page-loading-inner > span {
        display: block;
        font-family: "Inter", sans-serif;
        font-size: 1rem;
        font-weight: normal;
        color: #6f788b;
      }
      [data-bs-theme="dark"] .page-loading-inner > span {
        color: #fff;
        opacity: .6;
      }
      .page-spinner {
        display: inline-block;
        width: 2.75rem;
        height: 2.75rem;
        margin-bottom: .75rem;
        vertical-align: text-bottom;
        background-color: #d7dde2; 
        border-radius: 50%;
        opacity: 0;
        -webkit-animation: spinner .75s linear infinite;
        animation: spinner .75s linear infinite;
      }
      [data-bs-theme="dark"] .page-spinner {
        background-color: rgba(255,255,255,.25);
      }
      @-webkit-keyframes spinner {
        0% {
          -webkit-transform: scale(0);
          transform: scale(0);
        }
        50% {
          opacity: 1;
          -webkit-transform: none;
          transform: none;
        }
      }
      @keyframes spinner {
        0% {
          -webkit-transform: scale(0);
          transform: scale(0);
        }
        50% {
          opacity: 1;
          -webkit-transform: none;
          transform: none;
        }
      }
    </style>

    <!-- Page loading scripts -->
    <script>
      (function () {
        window.onload = function () {
          const preloader = document.querySelector('.page-loading')
          preloader.classList.remove('active')
          setTimeout(function () {
            preloader.remove()
          }, 1500)
        }
      })()
    </script>
  </head>


  <!-- Body -->
  <body>


    <!-- Page loading spinner -->
    <div class="page-loading active">
      <div class="page-loading-inner">
        <div class="page-spinner"></div>
        <span>Cargando...</span>
      </div>
    </div>


    <!-- Page wrapper -->
    <main class="page-wrapper">

      <!-- Navbar. Remove 'fixed-top' class to make the navigation bar scrollable with the page -->
      <header class="navbar navbar-expand-lg fixed-top bg-light">
        <div class="container">

          <!-- Navbar brand (Logo) -->
          <a class="navbar-brand pe-sm-3" href="index.html">
            <span class="text-primary flex-shrink-0 me-2">
              <svg width="35" height="32" viewBox="0 0 36 33" xmlns="http://www.w3.org/2000/svg">
                <path fill="currentColor" d="M35.6,29c-1.1,3.4-5.4,4.4-7.9,1.9c-2.3-2.2-6.1-3.7-9.4-3.7c-3.1,0-7.5,1.8-10,4.1c-2.2,2-5.8,1.5-7.3-1.1c-1-1.8-1.2-4.1,0-6.2l0.6-1.1l0,0c0.6-0.7,4.4-5.2,12.5-5.7c0.5,1.8,2,3.1,3.9,3.1c2.2,0,4.1-1.9,4.1-4.2s-1.8-4.2-4.1-4.2c-2,0-3.6,1.4-4,3.3H7.7c-0.8,0-1.3-0.9-0.9-1.6l5.6-9.8c2.5-4.5,8.8-4.5,11.3,0L35.1,24C36,25.7,36.1,27.5,35.6,29z"></path>
              </svg>
            </span>
            Around
          </a>

          <!-- Theme switcher -->
          <div class="form-check form-switch mode-switch order-lg-2 me-3 me-lg-4 ms-auto" data-bs-toggle="mode">
            <input class="form-check-input" type="checkbox" id="theme-mode">
            <label class="form-check-label" for="theme-mode">
              <i class="ai-sun fs-lg"></i>
            </label>
            <label class="form-check-label" for="theme-mode">
              <i class="ai-moon fs-lg"></i>
            </label>
          </div>
        
          <div class="dropdown order-lg-3 d-none d-sm-inline-flex">
        <!-- Mi cuenta: solo si está autenticado -->
@if(auth()->check())
  
    <a class="btn btn-primary btn-sm fs-sm dropdown-toggle" href="#" role="button" id="accountDropdown" data-bs-toggle="dropdown" aria-expanded="false">
      <i class="ai-user fs-xl me-2 ms-n1"></i>
      Mi cuenta
    </a>

          <ul class="dropdown-menu dropdown-menu-end" aria-labelledby="accountDropdown">
                      <li>
                        {{-- Mostrar este botón solo a usuarios admin --}}
                        @if(auth()->user()->hasRole('admin'))
                          <a class="dropdown-item" href="{{ url('admin') }}" role="button">
                            <i class="ai-chart fs-xl me-2 ms-n1"></i>
                            Panel Administrativo
                          </a>
                        @endif
                      </li>

                      <!-- Encabezado -->
                      <li>
                        <h6 class="dropdown-header text-muted">{{ __('Manage Account') }}</h6>
                      </li>

                      <!-- API Tokens (solo si Jetstream los tiene activados) -->
                      @if (Laravel\Jetstream\Jetstream::hasApiFeatures())
                        <li>
                          <a class="dropdown-item" href="{{ route('api-tokens.index') }}">
                            {{ __('API Tokens') }}
                          </a>
                        </li>
                      @endif

                      <li><hr class="dropdown-divider"></li>

                      <!-- Logout -->
                      <li>
                        <form method="POST" action="{{ route('logout') }}" id="logout-form">
                          @csrf
                          <a class="dropdown-item" href="{{ route('logout') }}" 
                            onclick="event.preventDefault(); document.getElementById('logout-form').submit();">
                            {{ __('Log Out') }}
                          </a>
                        </form>
                      </li>
                    </ul>
                  
                @else
                  <!-- Mostrar botones si NO está autenticado -->
                  @if (Route::has('login'))
                    <div class="order-lg-3 d-none d-sm-inline-flex ms-3 align-items-center gap-2">

                      <!-- Botón Login -->
                      <a
                        href="{{ route('login') }}"
                        class="btn btn-outline-primary btn-sm d-inline-flex align-items-center gap-1"
                      >
                        <i class="ai-lock"></i> Iniciar sesión
                      </a>

                      @if (Route::has('register'))
                        <!-- Botón Register -->
                        <a
                          href="{{ route('register') }}"
                          class="btn btn-primary btn-sm d-inline-flex align-items-center gap-1"
                        >
                          <i class="ai-user-plus"></i> Registrarse
                        </a>
                      @endif
                    </div>
                  @endif
                @endif

              
            </ul>
          </div>

          <!-- Mobile menu toggler (Hamburger) -->
          <button class="navbar-toggler ms-sm-3" type="button" data-bs-toggle="collapse" data-bs-target="#navbarNav" aria-label="Toggle navigation">
            <span class="navbar-toggler-icon"></span>
          </button>

          <!-- Navbar collapse (Main navigation) -->
          <nav class="collapse navbar-collapse" id="navbarNav">
            <ul class="navbar-nav navbar-nav-scroll me-auto" style="--ar-scroll-height: 520px;">
              <li class="nav-item dropdown">
                <a class="nav-link dropdown-toggle" href="#" data-bs-toggle="dropdown" aria-expanded="false">Landings</a>
                <div class="dropdown-menu overflow-hidden p-0">
                  <div class="d-lg-flex">
                    <div class="mega-dropdown-column pt-1 pt-lg-3 pb-lg-4">
                      <ul class="list-unstyled mb-0">
                        <li>
                          <a class="dropdown-item" href="index.html">Template Intro Page</a>
                          <span class="mega-dropdown-column position-absolute top-0 end-0 h-100 bg-size-cover bg-repeat-0 rounded-3 rounded-start-0" style="background-image: url(assets/img/megamenu/landings.jpg);"></span>
                        </li>
                        <li>
                          <a class="dropdown-item" href="landing-mobile-app-showcase.html">Mobile App Showcase</a>
                          <span class="mega-dropdown-column position-absolute top-0 end-0 h-100 bg-size-cover bg-repeat-0 z-2 opacity-0" style="background-image: url(assets/img/megamenu/mobile-app.jpg);"></span>
                        </li>
                        <li>
                          <a class="dropdown-item" href="landing-product.html">Product Landing</a>
                          <span class="mega-dropdown-column position-absolute top-0 end-0 h-100 bg-size-cover bg-repeat-0 z-2 opacity-0" style="background-image: url(assets/img/megamenu/product-landing.jpg);"></span>
                        </li>
                        <li>
                          <a class="dropdown-item" href="landing-saas-v1.html">SaaS v.1</a>
                          <span class="mega-dropdown-column position-absolute top-0 end-0 h-100 bg-size-cover bg-repeat-0 z-2 opacity-0" style="background-image: url(assets/img/megamenu/saas-1.jpg);"></span>
                        </li>
                        <li>
                          <a class="dropdown-item" href="landing-saas-v2.html">SaaS v.2</a>
                          <span class="mega-dropdown-column position-absolute top-0 end-0 h-100 bg-size-cover bg-repeat-0 z-2 opacity-0" style="background-image: url(assets/img/megamenu/saas-2.jpg);"></span>
                        </li>
                        <li>
                          <a class="dropdown-item" href="landing-saas-v3.html">SaaS v.3</a>
                          <span class="mega-dropdown-column position-absolute top-0 end-0 h-100 bg-size-cover bg-repeat-0 z-2 opacity-0" style="background-image: url(assets/img/megamenu/saas-3.jpg);"></span>
                        </li>
                        <li>
                          <a class="dropdown-item" href="landing-saas-v4.html">
                            SaaS v.4
                            <span class="text-danger fs-xs ms-2">New</span>
                          </a>
                          <span class="mega-dropdown-column position-absolute top-0 end-0 h-100 bg-size-cover bg-repeat-0 z-2 opacity-0" style="background-image: url(assets/img/megamenu/saas-4.jpg);"></span>
                        </li>
                        <li>
                          <a class="dropdown-item" href="landing-shop-v1.html">Shop Homepage v.1</a>
                          <span class="mega-dropdown-column position-absolute top-0 end-0 h-100 bg-size-cover bg-repeat-0 z-2 opacity-0" style="background-image: url(assets/img/megamenu/shop-homepage-1.jpg);"></span>
                        </li>
                        <li>
                          <a class="dropdown-item" href="landing-shop-v2.html">
                            Shop Homepage v.2
                            <span class="text-danger fs-xs ms-2">New</span>
                          </a>
                          <span class="mega-dropdown-column position-absolute top-0 end-0 h-100 bg-size-cover bg-repeat-0 z-2 opacity-0" style="background-image: url(assets/img/megamenu/shop-homepage-2.jpg);"></span>
                        </li>
                        <li>
                          <a class="dropdown-item" href="landing-marketing-agency.html">Marketing Agency</a>
                          <span class="mega-dropdown-column position-absolute top-0 end-0 h-100 bg-size-cover bg-repeat-0 z-2 opacity-0" style="background-image: url(assets/img/megamenu/marketing-agency.jpg);"></span>
                        </li>
                      </ul>
                    </div>
                    <div class="mega-dropdown-column pb-2 pt-lg-3 pb-lg-4">
                      <ul class="list-unstyled mb-0">
                        <li>
                          <a class="dropdown-item" href="landing-creative-agency.html">Creative Agency</a>
                          <span class="mega-dropdown-column position-absolute top-0 end-0 h-100 bg-size-cover bg-repeat-0 z-2 opacity-0" style="background-image: url(assets/img/megamenu/creative-agency.jpg);"></span>
                        </li>
                        <li>
                          <a class="dropdown-item" href="landing-conference.html">Conference (Event)</a>
                          <span class="mega-dropdown-column position-absolute top-0 end-0 h-100 bg-size-cover bg-repeat-0 z-2 opacity-0" style="background-image: url(assets/img/megamenu/conference.jpg);"></span>
                        </li>
                        <li>
                          <a class="dropdown-item" href="landing-web-studio.html">Web Studio</a>
                          <span class="mega-dropdown-column position-absolute top-0 end-0 h-100 bg-size-cover bg-repeat-0 z-2 opacity-0" style="background-image: url(assets/img/megamenu/web-studio.jpg);"></span>
                        </li>
                        <li>
                          <a class="dropdown-item" href="landing-corporate.html">Corporate</a>
                          <span class="mega-dropdown-column position-absolute top-0 end-0 h-100 bg-size-cover bg-repeat-0 z-2 opacity-0" style="background-image: url(assets/img/megamenu/corporate.jpg);"></span>
                        </li>
                        <li>
                          <a class="dropdown-item" href="landing-insurance.html">
                            Insurance Company
                            <span class="text-danger fs-xs ms-2">New</span>
                          </a>
                          <span class="mega-dropdown-column position-absolute top-0 end-0 h-100 bg-size-cover bg-repeat-0 z-2 opacity-0" style="background-image: url(assets/img/megamenu/insurance.jpg);"></span>
                        </li>
                        <li>
                          <a class="dropdown-item" href="landing-business-consulting.html">Business Consulting</a>
                          <span class="mega-dropdown-column position-absolute top-0 end-0 h-100 bg-size-cover bg-repeat-0 z-2 opacity-0" style="background-image: url(assets/img/megamenu/business-consulting.jpg);"></span>
                        </li>
                        <li>
                          <a class="dropdown-item" href="landing-coworking-space.html">Coworking Space</a>
                          <span class="mega-dropdown-column position-absolute top-0 end-0 h-100 bg-size-cover bg-repeat-0 z-2 opacity-0" style="background-image: url(assets/img/megamenu/coworking.jpg);"></span>
                        </li>
                        <li>
                          <a class="dropdown-item" href="landing-yoga-studio.html">Yoga Studio</a>
                          <span class="mega-dropdown-column position-absolute top-0 end-0 h-100 bg-size-cover bg-repeat-0 z-2 opacity-0" style="background-image: url(assets/img/megamenu/yoga-studio.jpg);"></span>
                        </li>
                        <li>
                          <a class="dropdown-item" href="landing-influencer.html">Influencer</a>
                          <span class="mega-dropdown-column position-absolute top-0 end-0 h-100 bg-size-cover bg-repeat-0 z-2 opacity-0" style="background-image: url(assets/img/megamenu/influencer.jpg);"></span>
                        </li>
                        <li>
                          <a class="dropdown-item" href="landing-blog.html">Blog Homepage</a>
                          <span class="mega-dropdown-column position-absolute top-0 end-0 h-100 bg-size-cover bg-repeat-0 z-2 opacity-0" style="background-image: url(assets/img/megamenu/blog-homepage.jpg);"></span>
                        </li>
                      </ul>
                    </div>
                    <div class="mega-dropdown-column position-relative border-start z-3"></div>
                  </div>
                </div>
              </li>
              <li class="nav-item dropdown">
                <a class="nav-link dropdown-toggle active" href="#" data-bs-toggle="dropdown" data-bs-auto-close="outside" aria-expanded="false">Pages</a>
                <ul class="dropdown-menu">
                  <li class="dropdown">
                    <a class="dropdown-item dropdown-toggle" href="#" data-bs-toggle="dropdown" aria-expanded="false">Portfolio</a>
                    <ul class="dropdown-menu">
                      <li><a class="dropdown-item" href="portfolio-list-v1.html">List View v.1</a></li>
                      <li><a class="dropdown-item" href="portfolio-list-v2.html">List View v.2</a></li>
                      <li><a class="dropdown-item" href="portfolio-grid-v1.html">Grid View v.1</a></li>
                      <li><a class="dropdown-item" href="portfolio-grid-v2.html">Grid View v.2</a></li>
                      <li><a class="dropdown-item" href="portfolio-slider.html">Slider View</a></li>
                      <li><a class="dropdown-item" href="portfolio-single-v1.html">Single Project v.1</a></li>
                      <li><a class="dropdown-item" href="portfolio-single-v2.html">Single Project v.2</a></li>
                    </ul>
                  </li>
                  <li class="dropdown">
                    <a class="dropdown-item dropdown-toggle" href="#" data-bs-toggle="dropdown" aria-expanded="false">Shop</a>
                    <ul class="dropdown-menu">
                      <li><a class="dropdown-item" href="shop-catalog.html">Catalog (Listing)</a></li>
                      <li><a class="dropdown-item" href="shop-single.html">Product Page</a></li>
                      <li><a class="dropdown-item" href="shop-checkout.html">Checkout</a></li>
                    </ul>
                  </li>
                  <li class="dropdown">
                    <a class="dropdown-item dropdown-toggle" href="#" data-bs-toggle="dropdown" aria-expanded="false">Blog</a>
                    <ul class="dropdown-menu">
                      <li><a class="dropdown-item" href="blog-grid-sidebar.html">Grid View with Sidebar</a></li>
                      <li><a class="dropdown-item" href="blog-grid.html">Grid View no Sidebar</a></li>
                      <li><a class="dropdown-item" href="blog-list-sidebar.html">List View with Sidebar</a></li>
                      <li><a class="dropdown-item" href="blog-list.html">List View no Sidebar</a></li>
                      <li><a class="dropdown-item" href="blog-single-v1.html">Single post v.1</a></li>
                      <li><a class="dropdown-item" href="blog-single-v2.html">Single post v.2</a></li>
                      <li><a class="dropdown-item" href="blog-single-v3.html">Single post v.3</a></li>
                    </ul>
                  </li>
                  <li class="dropdown">
                    <a class="dropdown-item dropdown-toggle" href="#" data-bs-toggle="dropdown" aria-expanded="false">About</a>
                    <ul class="dropdown-menu">
                      <li><a class="dropdown-item" href="about-agency.html">About - Agency</a></li>
                      <li><a class="dropdown-item" href="about-product.html">About - Product</a></li>
                    </ul>
                  </li>
                  <li class="dropdown">
                    <a class="dropdown-item dropdown-toggle" href="#" data-bs-toggle="dropdown" aria-expanded="false">Services</a>
                    <ul class="dropdown-menu">
                      <li><a class="dropdown-item" href="services-v1.html">Services v.1</a></li>
                      <li><a class="dropdown-item" href="services-v2.html">Services v.2</a></li>
                      <li><a class="dropdown-item" href="services-v3.html">Services v.3</a></li>
                    </ul>
                  </li>
                  <li><a class="dropdown-item" href="pricing.html">Pricing</a></li>
                  <li class="dropdown">
                    <a class="dropdown-item dropdown-toggle" href="#" data-bs-toggle="dropdown" aria-expanded="false">Contacts</a>
                    <ul class="dropdown-menu">
                      <li><a class="dropdown-item" href="contacts-v1.html">Contacts v.1</a></li>
                      <li><a class="dropdown-item" href="contacts-v2.html">Contacts v.2</a></li>
                      <li><a class="dropdown-item" href="contacts-v3.html">Contacts v.3</a></li>
                    </ul>
                  </li>
                  <li class="dropdown">
                    <a class="dropdown-item dropdown-toggle" href="#" data-bs-toggle="dropdown" aria-expanded="false">Specialty Pages</a>
                    <ul class="dropdown-menu">
                      <li><a class="dropdown-item" href="coming-soon-v1.html">Coming Soon v.1</a></li>
                      <li><a class="dropdown-item" href="coming-soon-v2.html">Coming Soon v.2</a></li>
                      <li><a class="dropdown-item" href="404-v1.html">404 Error v.1</a></li>
                      <li><a class="dropdown-item" href="404-v2.html">404 Error v.2</a></li>
                      <li><a class="dropdown-item" href="404-v3.html">404 Error v.3</a></li>
                    </ul>
                  </li>
                </ul>
              </li>
              {{-- Apartado --}}
              <li class="nav-item dropdown">
                <a class="nav-link dropdown-toggle" href="#" data-bs-toggle="dropdown" data-bs-auto-close="outside" aria-expanded="false">Account</a>
                <ul class="dropdown-menu">
                  <li class="dropdown">
                    <a class="dropdown-item dropdown-toggle" href="#" data-bs-toggle="dropdown" aria-expanded="false">Auth pages</a>
                    <ul class="dropdown-menu">
                      <li><a class="dropdown-item" href="account-signin.html">Sign In</a></li>
                      <li><a class="dropdown-item" href="account-signup.html">Sign Up</a></li>
                      <li><a class="dropdown-item" href="account-signinup.html">Sign In / Up</a></li>
                      <li><a class="dropdown-item" href="account-password-recovery.html">Password Recovery</a></li>
                    </ul>
                  </li>
                  <li><a class="dropdown-item" href="account-overview.html">Overview</a></li>
                  <li><a class="dropdown-item" href="account-settings.html">Settings</a></li>
                  <li><a class="dropdown-item" href="account-billing.html">Billing</a></li>
                  <li><a class="dropdown-item" href="account-orders.html">Orders</a></li>
                  <li><a class="dropdown-item" href="account-earnings.html">Earnings</a></li>
                  <li><a class="dropdown-item" href="account-chat.html">Chat (Messages)</a></li>
                  <li><a class="dropdown-item" href="account-favorites.html">Favorites (Wishlist)</a></li>
                </ul>
              </li>
              <li class="nav-item dropdown">
                <a class="nav-link dropdown-toggle" href="#" data-bs-toggle="dropdown" data-bs-auto-close="outside" aria-expanded="false">Plataforma</a>
                <ul class="dropdown-menu">
                  
                  <li><a class="dropdown-item" href="{{ route('dashboard') }}">Inicio</a></li>
                  <li><a class="dropdown-item" href="{{ route('posts.index') }}">Post</a></li>
                  
                </ul>
              </li>
            
            </ul>

        {{-- Solo para usuarios autenticados --}}
            
      {{-- Menú móvil --}}
      <div class="d-sm-none p-3 mt-n3">
        @if(auth()->check())
          {{-- Menú desplegable para usuario autenticado --}}
          <div class="dropdown">
            <a class="btn btn-primary w-100 dropdown-toggle" href="#" id="mobileAccountDropdown" data-bs-toggle="dropdown" aria-expanded="false">
              <i class="ai-user fs-xl me-2 ms-n1"></i>
              Mi cuenta
            </a>

            <ul class="dropdown-menu w-100" aria-labelledby="mobileAccountDropdown">
              <!-- Encabezado -->
              <li><h6 class="dropdown-header text-muted">{{ __('Manage Account') }}</h6></li>

              <!-- Panel Administrativo (solo admin) -->
              @if(auth()->user()->hasRole('admin'))
                <li>
                  <a class="dropdown-item" href="{{ url('admin') }}">
                    <i class="ai-chart fs-xl me-2 ms-n1"></i>
                    Panel Administrativo
                  </a>
                </li>
              @endif

              <!-- Perfil -->
              <li>
                <a class="dropdown-item" href="{{ route('profile.show') }}">
                  {{ __('Profile') }}
                </a>
              </li>

              <!-- API Tokens -->
              @if (Laravel\Jetstream\Jetstream::hasApiFeatures())
                <li>
                  <a class="dropdown-item" href="{{ route('api-tokens.index') }}">
                    {{ __('API Tokens') }}
                  </a>
                </li>
              @endif

              <li><hr class="dropdown-divider"></li>

              <!-- Logout -->
              <li>
                <form method="POST" action="{{ route('logout') }}" id="mobile-logout-form">
                  @csrf
                  <a class="dropdown-item" href="{{ route('logout') }}"
                    onclick="event.preventDefault(); document.getElementById('mobile-logout-form').submit();">
                    {{ __('Log Out') }}
                  </a>
                </form>
              </li>
            </ul>
          </div>
        @else
          {{-- Botones para usuarios no autenticados --}}
          @if (Route::has('login'))
            <div class="d-flex flex-column gap-2">
              <a href="{{ route('login') }}" class="btn btn-outline-primary btn-sm w-100 d-flex align-items-center justify-content-center gap-1">
                <i class="ai-lock"></i> Iniciar sesión
              </a>

              @if (Route::has('register'))
                <a href="{{ route('register') }}" class="btn btn-primary btn-sm w-100 d-flex align-items-center justify-content-center gap-1">
                  <i class="ai-user-plus"></i> Registrarse
                </a>
              @endif
            </div>
          @endif
        @endif
      </div>
          </nav>
        </div>
      </header>
    </main>

    <main>
        {{ $slot }}
    </main>
  

</html>
