<x-app-layout>
@php

$membresias = \App\Models\TipoDeMembresia::all()
    ->filter(fn($m) => $m->nombre !== 'Founder')
    ->sortBy(fn($m) => match($m->nombre) {
        'Essentials' => 1,
        'Premium'    => 2,
        'Basics'     => 3,
        default      => 99
    });


@endphp

<style>
    /* === MODO OSCURO === */
[data-bs-theme="dark"] .cards-container {
    background: #121212;
}

[data-bs-theme="dark"] .card {
    background: #1E1E1E;
    border-color: transparent;
    box-shadow: 0 4px 12px rgba(0,0,0,0.6);
    color: #E0E0E0;
}

[data-bs-theme="dark"] .card-header,
[data-bs-theme="dark"] .card-header svg {
    color: inherit; /* mantiene color según tipo */
}

[data-bs-theme="dark"] .essentials { border-color: #ff6b81; }
[data-bs-theme="dark"] .premium { border-color: #ffa94d; }
[data-bs-theme="dark"] .basics { border-color: #4dd0e1; }

[data-bs-theme="dark"] .features .feature {
    color: #ccc;
}

[data-bs-theme="dark"] .features .feature svg {
    color: #4dd0e1; /* iconos más visibles */
}

[data-bs-theme="dark"] .register-btn {
    color: #fff;
    box-shadow: none;
}

[data-bs-theme="dark"] .essentials .register-btn { background: #ff6b81; }
[data-bs-theme="dark"] .premium .register-btn { background: #ffa94d; }
[data-bs-theme="dark"] .basics .register-btn { background: #4dd0e1; }

/* Viewer card dark mode */
[data-bs-theme="dark"] .viewer-card {
    background: #1A1A1A;
    color: #E0E0E0;
    box-shadow: 0 4px 12px rgba(0,0,0,0.6);
}

[data-bs-theme="dark"] .viewer-card svg {
    color: #4dd0e1;
}

[data-bs-theme="dark"] .viewer-card .register-btn {
    background: #4dd0e1;
    color: #121212;
}

.cards-container {
    display: flex;
    flex-wrap: wrap;
    gap: 1.5rem;
    justify-content: center;
    margin: 2rem auto;
    padding-top: 3rem;
}

.card {
    background: #fff;
    border-radius: 12px;
    padding: 2rem;
    width: 320px;
    box-shadow: 0 4px 12px rgba(0,0,0,0.08);
    display: flex;
    flex-direction: column;
    gap: 1.2rem;
    border: 2px solid transparent;
    transition: transform 0.2s, box-shadow 0.2s;
}

.card:hover {
    transform: translateY(-6px);
    box-shadow: 0 8px 20px rgba(0,0,0,0.15);
}

/* Colores por tipo */
.essentials { border-color: #8B1C2A; }
.premium { border-color: #D97D1E; }
.basics { border-color: #2F6B63; }

/* Título e icono con color de la card */
.essentials .card-header,
.essentials .card-header svg { color: #8B1C2A; }
.premium .card-header,
.premium .card-header svg { color: #D97D1E; }
.basics .card-header,
.basics .card-header svg { color: #2F6B63; }

/* Card header */
.card-header {
    display: flex;
    align-items: center;
    gap: 0.5rem;
    font-weight: bold;
    font-size: 1.3rem;
}
.card-header svg {
    width: 36px;
    height: 36px;
}

/* Features */
.features {
    display: flex;
    flex-direction: column;
    gap: 0.6rem;
}
.feature {
    display: flex;
    align-items: center;
    gap: 0.5rem;
    font-size: 1rem;
}
.feature svg {
    width: 18px;
    height: 18px;
}

/* Botón más grande */
.register-btn {
    margin-top: auto;
    padding: 1rem;
    border-radius: 10px;
    font-weight: bold;
    font-size: 1.05rem;
    border: none;
    cursor: pointer;
    color: white;
    text-align: center;
}

/* Botones por tipo */
.essentials .register-btn { background: #8B1C2A; }
.premium .register-btn { background: #D97D1E; }
.basics .register-btn { background: #2F6B63; }

/* Viewer card */
.viewer-card {
    background: #E0EFF0;
    border-radius: 12px;
    padding: 1.5rem 2rem;
    display: flex;
    align-items: center;
    justify-content: space-between;
    max-width: 900px;
    margin: 2rem auto;
}
.viewer-card .info { max-width: 80%; }
.viewer-card svg { width: 36px; height: 36px; margin-right: 0.5rem; }
.viewer-card .register-btn {
    background: #7FA5A9;
    color: white;
    padding: 0.75rem 1.5rem;
    border-radius: 10px;
    font-size: 1rem;
}
@media (max-width: 768px) {
    .viewer-card {
        flex-direction: column;
        text-align: center;
    }
    .viewer-card .info {
        max-width: 100%;
    }
    .viewer-card .register-btn {
        width: 100%; /* botón ocupa todo el ancho */
    }
}
</style>


<div class="cards-container">
  
@foreach($membresias as $m)
    @php
        $icon = match($m->nombre) {
            'Essentials' => '<svg xmlns="http://www.w3.org/2000/svg" width="80" height="80" fill="currentColor" class="bi bi-stars" viewBox="0 0 16 16">
                                <path d="M7.657 6.247c.11-.33.576-.33.686 0l.645 1.937a2.89 2.89 0 0 0 1.829 1.828l1.936.645c.33.11.33.576 0 .686l-1.937.645a2.89 2.89 0 0 0-1.828 1.829l-.645 1.936a.361.361 0 0 1-.686 0l-.645-1.937a2.89 2.89 0 0 0-1.828-1.828l-1.937-.645a.361.361 0 0 1 0-.686l1.937-.645a2.89 2.89 0 0 0 1.828-1.828zM3.794 1.148a.217.217 0 0 1 .412 0l.387 1.162c.173.518.579.924 1.097 1.097l1.162.387a.217.217 0 0 1 0 .412l-1.162.387A1.73 1.73 0 0 0 4.593 5.69l-.387 1.162a.217.217 0 0 1-.412 0L3.407 5.69A1.73 1.73 0 0 0 2.31 4.593l-1.162-.387a.217.217 0 0 1 0-.412l1.162-.387A1.73 1.73 0 0 0 3.407 2.31zM10.863.099a.145.145 0 0 1 .274 0l.258.774c.115.346.386.617.732.732l.774.258a.145.145 0 0 1 0 .274l-.774.258a1.16 1.16 0 0 0-.732.732l-.258.774a.145.145 0 0 1-.274 0l-.258-.774a1.16 1.16 0 0 0-.732-.732L9.1 2.137a.145.145 0 0 1 0-.274l.774-.258c.346-.115.617-.386.732-.732z"/>
                              </svg>',
            'Premium' => '<svg xmlns="http://www.w3.org/2000/svg" width="80" height="80" fill="currentColor" class="bi bi-gem" viewBox="0 0 16 16">
                                      <path d="M3.1.7a.5.5 0 0 1 .4-.2h9a.5.5 0 0 1 .4.2l2.976 3.974c.149.185.156.45.01.644L8.4 15.3a.5.5 0 0 1-.8 0L.1 5.3a.5.5 0 0 1 0-.6zm11.386 3.785-1.806-2.41-.776 2.413zm-3.633.004.961-2.989H4.186l.963 2.995zM5.47 5.495 8 13.366l2.532-7.876zm-1.371-.999-.78-2.422-1.818 2.425zM1.499 5.5l5.113 6.817-2.192-6.82zm7.889 6.817 5.123-6.83-2.928.002z"/>
                                    </svg>',
            'Basics' => '<svg xmlns="http://www.w3.org/2000/svg" width="80" height="80" fill="currentColor" class="bi bi-check2-circle" viewBox="0 0 16 16">
                                    <path d="M2.5 8a5.5 5.5 0 0 1 8.25-4.764.5.5 0 0 0 .5-.866A6.5 6.5 0 1 0 14.5 8a.5.5 0 0 0-1 0 5.5 5.5 0 1 1-11 0"/>
                                    <path d="M15.354 3.354a.5.5 0 0 0-.708-.708L8 9.293 5.354 6.646a.5.5 0 1 0-.708.708l3 3a.5.5 0 0 0 .708 0z"/>
                                  </svg>',
            default => ''
        };
        $class = strtolower($m->nombre);
        $caracteristicas = json_decode($m->caracteristicas, true) ?? ['puede_ver'=>[], 'puede_hacer'=>[]];
    @endphp
    

    <div class="card {{ $class }}">
        <div class="card-header">
            {!! $icon !!}
            {{ $m->nombre }}
        </div>
        <div class="features">
            @foreach($caracteristicas['puede_hacer'] ?? [] as $hacer)
                <div class="feature">
                    <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor" class="bi bi-check2" viewBox="0 0 16 16">
                        <path d="M13.854 3.646a.5.5 0 0 1 0 .708l-7 7a.5.5 0 0 1-.708 0l-3.5-3.5a.5.5 0 1 1 .708-.708L6.5 10.293l6.646-6.647a.5.5 0 0 1 .708 0"/>
                    </svg>
                    {{ $hacer['valor'] ?? $hacer }}
                </div>
            @endforeach
            @foreach($caracteristicas['puede_ver'] ?? [] as $ver)
                <div class="feature">
                    <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor" class="bi bi-eye" viewBox="0 0 16 16">
                        <path d="M16 8s-3-5.5-8-5.5S0 8 0 8s3 5.5 8 5.5S16 8 16 8M1.173 8a13 13 0 0 1 1.66-2.043C4.12 4.668 5.88 3.5 8 3.5s3.879 1.168 5.168 2.457A13 13 0 0 1 14.828 8q-.086.13-.195.288c-.335.48-.83 1.12-1.465 1.755C11.879 11.332 10.119 12.5 8 12.5s-3.879-1.168-5.168-2.457A13 13 0 0 1 1.172 8z"/>
                        <path d="M8 5.5a2.5 2.5 0 1 0 0 5 2.5 2.5 0 0 0 0-5M4.5 8a3.5 3.5 0 1 1 7 0 3.5 3.5 0 0 1-7 0"/>
                      </svg>
                    {{ $ver['valor'] ?? $ver }}
                </div>
            @endforeach
        </div>
        <a class="register-btn" href="{{ route('register') }}">REGÍSTRATE AHORA</a>
    </div>
@endforeach
</div>

{{-- Card especial Viewer --}}
<div class="viewer-card">
    <div class="info">
        <div>
            <strong>Viewer</strong><br>
            Al registrarte en nuestra plataforma, obtienes automáticamente la <strong>Membresía Viewer</strong>, que te brinda acceso gratuito a secciones seleccionadas.
        </div>
    </div>
    <a href="{{ route('register') }}" class="register-btn">REGÍSTRATE AHORA</a>
</div>

</x-app-layout>
