<!-- Modal Editar Publicación -->
<div id="editarModal" class="modal-np">
  <div class="modal-contenido">
    <span class="cerrar">&times;</span>
    <h2>Editar publicación</h2>

    <form id="formEditarPublicacion" action="" method="POST" enctype="multipart/form-data">
      @csrf
      @method('PUT')

      <!-- Título -->
      <div class="mb-3">
        <label for="edit-title" class="form-label">Título</label>
        <input type="text" name="title" id="edit-title" class="form-control" value="">
      </div>

      <!-- Contenido -->
      <div class="mb-3">
        <label for="edit-content" class="form-label">Contenido</label>
        <textarea name="content" id="edit-content" rows="4" class="form-control"></textarea>
      </div>

      <!-- Temas -->
      <div class="mb-3">
        <label for="edit-temas" class="form-label">Temas</label>
        <select id="edit-temas" name="temas[]" class="form-control" multiple>
            @foreach(\App\Models\Tema::all() as $tema)
                <option value="{{ $tema->id }}">{{ $tema->nombre }}</option>
            @endforeach
        </select>
      </div>

      <!-- Imágenes -->
      <div class="mb-3">
        <label for="edit-images" class="form-label">Imágenes</label>
        <input type="file" name="images_path[]" id="edit-images" class="form-control" multiple accept="image/*">
        <small class="form-text text-muted">Máximo 5 imágenes.</small>

        <!-- Contenedor de previsualización -->
        <div id="edit-preview-images" class="mt-2 d-flex flex-wrap gap-2"></div>
      </div>

      <!-- Hidden input para imágenes eliminadas -->
      <input type="hidden" name="remove_images" id="remove-images" value="">

      <button type="submit" class="btn btn-primary">Actualizar publicación</button>
    </form>
  </div>
</div>


<script>
let tomSelectEditar;

function abrirEditarModal(post) {
    const modal = document.getElementById('editarModal');
    modal.style.display = 'flex';

    const form = document.getElementById('formEditarPublicacion');
    form.action = `/publicaciones/${post.id}`;

    document.getElementById('edit-title').value = post.title;
    document.getElementById('edit-content').value = post.content;

    // Tom Select
    if (!tomSelectEditar) {
        tomSelectEditar = new TomSelect('#edit-temas', {
            plugins: ['remove_button'],
            placeholder: 'Selecciona uno o varios temas',
            maxItems: null
        });
    }
    tomSelectEditar.clear();
    post.temas.forEach(tema => tomSelectEditar.addItem(tema.id));

    // Previsualización de imágenes
    const preview = document.getElementById('edit-preview-images');
    preview.innerHTML = '';
    const removeImagesInput = document.getElementById('remove-images');
    removeImagesInput.value = '';

    if (post.images_path && post.images_path.length) {
        post.images_path.forEach((imgPath, index) => {
            const wrapper = document.createElement('div');
            wrapper.style.position = 'relative';

            const img = document.createElement('img');
            img.src = `/storage/${imgPath}`;
            img.style.width = '80px';
            img.style.height = '80px';
            img.style.objectFit = 'cover';
            img.style.borderRadius = '4px';
            wrapper.appendChild(img);

            // Botón eliminar imagen
            const btn = document.createElement('button');
            btn.type = 'button';
            btn.innerHTML = '&times;';
            btn.style.position = 'absolute';
            btn.style.top = '0';
            btn.style.right = '0';
            btn.style.background = 'rgba(0,0,0,0.5)';
            btn.style.color = '#fff';
            btn.style.border = 'none';
            btn.style.borderRadius = '50%';
            btn.style.width = '20px';
            btn.style.height = '20px';
            btn.style.cursor = 'pointer';
            btn.addEventListener('click', () => {
                wrapper.remove();
                // Guardar la ruta en el hidden para eliminar en backend
                let removed = removeImagesInput.value ? JSON.parse(removeImagesInput.value) : [];
                removed.push(imgPath);
                removeImagesInput.value = JSON.stringify(removed);
            });
            wrapper.appendChild(btn);

            preview.appendChild(wrapper);
        });
    }
}

// Previsualización de nuevas imágenes
document.getElementById('edit-images').addEventListener('change', function(e) {
    const preview = document.getElementById('edit-preview-images');
    const removeImagesInput = document.getElementById('remove-images');

    // Limpiar previas imágenes temporales (solo nuevas, no las existentes)
    // Opcional: si quieres conservar las previas seleccionadas, comenta esta línea
    // preview.innerHTML = '';

    Array.from(e.target.files).forEach(file => {
        const reader = new FileReader();
        reader.onload = function(event) {
            const wrapper = document.createElement('div');
            wrapper.style.position = 'relative';

            const img = document.createElement('img');
            img.src = event.target.result;
            img.style.width = '80px';
            img.style.height = '80px';
            img.style.objectFit = 'cover';
            img.style.borderRadius = '4px';
            wrapper.appendChild(img);

            // Botón eliminar imagen nueva
            const btn = document.createElement('button');
            btn.type = 'button';
            btn.innerHTML = '&times;';
            btn.style.position = 'absolute';
            btn.style.top = '0';
            btn.style.right = '0';
            btn.style.background = 'rgba(0,0,0,0.5)';
            btn.style.color = '#fff';
            btn.style.border = 'none';
            btn.style.borderRadius = '50%';
            btn.style.width = '20px';
            btn.style.height = '20px';
            btn.style.cursor = 'pointer';
            btn.addEventListener('click', () => {
                wrapper.remove();
                // También quitar archivo del input
                const dt = new DataTransfer();
                Array.from(e.target.files)
                    .filter(f => f !== file)
                    .forEach(f => dt.items.add(f));
                e.target.files = dt.files;
            });
            wrapper.appendChild(btn);

            preview.appendChild(wrapper);
        }
        reader.readAsDataURL(file);
    });
});

// Cerrar modal
document.querySelectorAll('#editarModal .cerrar').forEach(btn => {
    btn.addEventListener('click', () => {
        btn.closest('.modal-np').style.display = 'none';
    });
});

</script>