<x-app-layout>
{{-- Apartado de mis publicaciones --}}
<!-- Page container -->
      <div class="container pt-5 pb-lg-5 pb-md-4 pb-2 my-5">
        <!-- Breadcrumb -->
        <nav aria-label="breadcrumb">
          <ol class="pt-lg-3 pb-lg-4 pb-2 breadcrumb">
            <li class="breadcrumb-item"><a href=" {{ route('dashboard') }} ">Home</a></li>
            <li class="breadcrumb-item active" aria-current="page">Mis publicaciones</li>
          </ol>
        </nav>
        <div class="row mb-md-2 mb-xl-4">

          <!-- Blog posts -->
          <div class="col-lg-9 pe-lg-4 pe-xl-5">
    {{-- Estilos para las card de Eventos --}}
    <style>
            .post-card {
                border: 1px solid #dee2e6;
                border-radius: 1rem;
                background: #fff;
                box-shadow: 0 2px 6px rgba(0,0,0,0.04);
                margin-bottom: 2rem;
            }
            /* Card en modo oscuro */
            [data-bs-theme="dark"] .post-card {
            background: #1e1e1e;
            border: 1px solid #444c54;
            box-shadow: 0 2px 6px rgba(0, 0, 0, 0.5);
            color: #f8f9fa; /* texto claro */
            }
            .post-image {
                width: 100%;
                height: 220px;
                object-fit: cover;
                border-radius: 0.5rem;
            }
            .comment-card {
                background: #f8f9fa;
                border: 1px solid #dee2e6;
                border-radius: 0.5rem;
                padding: 0.75rem 1rem;
                margin-bottom: 0.75rem;
                box-shadow: 0 1px 2px rgba(0,0,0,0.03);
            }
            /* Modo oscuro */
            [data-bs-theme="dark"] .comment-card {
                background: #1e1e1e;
                border: 1px solid #444c54;
                box-shadow: 0 2px 6px rgba(0, 0, 0, 0.5);
                color: #e9ecef;
            }
            .form-comment input {
                border-radius: 2rem;
            }
            .fb-gallery {
                width: 100%;
                margin-bottom: 1rem;
                display: flex;
                flex-direction: column;
                gap: 4px;
            }

            .fb-row {
                display: flex;
                gap: 4px;
            }

            .fb-col {
                display: flex;
                flex-direction: column;
                gap: 4px;
                flex: 1;
            }

            .fb-grid {
                display: grid;
                grid-template-columns: repeat(2, 1fr);
                gap: 4px;
            }

            .fb-img {
                position: relative;
                overflow: hidden;
                border-radius: 10px;
            }

            .fb-img img {
                width: 100%;
                height: 100%;
                object-fit: cover;
                display: block;
                aspect-ratio: 1/1;
            }

            .fb-img-1 img {
                aspect-ratio: 4/3;
                border-radius: 10px;
            }

            .fb-img-half {
                flex: 1;
            }

            .fb-img-small {
                flex: 1;
                height: 100%;
            }

            .fb-overlay {
                position: absolute;
                inset: 0;
                background: rgba(0, 0, 0, 0.6);
                color: white;
                font-weight: bold;
                font-size: 2rem;
                display: flex;
                justify-content: center;
                align-items: center;
                border-radius: 10px;
            }

            /* Responsive: 100% ancho en móviles */
            @media (max-width: 600px) {
                .fb-row,
                .fb-grid {
                    flex-direction: column;
                    display: flex;
                }

                .fb-col {
                    flex-direction: row;
                }

                .fb-img img {
                    aspect-ratio: 1/1;
                }
            }
                /* Responsive:  */
                @media (max-width: 600px) {
                    .in-movile-column{
                        flex-direction: column;
                    }
                    .category-container{}
                    .category-badge{
                    
                    }
                }
                /* Responsive:  */
                @media (max-width: 1100px) {
                    .in-movile-column{
                        flex-direction: column;
                    }
                    .category-container{}
                    .category-badge{
                    
                    }
                }
                .category-container {
                    display: flex;
                    flex-wrap: wrap;       /* Permite que bajen de línea */
                    gap: 0.25rem;
                    max-width: 100%;       /* Impide que se expanda más allá del contenedor */
                    overflow: hidden;
                }

                .category-badge {
                    display: inline-block;
                    max-width: 200px;         /* Límite de ancho por etiqueta */
                    white-space: nowrap;      /* No hacer saltos de línea */
                    overflow: hidden;         /* Ocultar contenido que se desborda */
                    text-overflow: ellipsis;  /* Mostrar ... al desbordar */
                }

            #paginator{
                width: 100%
            }





    </style>
<!-- Botón para abrir modal -->
<div class="d-flex align-items-end justify-content-between mb-4">
    <h2>Mis publicaciones</h2>
    <button class="btn btn-primary btn-sm" id="btnNuevaPublicacion">
        <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor" class="bi bi-pencil-square me-2" viewBox="0 0 16 16">
            <path d="M15.502 1.94a.5.5 0 0 1 0 .706L14.459 3.69l-2-2L13.502.646a.5.5 0 0 1 .707 0l1.293 1.293zm-1.75 2.456-2-2L4.939 9.21a.5.5 0 0 0-.121.196l-.805 2.414a.25.25 0 0 0 .316.316l2.414-.805a.5.5 0 0 0 .196-.12l6.813-6.814z"/>
            <path fill-rule="evenodd" d="M1 13.5A1.5 1.5 0 0 0 2.5 15h11a1.5 1.5 0 0 0 1.5-1.5v-6a.5.5 0 0 0-1 0v6a.5.5 0 0 1-.5.5h-11a.5.5 0 0 1-.5-.5v-11a.5.5 0 0 1 .5-.5H9a.5.5 0 0 0 0-1H2.5A1.5 1.5 0 0 0 1 2.5z"/>
        </svg>
        Nueva publicación
    </button>
</div>


    {{-- Nueva publicacion boton + modal --}}
    {{-- publicaciones del usuario --}}
    @foreach ($posts as $post)
    <div class="post-card p-4 ">
        {{-- Encabezado --}}
       <div class="d-flex align-items-start justify-content-between mb-3 in-movile-column">
        <div class="flex-grow-1">
            <h5 class="mb-1">{{ $post->title }}</h5>
            <small class="text-muted">Publicado por <strong>{{ $post->user->name }}</strong> • {{ $post->published_at->diffForHumans() }}</small>
        </div>
        <div class="ms-3 text-end category-container">
            @forelse ($post->temas as $cat)
                <span class="badge bg-tecolli category-badge">{{ $cat->nombre }}</span>
            @empty
                <span class="badge bg-tecolli ">Sin categoría</span>
            @endforelse
        </div>

        {{-- Menú de tres puntitos --}}
<div class="menu-dots-wrapper position-relative">
    <div class="three-dots pointer" onclick="toggleDropdown(this)">&#8942;</div>
    <div class="dropdown-click position-absolute end-0 mt-1">
        
        {{-- Botón Editar --}}
        <button type="button" class="btn btn-editar w-100 text-start" 
                onclick="abrirEditarModal({
                    id: {{ $post->id }},
                    title: '{{ addslashes($post->title) }}',
                    content: '{{ addslashes($post->content) }}',
                    temas: [
                        @foreach($post->temas as $tema)
                            { id: {{ $tema->id }}, name: '{{ addslashes($tema->name) }}' },
                        @endforeach
                    ]
                })"
                style="color: green;">
            Editar
        </button>

        {{-- Formulario Eliminar --}}
        <form action="{{ route('user.eliminar_publicacion', $post->id) }}" method="POST" 
              onsubmit="return confirm('¿Estás seguro de eliminar esta publicación?');">
            @csrf
            @method('DELETE')
            <button type="submit" class="btn btn-eliminar w-100 text-start">Eliminar</button>
        </form>
    </div>
</div>

    </div>
        {{-- Contenido --}}
        
        <p>{!! str($post->content)->sanitizeHtml() !!}</p>

        {{-- Grid de imágenes estilo Facebook --}}
        @php
        $images = $post->images_path ?? [];
        $total = is_array($images) ? count($images) : 0;
        //echo $total;

        @endphp
    {{-- Div para Grid de fotos --}}
    <div class="fb-gallery">

        @if ($total === 1)
            <div class="fb-img fb-img-1">
                <img src="{{ Storage::url($images[0]) }}" alt="" class="clickable-img pointer">
            </div>

        @elseif ($total === 2)
            <div class="fb-row">
                @foreach ($images as $img)
                    <div class="fb-img fb-img-half">
                        <img src="{{ Storage::url($img) }}" alt="" class="clickable-img pointer">

                    </div>
                @endforeach
            </div>

        @elseif ($total === 3)
            <div class="fb-row">
                <div class="fb-img fb-img-half">
                    
                    <img src="{{ Storage::url($images[0]) }}" alt="" class="clickable-img pointer">

                </div>
                <div class="fb-col">
                    <div class="fb-img fb-img-small"><img src="{{ Storage::url($images[1]) }}" alt="" class="clickable-img pointer"></div>
                    <div class="fb-img fb-img-small"><img src="{{ Storage::url($images[2]) }}" alt="" class="clickable-img pointer"></div>
                </div>
            </div>

        @elseif ($total === 4)
            <div class="fb-grid">
                @foreach ($images as $img)
                    <div class="fb-img">
                        <img src="{{ Storage::url($img) }}" alt="" class="clickable-img pointer">

                    </div>
                @endforeach
            </div>

        @else
            <div class="fb-grid">
                @foreach (array_slice($images, 0, 4) as $i => $img)
                    <div class="fb-img">
                        <img src="{{ Storage::url($img) }}" alt="" class="clickable-img pointer">
                        @if ($i === 3)
                            <div class="fb-overlay pointer"  onclick="showAllImages({{ json_encode($images) }})">
                                +{{ $total - 4 }}
                            </div>
                        @endif
                    </div>
                @endforeach
            </div>
        @endif

    </div>
    {{-- Apartado de acciones --}}
    {{-- Apartado de acciones --}}
    <div class="mb-2">
        <span id="contador-comentarios-{{ $post->id }}" class="nav-link text-body-secondary fs-sm fw-normal d-flex align-items-end p-0 mt-2">
            {{ $post->comentarios_count }}
            <i class="ai-message fs-lg ms-1"></i>
        </span>
    </div>


    {{-- Apartado de Comentarios --}}
    <div id="comentarios-wrapper-{{ $post->id }}">
    @foreach ($post->comentarios->take(5) as $comentario)
        @include('components.comentario-card', ['comentario' => $comentario])
    @endforeach
</div>

@if ($post->comentarios->count() > 5)
    <div class="text-center mt-2">
        <button class="btn btn-sm btn-primary mb-2 load-more-comentarios"
                data-post-id="{{ $post->id }}"
                data-offset="5">
            Mostrar más comentarios
        </button>
    </div>
@endif

    {{-- Apartado de nuevo comentario --}}
    @auth
    <form id="form-nuevo-comentario-{{ $post->id }}" class="form-comment d-flex gap-2 form-nuevo-comentario" action="{{ route('comentarios.store', $post->id) }}" method="POST" data-post-id="{{ $post->id }}">
        @csrf
        <input type="hidden" name="post_id" value="{{ $post->id }}">
        <input type="text" name="content" class="form-control" placeholder="Escribe un comentario..." required>
        <button class="btn btn-outline-primary" type="submit">Enviar</button>
    </form>
    @endauth
    @guest
        <p class="text-muted small">Inicia sesión para comentar esta publicación.</p>
    @endguest
</div>
    @endforeach
          </div>
          <!-- Links de paginación -->
           <!-- Pagination -->
            <div id="paginator" class="col col-md-4 col-6 order-md-3 order-2">
                <nav aria-label="Page navigation">
                  {{ $posts->links('pagination::bootstrap-4') }}
                </nav>
              </div>
              <x-partials.sidebar/>

            </div>
            
         
<div id="image-modal" class="modal d-none" onclick="closeModal()">
    <span class="close">&times;</span>
    <img class="modal-content" id="modal-img">
</div>
<style>
    .bg-tecolli{
        background-color:#747919 ;
        /* background-color:#0f4020 ; */
    }
    /* Estilos para mostrar imagenes tipo TopLevel */
    .pointer{
        cursor: pointer;
    }
    .modal {
        display: flex;
        align-items: center;
        justify-content: center;
        position: fixed;
        z-index: 1050;
        left: 0;
        top: 0;
        width: 100vw;
        height: 100vh;
        background-color: rgba(0,0,0,0.8);
        backdrop-filter: blur(2px);
    }

        .modal-content {
        display: flex;
        align-items: center;
        justify-content: center;
        padding: 0;
        border-radius: 10px;
        background-color: transparent;
        max-width: 50vw;
        max-height: 90vh;
        overflow: hidden;
    }

    @media (max-width: 768px) {
        .modal-content {
        display: flex;
        align-items: center;
        justify-content: center;
        padding: 0;
        border-radius: 10px;
        background-color: transparent;
        max-width: 90vw;
        max-height: 90vh;
        overflow: hidden;
    }
    }

    .modal-content img {
        max-width: 100%;
        max-height: 100%;
        width: auto;
        height: auto;
        object-fit: scale-down;
        border-radius: 10px;
        display: block;
    }


    .close {
        position: absolute;
        top: 1rem;
        right: 1rem;
        font-size: 2rem;
        font-weight: bold;
        color: #fff;
        cursor: pointer;
    }

    .d-none {
        display: none;
    }
    /* Este es el contener tipo top level de las imagenes (+4 imagenes) */
     #all-images-container {
    display: flex;
    flex-direction: column;
    gap: 1rem;
    padding: 1rem;
    
    }

    #all-images-container img {
        width: 100%;
        height: auto;
        border-radius: 0.5rem;
        
    }

    /* A partir de pantallas medianas, usa grid */
    @media (min-width: 768px) {
        #all-images-container {
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(180px, 1fr));
            gap: 1rem;
        }
    }


        @media (min-width: 992px) {
            #all-images-container {
                grid-template-columns: repeat(3, 1fr);
            }
        }

        @media (min-width: 1200px) {
            #all-images-container {
                grid-template-columns: repeat(4, 1fr);
            }
        }

</style>
<script>
    // Este script muestra las imagenes de las publicaciones como si fuera un modal
    function showModal(src) {
        const modal = document.getElementById('image-modal');
        const modalImg = document.getElementById('modal-img');
        modal.classList.remove('d-none');
        modalImg.src = src;
    }

    function closeModal() {
        document.getElementById('image-modal').classList.add('d-none');
    }

    // Delegado por clase para todas las imágenes clicables
    document.addEventListener('DOMContentLoaded', () => {
        document.querySelectorAll('.clickable-img').forEach(img => {
            img.addEventListener('click', () => {
                showModal(img.src);
            });
        });
    });
    // Funcion para mostrar las imagenes
    function showAllImages(imagePaths) {
    const modal = document.getElementById('all-images-modal');
    const container = document.getElementById('all-images-container');
    container.innerHTML = ''; // Limpiar contenido previo

    imagePaths.forEach(path => {
        const img = document.createElement('img');
        img.src = `/storage/${path}`;
        img.classList.add('clickable-img');
        img.classList.add('pointer');
        img.addEventListener('click', () => showModal(img.src));
        container.appendChild(img);
    });

    modal.classList.remove('d-none');
    }

    function closeAllImagesModal() {
        document.getElementById('all-images-modal').classList.add('d-none');
    }
    // Mostrar mas comentarios
    document.addEventListener('DOMContentLoaded', function () {
    const botones = document.querySelectorAll('.load-more-comentarios');

    botones.forEach(btn => {
        btn.addEventListener('click', function () {
            const postId = btn.dataset.postId;
            let offset = parseInt(btn.dataset.offset);

            fetch('{{ route("comentarios.load_more") }}', {
                method: 'POST',
                headers: {
                    'Content-Type': 'application/json',
                    'X-CSRF-TOKEN': '{{ csrf_token() }}'
                },
                body: JSON.stringify({
                    post_id: postId,
                    offset: offset
                })
            })
            .then(response => response.text())
            .then(html => {
                // Importante: usa el contenedor de comentarios correcto por post
                const wrapper = document.getElementById('comentarios-wrapper-' + postId);
                wrapper.insertAdjacentHTML('beforeend', html);
                offset += 5;
                btn.dataset.offset = offset;

                if (html.trim() === '') {
                    btn.remove();
                }
            });
        });
    });
    });
    
</script>
{{-- Nuevos comentarios --}}
<script>
    document.addEventListener('DOMContentLoaded', function () {
        document.querySelectorAll('.form-nuevo-comentario').forEach(form => {
            const input = form.querySelector('input[name="content"]');
            const postId = form.dataset.postId;

            form.addEventListener('submit', function (e) {
                e.preventDefault(); // Evita recargar la página

                const formData = {
                    post_id: postId,
                    content: input.value
                };

                fetch(form.action, {
                    method: 'POST',
                    headers: {
                        'Content-Type': 'application/json',
                        'X-CSRF-TOKEN': '{{ csrf_token() }}'
                    },
                    body: JSON.stringify(formData)
                })
                .then(response => response.text()) // Esperamos HTML del nuevo comentario
                .then(html => {
                    if (html.trim()) {
                        const wrapper = document.getElementById('comentarios-wrapper-' + postId);
                        wrapper.insertAdjacentHTML('afterbegin', html);
                        input.value = ''; // Limpiar input

                        // Ocultar mensaje "No hay comentarios aún" si existe
                        const sinComentarios = wrapper.querySelector('.sin-comentarios');
                        if (sinComentarios) {
                            sinComentarios.remove();
                        }

                        // Actualizar contador
                        const contador = document.getElementById('contador-comentarios-' + postId);
                        if (contador) {
                            const match = contador.textContent.trim().match(/^\d+/);
                            if (match) {
                                const nuevoTotal = parseInt(match[0]) + 1;
                                contador.innerHTML = `
                                    ${nuevoTotal}
                                    <i class="ai-message fs-lg ms-1"></i>
                                `;
                            }
                        }
                    }
                })
                .catch(error => {
                    console.error('Error al enviar comentario:', error);
                });
            });
        });
    });
</script>
<!-- Modal para todas las imágenes -->
<div id="all-images-modal" class="modal d-none" onclick="closeAllImagesModal()">
    <span class="close" onclick="closeAllImagesModal()">&times;</span>
    <div id="all-images-container" style="max-height: 90%; overflow-y: auto;">
        <!-- Imágenes se inyectan aquí -->
    </div>
</div>
</div>
{{-- JS para dropdown (boton de 3 puntos de cada post) --}}
<script>
function toggleDropdown(el) {
    const dropdown = el.nextElementSibling;

    // Cierra otros dropdowns abiertos
    document.querySelectorAll('.dropdown-click').forEach(d => {
        if (d !== dropdown) d.style.display = 'none';
    });

    // Alterna el dropdown actual
    dropdown.style.display = (dropdown.style.display === 'block') ? 'none' : 'block';
}

// Cierra dropdown si haces click fuera
document.addEventListener('click', function(event) {
    document.querySelectorAll('.dropdown-click').forEach(dropdown => {
        if (!dropdown.contains(event.target) && !dropdown.previousElementSibling.contains(event.target)) {
            dropdown.style.display = 'none';
        }
    });
});
</script>

{{-- CSS para boton de 3 puntos --}}
<style>
    .menu-dots-wrapper {
        position: relative;
        display: inline-block;
    }

    .menu-dots-wrapper .three-dots {
        font-size: 1.4rem;
        cursor: pointer;
        padding: 4px 6px;
        border-radius: 50%;
        transition: background 0.2s;
    }

    .menu-dots-wrapper .three-dots:hover {
        background-color: #f0f0f0;
    }

    .menu-dots-wrapper .dropdown-click {
        display: none;
        position: absolute;
        top: 100%;
        right: 0;
        background: white;
        border: 1px solid #ddd;
        border-radius: 4px;
        min-width: 120px;
        z-index: 100;
        box-shadow: 0 2px 6px rgba(0,0,0,0.15);
    }

    .btn-eliminar {
        color: rgb(202, 0, 0);
        background-color: transparent;
        border: none;
        text-align: left;
        padding: 6px 12px;
        width: 100%;
        cursor: pointer;
        transition: background-color 0.2s;
    }

    .btn-eliminar:hover {
        background-color: #f0f0f0; /* gris claro al hover */
    }
    [data-bs-theme="dark"] .btn-eliminar:hover {
        background-color: #2e0099; /* gris claro al hover */
        }
</style>
<script>
    document.getElementById('images_path').addEventListener('change', function(event) {
        const preview = document.getElementById('preview-images');
        preview.innerHTML = ''; // Limpiar previsualizaciones anteriores

        const files = event.target.files;

        if (files.length > 5) {
            alert('Solo puedes subir un máximo de 5 imágenes.');
            this.value = ''; // Resetear input
            return;
        }

        Array.from(files).forEach(file => {
            const reader = new FileReader();
            reader.onload = function(e) {
                const img = document.createElement('img');
                img.src = e.target.result;
                img.style.width = '80px';
                img.style.height = '80px';
                img.style.objectFit = 'cover';
                img.style.borderRadius = '4px';
                preview.appendChild(img);
            }
            reader.readAsDataURL(file);
        });
    });
</script>
    @include('user-actions.modal.edit-post-modal')
    @include('user-actions.modal.create-post-modal')
</x-app-layout>
