@if ($paginator->hasPages())
    <div class="row gy-3 align-items-center mt-lg-5 pt-2 pt-md-4 pt-lg-0" style="display: flex; justify-content: space-between;">
        {{-- Botón "Load more posts" --}}
        {{-- Selector de cantidad por página --}}
        <div class="col col-md-4 col-6 order-md-1 order-1">
            <div class="d-flex align-items-center">
                <span class="text-body-secondary fs-sm">Show</span>
                <select class="form-select form-select-flush w-auto" onchange="location = this.value;">
                    @foreach ([5, 10, 15, 25] as $limit)
                        <option value="{{ request()->fullUrlWithQuery(['per_page' => $limit]) }}"
                            {{ request('per_page') == $limit ? 'selected' : '' }}>
                            {{ $limit }}
                        </option>
                    @endforeach
                </select>
            </div>
        </div>

        {{-- Botón "Load more posts" --}}
        <div class="col col-md-4 col-12 order-md-2 order-3 text-center">
            @if ($paginator->hasMorePages())
                <a href="{{ $paginator->nextPageUrl() }}" class="btn btn-primary w-md-auto w-100">
                    Load more posts
                </a>
            @endif
        </div>

        {{-- Enlaces de paginación --}}
        <div class="col col-md-4 col-6 order-md-3 order-2">
            <nav aria-label="Page navigation">
                <ul class="pagination pagination-sm justify-content-end">
                    @foreach ($elements as $element)
                        {{-- Separador de puntos --}}
                        @if (is_string($element))
                            <li class="page-item disabled mx-1">
                                <span class="page-link">{{ $element }}</span>
                            </li>
                        @endif

                        {{-- Enlaces numerados --}}
                        @if (is_array($element))
                            @foreach ($element as $page => $url)
                                @if ($page == $paginator->currentPage())
                                    <li class="page-item active mx-1" aria-current="page">
                                        <span class="page-link">{{ $page }}
                                            <span class="visually-hidden">(current)</span>
                                        </span>
                                    </li>
                                @else
                                    <li class="page-item mx-1">
                                        <a class="page-link" href="{{ $url }}">{{ $page }}</a>
                                    </li>
                                @endif
                            @endforeach
                        @endif
                    @endforeach
                </ul>
            </nav>
        </div>
    </div>
@endif
