<style>
/* Imagen responsive con relación 4:5 */
.webinar-image {
    width: 100%;           /* Ocupa todo el ancho del contenedor */
    height: auto;          /* Mantiene proporción en móviles */
    aspect-ratio: 4 / 5;   /* Relación 4:5 */
    object-fit: cover;     /* Recorta la imagen si es necesario */
    border-radius: 0.5rem; /* Bordes redondeados */
    display: block;
}

/* Altura fija en pantallas grandes */
@media (min-width: 992px) { /* Bootstrap lg */
    .webinar-image {
        height: 250px;     /* Altura fija */
        aspect-ratio: auto; /* Ignora el ratio, fuerza altura */
    }
}
</style>

<x-app-layout>
    @php
    $videos = \App\Models\Video::latest()->get();
    @endphp
    <!-- Page container -->
      <div class="container pt-5 pb-lg-5 pb-md-4 pb-2 my-5">
        <!-- Breadcrumb -->
        <nav aria-label="breadcrumb">
          <ol class="pt-lg-3 pb-lg-4 pb-2 breadcrumb">
            {{-- <li class="breadcrumb-item"><a href=" {{ route('dashboard') }} ">Home</a></li> --}}
            <li class="breadcrumb-item active" aria-current="page">Webinars</li>
          </ol>
        </nav>
        <div>

        
    <div class="row mb-md-2 mb-xl-4">
        <!-- Sección de Webinars -->
        <div class="col-lg-9 pe-lg-4 pe-xl-5">
        <h1 class="pb-3 pb-lg-4">Conversando con...</h1>

        <!-- Lista de Webinars -->
        @foreach ($webinars as $webinar)
        <article class="row g-3 mb-4 align-items-center">
    <div class="col-12 col-md-5">
        <div style="width: 100%; aspect-ratio: 4 / 5; overflow: hidden; border-radius: 0.5rem;">
            <img 
                src="{{ $webinar->image_url ? asset('storage/' . $webinar->image_url) : 'https://via.placeholder.com/600x750?text=Webinar' }}" 
                alt="imagen-webinar"
                class="webinar-image"
                style="width: 100%; height: 100%; object-fit: cover;">
        </div>
    </div>

    <div class="col-12 col-md-7">
        <div class="pt-3 pt-md-0 ps-md-3">
            <h3 class="mb-2">{{ $webinar->titulo }}</h3>
            <p>{{ Str::limit($webinar->descripcion, 100) }}</p>

            <div class="d-flex flex-wrap align-items-center mt-2">
                <span class="fs-sm text-body-secondary me-3">
                    <i class="ai-calendar me-1"></i>
                    {{ \Carbon\Carbon::parse($webinar->fecha)->format('d/m/Y') }} - {{ \Carbon\Carbon::parse($webinar->hora)->format('H:i') }} hrs
                </span>
                <span class="fs-xs opacity-20 mx-2">|</span>
                <span class="fs-sm text-body-secondary">
                    Estado: <strong>{{ $webinar->status }}</strong>
                </span>
            </div>

            <p class="mt-2">
                Presentado por <strong>{{ $webinar->nombre_presentador }}</strong>
            </p>

            <a href="{{ $webinar->link }}" class="btn btn-sm btn-primary mt-2" target="_blank">
                Ir al webinar
            </a>
        </div>
    </div>
</article>

        
        @endforeach

        <!-- Paginación -->
        <div class="col col-md-4 col-6 order-md-3 order-2">
            <nav aria-label="Page navigation">
            {{ $webinars->links('pagination::bootstrap-4') }}
            </nav>
        </div>
        
    </div>
<x-partials.sidebar/>
    </div>

</x-app-layout>
