<?php

use App\Http\Controllers\BolsaDeTrabajoController;
use App\Http\Controllers\ComentarioController;
use App\Http\Controllers\EmpresasController;
use App\Http\Controllers\NewsletterController;
use App\Http\Controllers\NoticiasController;
use Illuminate\Support\Facades\Route;
use App\Http\Controllers\PostController;
use App\Http\Controllers\PrerregistroController;
use App\Http\Controllers\UserActionController;
use App\Http\Controllers\VideoController;
use App\Http\Controllers\WebinarsController;
use App\Models\BolsaDeTrabajo;

// Route::get('/', function () {
//     return view('welcome');
// });

// Route::get('/', [PostController::class, 'index'])->name('welcome');

//Ruta para tipo de Landing page
Route::view('/', 'welcome')->name('welcome');

Route::get('/noticias-recientNews', [NoticiasController::class, 'recientNews'])->name('noticias.recientNews');

Route::view('/contactanos', 'contactanos')->name('contactanos');

Route::view('/faq', 'faq/index')->name('faq');

Route::view('/nuestros-aliados', 'nuestros-aliados')->name('nuestros-aliados');

Route::get('/empresas', [EmpresasController::class,'index'])->name('empresas.index');

Route::get('/noticias', [NoticiasController::class, 'index'])->name('noticias.index');

Route::get('/noticias/{noticia}', [NoticiasController::class, 'show'])->name('noticias.show');



Route::view('/prerregistro', 'prerregistro/prerregistro')->name('prerregistro');

Route::view('/prerregistro-final', 'prerregistro/prerregistro-final')->name('prerregistro-final');

//Route::redirect('/register','/prerregistro');
// Ruta para los eventos


Route::post('/prerregistros', [PrerregistroController::class, 'store'])->name('prerregistros.store');

Route::get('/suscripcion', [EmpresasController::class,'suscripcion'])->name('empresas.suscripcion');

Route::middleware(['auth', 'check.membresia'])->group(function () {
    Route::get('/bolsa-de-trabajo',[BolsaDeTrabajoController::class,'index'])->name('trabajo.index');
});

Route::middleware([
    'auth:sanctum',
    config('jetstream.auth_session'),
    'verified',
])->group(function () {

    Route::get('/dashboard', function () {return view('dashboard'); })->name('dashboard');
    Route::redirect('/dashboard','/');

   //Rutas de busqueda
    Route::get('/buscar', [EmpresasController::class, 'buscarFormulario'])->name('perfiles.buscar');
    Route::get('/resultados', [EmpresasController::class, 'resultados'])->name('perfiles.resultados');
    
    Route::get('/posts/{post}', [PostController::class, 'show'])->name('posts.show');

    Route::get('/posts', [PostController::class, 'index'])->name('posts.index');
 
    Route::get('/webinars',[WebinarsController::class, 'index'])->name('webinars.index');
    
    Route::get('/empresas/{perfilEmpresarial}', [EmpresasController::class,'show'])->name('empresas.show');
    
    Route::post('/posts/{post}/comentarios', [ComentarioController::class, 'store'])->name('comentarios.store');

    Route::post('/comentarios/load-more', [ComentarioController::class, 'loadMore'])->name('comentarios.load_more');


    Route::post('/newsletter/subscribe', [NewsletterController::class, 'subscribe'])->name('newsletter.subscribe');

    Route::get('/mis-publicaciones',[UserActionController::class, 'misPublicaciones'])->name('user.mis_publicaciones');
    Route::post('/crear-publicacion',[UserActionController::class, 'crearPublicacion'])->name('user.crear_publicacion');
    Route::delete('/eliminar-publicacion/{post}',[UserActionController::class, 'eliminarPublicacion'])->name('user.eliminar_publicacion');
    // Mostrar modal/editar
    Route::get('/publicaciones/{post}/editar', [UserActionController::class, 'editarPublicacion'])
        ->name('user.editar_publicacion');

    // Actualizar publicación
    Route::put('/publicaciones/{post}', [UserActionController::class, 'actualizarPublicacion'])
        ->name('user.actualizar_publicaciones');

    Route::post('/publicacion',[PostController::class,'store'])->name('publicacion.store');

});
