<style>
/* Imagen responsive con relación 4:5 */
.webinar-image {
    width: 100%;           /* Ocupa todo el ancho del contenedor */
    height: auto;          /* Mantiene proporción en móviles */
    aspect-ratio: 4 / 5;   /* Relación 4:5 */
    object-fit: cover;     /* Recorta la imagen si es necesario */
    border-radius: 0.5rem; /* Bordes redondeados */
    display: block;
}

/* Altura fija en pantallas grandes */
@media (min-width: 992px) { /* Bootstrap lg */
    .webinar-image {
        height: 250px;     /* Altura fija */
        aspect-ratio: auto; /* Ignora el ratio, fuerza altura */
    }
}
</style>

<?php if (isset($component)) { $__componentOriginal9ac128a9029c0e4701924bd2d73d7f54 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal9ac128a9029c0e4701924bd2d73d7f54 = $attributes; } ?>
<?php $component = App\View\Components\AppLayout::resolve([] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('app-layout'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\App\View\Components\AppLayout::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes([]); ?>
    <?php
    $videos = \App\Models\Video::latest()->get();
    ?>
    <!-- Page container -->
      <div class="container pt-5 pb-lg-5 pb-md-4 pb-2 my-5">
        <!-- Breadcrumb -->
        <nav aria-label="breadcrumb">
          <ol class="pt-lg-3 pb-lg-4 pb-2 breadcrumb">
            
            <li class="breadcrumb-item active" aria-current="page">Webinars</li>
          </ol>
        </nav>
        <div>

        
    <div class="row mb-md-2 mb-xl-4">
        <!-- Sección de Webinars -->
        <div class="col-lg-9 pe-lg-4 pe-xl-5">
        <h1 class="pb-3 pb-lg-4">Conversando con...</h1>

        <!-- Lista de Webinars -->
        <?php $__currentLoopData = $webinars; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $webinar): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
        <article class="row g-3 mb-4 align-items-center">
    <div class="col-12 col-md-5">
        <div style="width: 100%; aspect-ratio: 4 / 5; overflow: hidden; border-radius: 0.5rem;">
            <img 
                src="<?php echo e($webinar->image_url ? asset('storage/' . $webinar->image_url) : 'https://via.placeholder.com/600x750?text=Webinar'); ?>" 
                alt="imagen-webinar"
                class="webinar-image"
                style="width: 100%; height: 100%; object-fit: cover;">
        </div>
    </div>

    <div class="col-12 col-md-7">
        <div class="pt-3 pt-md-0 ps-md-3">
            <h3 class="mb-2"><?php echo e($webinar->titulo); ?></h3>
            <p><?php echo e(Str::limit($webinar->descripcion, 100)); ?></p>

            <div class="d-flex flex-wrap align-items-center mt-2">
                <span class="fs-sm text-body-secondary me-3">
                    <i class="ai-calendar me-1"></i>
                    <?php echo e(\Carbon\Carbon::parse($webinar->fecha)->format('d/m/Y')); ?> - <?php echo e(\Carbon\Carbon::parse($webinar->hora)->format('H:i')); ?> hrs
                </span>
                <span class="fs-xs opacity-20 mx-2">|</span>
                <span class="fs-sm text-body-secondary">
                    Estado: <strong><?php echo e($webinar->status); ?></strong>
                </span>
            </div>

            <p class="mt-2">
                Presentado por <strong><?php echo e($webinar->nombre_presentador); ?></strong>
            </p>

            <a href="<?php echo e($webinar->link); ?>" class="btn btn-sm btn-primary mt-2" target="_blank">
                Ir al webinar
            </a>
        </div>
    </div>
</article>

        
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

        <!-- Paginación -->
        <div class="col col-md-4 col-6 order-md-3 order-2">
            <nav aria-label="Page navigation">
            <?php echo e($webinars->links('pagination::bootstrap-4')); ?>

            </nav>
        </div>
        
    </div>
<?php if (isset($component)) { $__componentOriginal8a90b09948b4190a2fef0d746222fe65 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal8a90b09948b4190a2fef0d746222fe65 = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'components.partials.sidebar','data' => []] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('partials.sidebar'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\Illuminate\View\AnonymousComponent::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes([]); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal8a90b09948b4190a2fef0d746222fe65)): ?>
<?php $attributes = $__attributesOriginal8a90b09948b4190a2fef0d746222fe65; ?>
<?php unset($__attributesOriginal8a90b09948b4190a2fef0d746222fe65); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal8a90b09948b4190a2fef0d746222fe65)): ?>
<?php $component = $__componentOriginal8a90b09948b4190a2fef0d746222fe65; ?>
<?php unset($__componentOriginal8a90b09948b4190a2fef0d746222fe65); ?>
<?php endif; ?>
    </div>

 <?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal9ac128a9029c0e4701924bd2d73d7f54)): ?>
<?php $attributes = $__attributesOriginal9ac128a9029c0e4701924bd2d73d7f54; ?>
<?php unset($__attributesOriginal9ac128a9029c0e4701924bd2d73d7f54); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal9ac128a9029c0e4701924bd2d73d7f54)): ?>
<?php $component = $__componentOriginal9ac128a9029c0e4701924bd2d73d7f54; ?>
<?php unset($__componentOriginal9ac128a9029c0e4701924bd2d73d7f54); ?>
<?php endif; ?>
<?php /**PATH C:\Users\tudio\Documents\906-Directorio\resources\views/webinars/index.blade.php ENDPATH**/ ?>