<?php
    use App\Models\PublicidadPagada;
    $publicidades = PublicidadPagada::where('status', true)->get();
?>

<?php if($publicidades->count() > 0): ?>
<div id="carruselPublicidad" 
     style="position: relative; width: 100%; aspect-ratio: 16 / 9; overflow: hidden;" 
     class="">
    <?php $__currentLoopData = $publicidades; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $pub): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
        <div class="slide" style="
            position: absolute;
            top: 0;
            left: 0;
            width: 100%;
            height: 100%;
            transition: opacity 0.5s;
            opacity: <?php echo e($index === 0 ? '1' : '0'); ?>;
        ">
        <a href="<?php echo e($pub->link); ?>">
            <img src="<?php echo e(asset('storage/' . $pub->image_path)); ?>" 
                 alt="<?php echo e($pub->titulo); ?>" 
                 style="width:100%; height:100%; object-fit: cover;">
        </a>
        </div>
    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
</div>


<script>
    const slides = document.querySelectorAll('#carruselPublicidad .slide');
    const tiempos = <?php echo json_encode($publicidades->pluck('tiempo'), 15, 512) ?>;
    let current = 0;

    function showNextSlide() {
        slides[current].style.opacity = 0;
        current = (current + 1) % slides.length;
        slides[current].style.opacity = 1;

        setTimeout(showNextSlide, tiempos[current] * 1000);
    }

    if(slides.length > 1){
        setTimeout(showNextSlide, tiempos[0] * 1000);
    }
</script>
<?php endif; ?>
<?php /**PATH C:\Users\tudio\Documents\906-Directorio\resources\views/components/publicidad.blade.php ENDPATH**/ ?>