<style>
    /* Imagen exclusiva Founder */
.founding-badge {
  max-height: 250px;
  height: auto;
}

/* Ajuste para logos */
.logo-empresa {
  object-fit: contain;
  max-height: 100%;
  max-width: 100%;
  padding: .5rem; /* opcional para que no pegue al borde */
}

/* Ratio personalizado 9:3 */
.ratio-9x3 {
  aspect-ratio: 9 / 3; /* disponible en navegadores modernos */
}
@media (max-width: 576px) {
  .logo-empresa {
    width: 180px;
    height: auto; /* mantiene proporción */
  }
}
</style>
<div class="container text-center">

    <?php
        use App\Models\TipoDeMembresia;

        // Traemos todos los tipos de membresía con sus perfiles
        $tipos = TipoDeMembresia::with('perfilesEmpresariales')->get();
    ?>

    <?php $__currentLoopData = $tipos; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $tipo): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
        <?php if($tipo->perfilesEmpresariales->isNotEmpty()): ?>
            <div class="d-flex justify-content-center align-items-center mb-4">
                <h3 class="mb-0">
                    <?php if(strtolower($tipo->nombre) === 'founder'): ?>
                        Founding Cohort
                    <?php else: ?>
                        Miembros <?php echo e($tipo->nombre); ?>

                    <?php endif; ?>
                </h3>

                <?php if(strtolower($tipo->nombre) === 'founder'): ?>
                    <img src="<?php echo e(asset('assets/tecolli-founding.png')); ?>" 
                    alt="Founding Cohort" 
                    class="ms-3 img-fluid d-inline-block logo-empresa"
                    style="max-height: 250px; height: auto;">

                <?php endif; ?>
            </div>

            <div class="row justify-content-center align-items-center mb-5">
                <?php $__currentLoopData = $tipo->perfilesEmpresariales; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $empresa): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <div class="col-6 col-md-3 mb-3">
                        <img src="<?php echo e(asset('storage/' . $empresa->logo_path)); ?>" 
                             class="img-fluid shadow-sm" 
                             alt="<?php echo e($empresa->nombre_comercial ?? 'Logo'); ?>">
                    </div>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </div>
        <?php endif; ?>
    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

</div>
<?php /**PATH C:\Users\tudio\Documents\906-Directorio\resources\views/components/logo-wall.blade.php ENDPATH**/ ?>