<?php if($videos->count()): ?>
<style>
    .video-carousel {
        position: relative;
        max-width: 800px;
        margin: auto;
        overflow: hidden;
    }

    .video-slide {
        display: none;
        position: absolute;
        width: 100%;
    }

    .video-slide iframe {
        width: 100%;
        height: 450px;
        border: none;
    }

    input[name="carousel"] {
        display: none;
    }

    input[name="carousel"]:checked + .video-slide {
        display: block;
        position: relative;
    }

    .carousel-controls {
        margin-top: 10px;
        text-align: center;
    }

    .carousel-controls label {
        background-color: #333;
        color: white;
        padding: 0.5rem 1rem;
        cursor: pointer;
        border-radius: 5px;
        user-select: none;
        margin: 0 10px;
    }

    .carousel-nav {
        text-align: center;
        margin-top: 1rem;
    }

    .carousel-nav label {
        display: inline-block;
        width: 12px;
        height: 12px;
        margin: 0 5px;
        background-color: #999;
        border-radius: 50%;
        cursor: pointer;
    }

    .carousel-nav label:hover {
        background-color: #333;
    }
</style>

<div class="video-carousel">
    <?php $__currentLoopData = $videos; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $video): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
        <input type="radio" name="carousel" id="video<?php echo e($index); ?>" <?php echo e($index === 0 ? 'checked' : ''); ?>>
        <div class="video-slide">
            <iframe src="<?php echo e($video->youtube_embed_url); ?>" title="<?php echo e($video->title); ?>" allowfullscreen></iframe>
        </div>
    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

    <div class="carousel-controls">
        <?php $__currentLoopData = $videos; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $video): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <?php
                $prev = $index === 0 ? count($videos) - 1 : $index - 1;
                $next = $index === count($videos) - 1 ? 0 : $index + 1;
            ?>
            <div class="nav-group" id="nav-<?php echo e($index); ?>" style="display: <?php echo e($index === 0 ? 'block' : 'none'); ?>">
                <label for="video<?php echo e($prev); ?>">← Anterior</label>
                <label for="video<?php echo e($next); ?>">Siguiente →</label>
            </div>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
    </div>

    <div class="carousel-nav">
        <?php $__currentLoopData = $videos; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $video): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <label for="video<?php echo e($index); ?>"></label>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
    </div>
</div>

<script>
    document.addEventListener('DOMContentLoaded', function () {
        const inputs = document.querySelectorAll('input[name="carousel"]');
        const navGroups = document.querySelectorAll('.nav-group');
        let currentIndex = 0;
        let interval = null;
        let userInteracted = false;

        function updateNavDisplay(index) {
            navGroups.forEach((group, i) => {
                group.style.display = i === index ? 'block' : 'none';
            });
        }

        function startCarousel() {
            interval = setInterval(() => {
                if (userInteracted) return;
                inputs[currentIndex].checked = false;
                currentIndex = (currentIndex + 1) % inputs.length;
                inputs[currentIndex].checked = true;
                updateNavDisplay(currentIndex);
            }, 10000);
        }

        inputs.forEach((input, index) => {
            input.addEventListener('change', () => {
                currentIndex = index;
                userInteracted = true;
                clearInterval(interval);
                updateNavDisplay(currentIndex);
            });
        });

        updateNavDisplay(currentIndex);
        startCarousel();
    });
</script>
<?php else: ?>
    <p class="text-center">No hay videos disponibles.</p>
<?php endif; ?>
<?php /**PATH C:\Users\tudio\Documents\906-Directorio\resources\views/components/partials/carrusel-videos.blade.php ENDPATH**/ ?>