
<!-- Modal -->
<div id="miModal" class="modal-np">
  <div class="modal-contenido">
    <span class="cerrar">&times;</span>
    <h2>Crear nueva publicación</h2>

    <form action="<?php echo e(route('user.crear_publicacion')); ?>" method="POST" enctype="multipart/form-data">
    <?php echo csrf_field(); ?>

    
    <?php if($errors->any()): ?>
        <div class="alert alert-danger">
            <ul class="mb-0">
                <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <li><?php echo e($error); ?></li>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </ul>
        </div>
    <?php endif; ?>

    <!-- Título -->
    <div class="mb-3">
        <label for="title" class="form-label">Título</label>
        <input type="text" class="form-control" id="title" name="title" 
               placeholder="Título del post" maxlength="255"
               value="<?php echo e(old('title')); ?>">
    </div>

    <!-- Contenido -->
    <div class="mb-3">
        <label for="content" class="form-label">Contenido</label>
        <textarea class="form-control" id="content" name="content" rows="4" 
                  placeholder="Escribe el contenido del post"><?php echo e(old('content')); ?></textarea>
    </div>

    <!-- Temas (Tom Select) -->
    <div class="mb-3">
        <label for="temas" class="form-label">Temas del post</label>
        <select class="form-control" id="temas" name="temas[]" multiple>
            <?php $__currentLoopData = \App\Models\Tema::all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $tema): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <option value="<?php echo e($tema->id); ?>" 
                    <?php echo e((collect(old('temas'))->contains($tema->id)) ? 'selected' : ''); ?>>
                    <?php echo e($tema->nombre); ?>

                </option>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </select>
    </div>

    <!-- Imágenes -->
    <div class="mb-3">
        <label for="images_path" class="form-label">Imágenes</label>
        <input type="file" class="form-control" id="images_path" name="images_path[]" 
            accept="image/*" multiple>
        <small class="form-text text-muted">Máximo 5 imágenes.</small>

        
        <div id="preview-images" class="mt-2 d-flex flex-wrap gap-2"></div>

        
        <?php if(isset($imagesArray) && count($imagesArray)): ?>
            <div class="mt-2 d-flex flex-wrap gap-2">
                <?php $__currentLoopData = $imagesArray; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $img): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <img src="<?php echo e(Storage::url($img)); ?>" alt="Preview" 
                        style="width: 80px; height: 80px; object-fit: cover; border-radius: 4px;">
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </div>
        <?php endif; ?>
    </div>

    <!-- Hidden fields -->
    <input type="hidden" name="published_at" value="<?php echo e(old('published_at', now())); ?>">
    <input type="hidden" name="user_id" value="<?php echo e(auth()->id()); ?>">

    <button type="submit" class="btn btn-primary">Crear publicación</button>
</form>

  </div>
</div>

<!-- Estilos del modal -->
<style>
/* --- Base (modo claro por defecto) --- */
.modal-np {
  display: none;
  position: fixed;
  z-index: 999;
  left: 0;
  top: 0;
  width: 100%;
  height: 100%;
  background: rgba(0,0,0,0.6);
  justify-content: center;
  align-items: center;
}

.modal-contenido {
  background: #ffffff;
  color: #212529;
  padding: 20px;
  border-radius: 8px;
  width: 500px;
  max-width: 90%;
  text-align: left;
  position: relative;
}

.cerrar {
  position: absolute;
  top: 10px;
  right: 15px;
  font-size: 24px;
  cursor: pointer;
  color: #212529;
}

/* --- Tom Select (claro) --- */
#temas-ts-dropdown {
  width: 100%;
  background-color: #d7dde2;
}
#temas-ts-control {
  padding: 10px;
  border: 1px solid #d7dde2 !important;
  border-radius: 4px;
  box-shadow: none !important;
}
.ts-wrapper {
  border-radius: 8px;
  border: 1px solid #ced4da;
  background: #fff;
  font-size: 0.95rem;
  min-height: 44px;
  transition: all 0.2s;
}
.ts-control {
  border: none !important;
  box-shadow: none !important;
  padding: 6px 10px;
  min-height: 42px;
  display: flex;
  flex-wrap: wrap;
  gap: 6px;
  background: #fff;
  color: #212529;
}
.ts-control .item {
  background: #0d6efd;
  color: #fff;
  border-radius: 20px;
  padding: 4px 12px;
  font-size: 0.85rem;
  font-weight: 500;
  display: flex;
  align-items: center;
  gap: 6px;
}
.ts-control .item .remove {
  color: #fff;
  opacity: 0.8;
  font-size: 14px;
  cursor: pointer;
}
.ts-control .item .remove:hover {
  opacity: 1;
}
.ts-dropdown {
  border: 1px solid #ced4da;
  border-radius: 8px;
  margin-top: 4px;
  padding: 4px 0;
  box-shadow: 0 6px 16px rgba(0,0,0,0.15);
  background: #fff;
  z-index: 1056;
}
.ts-dropdown .option {
  padding: 8px 12px;
  cursor: pointer;
  color: #212529;
}
.ts-dropdown .option:hover,
.ts-dropdown .option.active {
  background: #f1f5f9;
}
.ts-wrapper .ts-control > input {
  color: #6c757d;
  font-size: 0.9rem;
}

/* ============================= */
/*       MODO OSCURO             */
/* ============================= */
[data-bs-theme="dark"] .modal-contenido {
  background: #1e293b;      /* Fondo modal */
  color: #e2e8f0;           /* Texto */
}
[data-bs-theme="dark"] .cerrar {
  color: #e2e8f0;
}

[data-bs-theme="dark"] .ts-wrapper {
  border: 1px solid #334155;
  background: #0f172a;
  color: #e2e8f0;
}
[data-bs-theme="dark"] .ts-control {
  background: #0f172a;
  color: #e2e8f0;
}
[data-bs-theme="dark"] .ts-wrapper .ts-control > input {
  color: #94a3b8; /* placeholder */
}
[data-bs-theme="dark"] .ts-dropdown {
  background: #1e293b;
  border: 1px solid #334155;
  color: #e2e8f0;
}
[data-bs-theme="dark"] .ts-dropdown .option {
  color: #e2e8f0;
}
[data-bs-theme="dark"] .ts-dropdown .option:hover,
[data-bs-theme="dark"] .ts-dropdown .option.active {
  background: #334155;
}

</style>

<!-- Tom Select -->
<link href="https://cdn.jsdelivr.net/npm/tom-select/dist/css/tom-select.bootstrap5.min.css" rel="stylesheet">
<script src="https://cdn.jsdelivr.net/npm/tom-select/dist/js/tom-select.complete.min.js"></script>

<script>
const btnNuevaPublicacion = document.getElementById("btnNuevaPublicacion");
const miModal = document.getElementById("miModal");
const cerrarModal = miModal.querySelector(".cerrar");

let tomSelectInstance; // Guardamos la instancia para inicializar solo una vez

// Abrir modal
btnNuevaPublicacion.addEventListener("click", () => {
  miModal.style.display = "flex";

  // Inicializar Tom Select solo la primera vez
  if (!tomSelectInstance) {
    tomSelectInstance = new TomSelect('#temas', {
      plugins: ['remove_button'],
      placeholder: 'Selecciona uno o varios temas',
      maxItems: null // ilimitado
    });
  }
});

// Cerrar modal
cerrarModal.addEventListener("click", () => {
  miModal.style.display = "none";
});

// Cerrar modal al hacer clic fuera del contenido
window.addEventListener("click", (e) => {
  if (e.target === miModal) miModal.style.display = "none";
});

// Submit del formulario (puedes reemplazar con AJAX)
document.getElementById("formNuevaPublicacion").addEventListener("submit", function(e){
    e.preventDefault();
    alert("Formulario enviado!");
    miModal.style.display = "none";
});
</script>
<?php /**PATH C:\Users\tudio\Documents\906-Directorio\resources\views/user-actions/modal/create-post-modal.blade.php ENDPATH**/ ?>