/*
 * Decompiled with CFR 0.152.
 */
package net.jsign;

import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

class DirectoryScanner {
    DirectoryScanner() {
    }

    public List<Path> scan(String glob) throws IOException {
        glob = glob.replace('\\', '/').replace("/+", "/");
        final String basedir = this.findBaseDirectory(glob);
        glob = glob.substring(basedir.length());
        final Pattern pattern = Pattern.compile(this.globToRegExp(glob));
        final int maxDepth = this.maxPatternDepth(glob);
        final ArrayList<Path> matches = new ArrayList<Path>();
        Files.walkFileTree(new File(basedir).toPath(), (FileVisitor<? super Path>)new FileVisitor<Path>(){
            private int depth = -1;

            @Override
            public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) {
                String name = dir.getFileName().toString();
                if (this.depth + 1 > maxDepth || ".svn".equals(name) || ".git".equals(name)) {
                    return FileVisitResult.SKIP_SUBTREE;
                }
                ++this.depth;
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) {
                String filename = file.toString();
                if ((filename = filename.replaceAll("\\\\", "/")).startsWith("./")) {
                    filename = filename.substring(2);
                }
                if (filename.startsWith(basedir)) {
                    filename = filename.substring(basedir.length());
                }
                if (pattern.matcher(filename).matches()) {
                    matches.add(file);
                }
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult visitFileFailed(Path file, IOException exc) {
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult postVisitDirectory(Path dir, IOException exc) {
                --this.depth;
                return FileVisitResult.CONTINUE;
            }
        });
        return matches;
    }

    String globToRegExp(String glob) {
        String delimiters = "/\\";
        StringTokenizer tokenizer = new StringTokenizer(glob, delimiters, true);
        boolean ignoreNextSeparator = false;
        StringBuilder pattern = new StringBuilder();
        while (tokenizer.hasMoreTokens()) {
            String token = tokenizer.nextToken();
            if (token.length() == 1 && delimiters.contains(token)) {
                if (ignoreNextSeparator) continue;
                pattern.append("/");
                continue;
            }
            if ("**".equals(token)) {
                pattern.append("(?:|.*/)");
                ignoreNextSeparator = true;
                continue;
            }
            if (token.contains("*")) {
                ignoreNextSeparator = false;
                pattern.append("\\Q").append(token.replaceAll("\\*", "\\\\E[^/]*\\\\Q")).append("\\E");
                continue;
            }
            ignoreNextSeparator = false;
            pattern.append("\\Q").append(token).append("\\E");
        }
        return pattern.toString().replaceAll("/+", "/");
    }

    String findBaseDirectory(String pattern) {
        Pattern regexp = Pattern.compile("([^*]*/).*");
        Matcher matcher = regexp.matcher(pattern);
        if (matcher.matches()) {
            return matcher.group(1);
        }
        return "";
    }

    int maxPatternDepth(String pattern) {
        if (pattern.contains("**")) {
            return 50;
        }
        int depth = 0;
        for (int i = 0; i < pattern.length(); ++i) {
            if (pattern.charAt(i) != '/') continue;
            ++depth;
        }
        return depth;
    }
}

