/*
 * Decompiled with CFR 0.152.
 */
package net.jsign;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.jsign.DirectoryScanner;
import net.jsign.SignerException;
import net.jsign.SignerHelper;
import net.jsign.StdOutLogHandler;
import net.jsign.commons.cli.CommandLine;
import net.jsign.commons.cli.DefaultParser;
import net.jsign.commons.cli.HelpFormatter;
import net.jsign.commons.cli.Option;
import net.jsign.commons.cli.Options;
import net.jsign.commons.cli.ParseException;
import net.jsign.commons.io.ByteOrderMark;
import net.jsign.commons.io.IOUtils;
import net.jsign.commons.io.input.BOMInputStream;

public class JsignCLI {
    public static void main(String ... args) {
        try {
            new JsignCLI().execute(args);
        }
        catch (IllegalArgumentException | SignerException | ParseException e) {
            System.err.println("jsign: " + e.getMessage());
            if (e.getCause() != null) {
                e.getCause().printStackTrace(System.err);
            }
            System.err.println("Try `" + JsignCLI.getProgramName() + " --help' for more information.");
            System.exit(1);
        }
    }

    private Map<String, Options> getOptions() {
        LinkedHashMap<String, Options> map = new LinkedHashMap<String, Options>();
        Options options = new Options();
        options.addOption(Option.builder("s").hasArg().longOpt("keystore").argName("FILE").desc("The keystore file, the SunPKCS11 configuration file, the cloud keystore name, or the card/token name").type(File.class).build());
        options.addOption(Option.builder().hasArg().longOpt("storepass").argName("PASSWORD").desc("The password to open the keystore").build());
        options.addOption(Option.builder().hasArg().longOpt("storetype").argName("TYPE").desc("The type of the keystore\nFile based:\n- JKS: Java keystore (.jks files)\n- JCEKS: SunJCE keystore (.jceks files)\n- PKCS12: Standard PKCS#12 keystore (.p12 or .pfx files)\nHardware tokens\n- PKCS11: PKCS#11 hardware token\n- ETOKEN: SafeNet eToken\n- NITROKEY: Nitrokey HSM\n- OPENPGP: OpenPGP card\n- OPENSC: Smart card\n- PIV: PIV card\n- YUBIKEY: YubiKey security key\nCloud key management systems:\n- AWS: AWS Key Management Service\n- AZUREKEYVAULT: Azure Key Vault key management system\n- DIGICERTONE: DigiCert ONE Secure Software Manager\n- ESIGNER: SSL.com eSigner\n- GARASIGN: Garantir Remote Signing\n- GOOGLECLOUD: Google Cloud KMS\n- HASHICORPVAULT: HashiCorp Vault\n- ORACLECLOUD: Oracle Cloud Key Management Service\n- SIGNPATH: SignPath\n- SIGNSERVER: Keyfactor SignServer\n- TRUSTEDSIGNING: Azure Trusted Signing\n").build());
        options.addOption(Option.builder("a").hasArg().longOpt("alias").argName("NAME").desc("The alias of the certificate used for signing in the keystore").build());
        options.addOption(Option.builder().hasArg().longOpt("keypass").argName("PASSWORD").desc("The password of the private key. When using a keystore, this parameter can be omitted if the keystore shares the same password").build());
        options.addOption(Option.builder().hasArg().longOpt("keyfile").argName("FILE").desc("The file containing the private key. PEM and PVK files are supported").type(File.class).build());
        options.addOption(Option.builder("c").hasArg().longOpt("certfile").argName("FILE").desc("The file containing the PKCS#7 certificate chain\n(.p7b or .spc files)").type(File.class).build());
        options.addOption(Option.builder("d").hasArg().longOpt("alg").argName("ALGORITHM").desc("The digest algorithm (SHA-1, SHA-256, SHA-384 or SHA-512)").build());
        options.addOption(Option.builder("t").hasArg().longOpt("tsaurl").argName("URL").desc("The URL of the timestamping authority. Several URLs separated by a comma can be specified to fallback on alternative servers").build());
        options.addOption(Option.builder("t").hasArg().longOpt("tsaurl").argName("URL").desc("The URL of the timestamping authority").build());
        options.addOption(Option.builder("m").hasArg().longOpt("tsmode").argName("MODE").desc("The timestamping mode (RFC3161 or Authenticode)").build());
        options.addOption(Option.builder("r").hasArg().longOpt("tsretries").argName("NUMBER").desc("The number of retries for timestamping").build());
        options.addOption(Option.builder("w").hasArg().longOpt("tsretrywait").argName("SECONDS").desc("The number of seconds to wait between timestamping retries").build());
        options.addOption(Option.builder("n").hasArg().longOpt("name").argName("NAME").desc("The name of the application").build());
        options.addOption(Option.builder("u").hasArg().longOpt("url").argName("URL").desc("The URL of the application").build());
        options.addOption(Option.builder().hasArg().longOpt("proxyUrl").argName("URL").desc("The URL of the HTTP proxy").build());
        options.addOption(Option.builder().hasArg().longOpt("proxyUser").argName("NAME").desc("The user for the HTTP proxy. If a user is needed").build());
        options.addOption(Option.builder().hasArg().longOpt("proxyPass").argName("PASSWORD").desc("The password for the HTTP proxy user. If a user is needed").build());
        options.addOption(Option.builder().longOpt("replace").desc("Tells if the previous signatures should be replaced").build());
        options.addOption(Option.builder("e").hasArg().longOpt("encoding").argName("ENCODING").desc("The encoding of the script to be signed (UTF-8 by default, or the encoding specified by the byte order mark if there is one)").build());
        options.addOption(Option.builder().longOpt("detached").desc("Tells if a detached signature should be generated or reused").build());
        options.addOption(Option.builder().longOpt("quiet").desc("Print only error messages").build());
        options.addOption(Option.builder().longOpt("verbose").desc("Print more information").build());
        options.addOption(Option.builder().longOpt("debug").desc("Print debugging information").build());
        options.addOption(Option.builder("h").longOpt("help").desc("Print the help").build());
        map.put("sign", options);
        options = new Options();
        options.addOption(Option.builder("t").hasArg().longOpt("tsaurl").argName("URL").desc("The URL of the timestamping authority").build());
        options.addOption(Option.builder("m").hasArg().longOpt("tsmode").argName("MODE").desc("The timestamping mode (RFC3161 or Authenticode)").build());
        options.addOption(Option.builder("r").hasArg().longOpt("tsretries").argName("NUMBER").desc("The number of retries for timestamping").build());
        options.addOption(Option.builder("w").hasArg().longOpt("tsretrywait").argName("SECONDS").desc("The number of seconds to wait between timestamping retries").build());
        options.addOption(Option.builder().hasArg().longOpt("proxyUrl").argName("URL").desc("The URL of the HTTP proxy").build());
        options.addOption(Option.builder().hasArg().longOpt("proxyUser").argName("NAME").desc("The user for the HTTP proxy. If a user is needed").build());
        options.addOption(Option.builder().hasArg().longOpt("proxyPass").argName("PASSWORD").desc("The password for the HTTP proxy user. If a user is needed").build());
        options.addOption(Option.builder().longOpt("replace").desc("Tells if the previous timestamps should be replaced").build());
        map.put("timestamp", options);
        options = new Options();
        options.addOption(Option.builder().hasArg().longOpt("format").argName("FORMAT").desc("      The output format of the signature (DER or PEM)").build());
        map.put("extract", options);
        options = new Options();
        map.put("remove", options);
        options = new Options();
        options.addOption(Option.builder().hasArg().longOpt("value").argName("VALUE").desc("        The value of the unsigned attribute").build());
        map.put("tag", options);
        return map;
    }

    void execute(String ... args) throws SignerException, ParseException {
        Options options;
        DefaultParser parser = new DefaultParser();
        String command = "sign";
        if (args.length >= 1 && !args[0].startsWith("-")) {
            command = args[0];
            args = Arrays.copyOfRange(args, 1, args.length);
        }
        if ((options = this.getOptions().get(command)) == null) {
            throw new ParseException("Unknown command '" + command + "'");
        }
        options.addOption(Option.builder().longOpt("quiet").build());
        options.addOption(Option.builder().longOpt("verbose").build());
        options.addOption(Option.builder().longOpt("debug").build());
        CommandLine cmd = parser.parse(options, args);
        if (cmd.hasOption("help") || args.length == 0) {
            this.printHelp();
            return;
        }
        Logger log = Logger.getLogger("net.jsign");
        log.setLevel(cmd.hasOption("debug") ? Level.FINEST : (cmd.hasOption("verbose") ? Level.FINE : (cmd.hasOption("quiet") ? Level.WARNING : Level.INFO)));
        log.setUseParentHandlers(false);
        Stream.of(log.getHandlers()).forEach(log::removeHandler);
        log.addHandler(new StdOutLogHandler());
        SignerHelper helper = new SignerHelper("option");
        helper.command(command);
        this.setOption("keystore", helper, cmd);
        this.setOption("storepass", helper, cmd);
        this.setOption("storetype", helper, cmd);
        this.setOption("alias", helper, cmd);
        this.setOption("keypass", helper, cmd);
        this.setOption("keyfile", helper, cmd);
        this.setOption("certfile", helper, cmd);
        this.setOption("alg", helper, cmd);
        this.setOption("tsaurl", helper, cmd);
        this.setOption("tsmode", helper, cmd);
        this.setOption("tsretries", helper, cmd);
        this.setOption("tsretrywait", helper, cmd);
        this.setOption("name", helper, cmd);
        this.setOption("url", helper, cmd);
        this.setOption("proxyUrl", helper, cmd);
        this.setOption("proxyUser", helper, cmd);
        this.setOption("proxyPass", helper, cmd);
        helper.replace(cmd.hasOption("replace"));
        this.setOption("encoding", helper, cmd);
        helper.detached(cmd.hasOption("detached"));
        this.setOption("format", helper, cmd);
        this.setOption("value", helper, cmd);
        if (cmd.getArgList().isEmpty()) {
            throw new SignerException("No file specified");
        }
        for (String arg : cmd.getArgList()) {
            for (String filename : this.expand(arg)) {
                if (filename.trim().isEmpty() || filename.startsWith("#")) continue;
                helper.execute(new File(this.unquote(filename)));
            }
        }
    }

    private List<String> expand(String filename) {
        if (filename.startsWith("@")) {
            try {
                return this.readFile(new File(filename.substring(1)));
            }
            catch (IOException e) {
                throw new IllegalArgumentException("Failed to read the file list: " + filename.substring(1), e);
            }
        }
        if (filename.contains("*")) {
            try {
                return new DirectoryScanner().scan(filename).stream().map(Path::toString).collect(Collectors.toList());
            }
            catch (IOException e) {
                throw new IllegalArgumentException("Failed to scan the directory: " + filename, e);
            }
        }
        return Collections.singletonList(filename);
    }

    private List<String> readFile(File file) throws IOException {
        try (BOMInputStream in = new BOMInputStream(new BufferedInputStream(new FileInputStream(file)), false, ByteOrderMark.UTF_8, ByteOrderMark.UTF_16BE, ByteOrderMark.UTF_16LE);){
            List<String> list = IOUtils.readLines((InputStream)in, in.hasBOM() ? in.getBOMCharsetName() : "UTF-8");
            return list;
        }
    }

    private String unquote(String value) {
        if ((value = value.trim()).startsWith("\"") && value.endsWith("\"")) {
            value = value.substring(1, value.length() - 1);
        }
        return value;
    }

    private void setOption(String key, SignerHelper helper, CommandLine cmd) {
        String value = cmd.getOptionValue(key);
        helper.param(key, value);
    }

    private void printHelp() {
        String header = "Sign and timestamp Windows executable files, Microsoft Installers (MSI), Cabinet files (CAB), Catalog files (CAT), Windows packages (APPX/MSIX), Microsoft Dynamics 365 extension packages, NuGet packages and scripts (PowerShell, VBScript, JScript, WSF)\n\n";
        String footer = "\nExamples:\n\n   Signing with a PKCS#12 keystore and timestamping:\n\n     jsign --keystore keystore.p12 --alias test --storepass pwd \\\n           --tsaurl http://timestamp.sectigo.com application.exe\n\n   Signing with a SPC certificate and a PVK key:\n\n     jsign --certfile certificate.spc --keyfile key.pvk --keypass pwd installer.msi\n\nPlease report suggestions and issues on the GitHub project at https://github.com/ebourg/jsign/issues";
        HelpFormatter formatter = new HelpFormatter();
        formatter.setOptionComparator(null);
        formatter.setWidth(85);
        formatter.setDescPadding(1);
        PrintWriter out = new PrintWriter(System.out);
        formatter.printUsage(out, formatter.getWidth(), JsignCLI.getProgramName() + " [COMMAND] [OPTIONS] [FILE] [PATTERN] [@FILELIST]...");
        out.println();
        formatter.printWrapped(out, formatter.getWidth(), header);
        Map<String, Options> options = this.getOptions();
        out.println("commands: " + options.keySet().stream().map(s -> "sign".equals(s) ? s + " (default)" : s).collect(Collectors.joining(", ")));
        for (String command : options.keySet()) {
            if (options.get(command).getOptions().isEmpty()) continue;
            out.println();
            out.println(command + ":");
            formatter.printOptions(out, formatter.getWidth(), options.get(command), formatter.getLeftPadding(), formatter.getDescPadding());
        }
        formatter.printWrapped(out, formatter.getWidth(), footer);
        out.flush();
    }

    private static String getProgramName() {
        return System.getProperty("basename", "java -jar jsign.jar");
    }
}

