/*
 * Decompiled with CFR 0.152.
 */
package net.jsign;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.security.MessageDigest;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.ServiceLoader;
import java.util.function.Supplier;
import net.jsign.DigestAlgorithm;
import net.jsign.asn1.authenticode.AuthenticodeObjectIdentifiers;
import net.jsign.bouncycastle.asn1.ASN1Object;
import net.jsign.bouncycastle.asn1.cms.Attribute;
import net.jsign.bouncycastle.asn1.cms.ContentInfo;
import net.jsign.bouncycastle.cms.CMSSignedData;
import net.jsign.bouncycastle.cms.CMSTypedData;
import net.jsign.bouncycastle.cms.PKCS7ProcessableObject;
import net.jsign.spi.SignableProvider;

public interface Signable
extends Closeable {
    default public CMSTypedData createSignedContent(DigestAlgorithm digestAlgorithm) throws IOException {
        return new PKCS7ProcessableObject(AuthenticodeObjectIdentifiers.SPC_INDIRECT_DATA_OBJID, this.createIndirectData(digestAlgorithm));
    }

    default public ContentInfo createContentInfo(DigestAlgorithm digestAlgorithm) throws IOException {
        return new ContentInfo(AuthenticodeObjectIdentifiers.SPC_INDIRECT_DATA_OBJID, this.createIndirectData(digestAlgorithm));
    }

    default public byte[] computeDigest(MessageDigest digest) throws IOException {
        return this.computeDigest(DigestAlgorithm.of(digest.getAlgorithm()));
    }

    default public byte[] computeDigest(DigestAlgorithm digestAlgorithm) throws IOException {
        return this.computeDigest(digestAlgorithm.getMessageDigest());
    }

    public ASN1Object createIndirectData(DigestAlgorithm var1) throws IOException;

    default public List<Attribute> createSignedAttributes(X509Certificate certificate) throws CertificateEncodingException {
        return new ArrayList<Attribute>();
    }

    default public void validate(Certificate certificate) throws IOException, IllegalArgumentException {
    }

    public List<CMSSignedData> getSignatures() throws IOException;

    public void setSignature(CMSSignedData var1) throws IOException;

    public void save() throws IOException;

    public static Signable of(File file) throws IOException {
        return Signable.of(file, null);
    }

    public static Signable of(File file, Charset encoding) throws IOException {
        Supplier<ServiceLoader> loaders1 = () -> ServiceLoader.load(SignableProvider.class, Signable.class.getClassLoader());
        Supplier<ServiceLoader> loaders2 = () -> ServiceLoader.load(SignableProvider.class);
        for (Supplier loaders : Arrays.asList(loaders1, loaders2)) {
            for (SignableProvider provider : (ServiceLoader)loaders.get()) {
                if (!provider.isSupported(file)) continue;
                return provider.create(file, encoding);
            }
        }
        throw new UnsupportedOperationException("Unsupported file: " + file);
    }
}

