/*
 * Decompiled with CFR 0.152.
 */
package net.jsign;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.NoSuchElementException;
import net.jsign.asn1.authenticode.AuthenticodeObjectIdentifiers;
import net.jsign.bouncycastle.asn1.ASN1Encodable;
import net.jsign.bouncycastle.asn1.ASN1EncodableVector;
import net.jsign.bouncycastle.asn1.ASN1InputStream;
import net.jsign.bouncycastle.asn1.DERSet;
import net.jsign.bouncycastle.asn1.cms.Attribute;
import net.jsign.bouncycastle.asn1.cms.AttributeTable;
import net.jsign.bouncycastle.asn1.cms.CMSAttributes;
import net.jsign.bouncycastle.asn1.cms.ContentInfo;
import net.jsign.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import net.jsign.bouncycastle.cms.CMSException;
import net.jsign.bouncycastle.cms.CMSSignedData;
import net.jsign.bouncycastle.cms.SignerInformation;
import net.jsign.bouncycastle.cms.SignerInformationStore;

public class SignatureUtils {
    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static List<CMSSignedData> getSignatures(byte[] signature) throws IOException {
        try (ASN1InputStream in = new ASN1InputStream(signature);){
            CMSSignedData signedData = new CMSSignedData(null, ContentInfo.getInstance(in.readObject()));
            List<CMSSignedData> list = SignatureUtils.getSignatures(signedData);
            return list;
        }
        catch (ClassCastException | IllegalArgumentException | IllegalStateException | StackOverflowError | NoSuchElementException | CMSException e) {
            throw new IOException(e);
        }
    }

    public static List<CMSSignedData> getSignatures(CMSSignedData signature) throws IOException {
        ArrayList<CMSSignedData> signatures = new ArrayList<CMSSignedData>();
        try {
            if (signature != null) {
                Attribute nestedSignatures;
                signatures.add(signature);
                SignerInformation signerInformation = signature.getSignerInfos().iterator().next();
                AttributeTable unsignedAttributes = signerInformation.getUnsignedAttributes();
                if (unsignedAttributes != null && (nestedSignatures = unsignedAttributes.get(AuthenticodeObjectIdentifiers.SPC_NESTED_SIGNATURE_OBJID)) != null) {
                    for (ASN1Encodable nestedSignature : nestedSignatures.getAttrValues()) {
                        signatures.add(new CMSSignedData(null, ContentInfo.getInstance(nestedSignature)));
                    }
                }
            }
        }
        catch (CMSException e) {
            throw new IOException(e);
        }
        return signatures;
    }

    static CMSSignedData addNestedSignature(CMSSignedData parent, boolean replace, CMSSignedData ... children) {
        SignerInformation signerInformation = parent.getSignerInfos().iterator().next();
        AttributeTable unsignedAttributes = signerInformation.getUnsignedAttributes();
        if (unsignedAttributes == null) {
            unsignedAttributes = new AttributeTable(new DERSet());
        }
        Attribute nestedSignaturesAttribute = unsignedAttributes.get(AuthenticodeObjectIdentifiers.SPC_NESTED_SIGNATURE_OBJID);
        ASN1EncodableVector nestedSignatures = new ASN1EncodableVector();
        if (nestedSignaturesAttribute != null && !replace) {
            for (ASN1Encodable nestedSignature : nestedSignaturesAttribute.getAttrValues()) {
                nestedSignatures.add(nestedSignature);
            }
        }
        for (CMSSignedData nestedSignature : children) {
            nestedSignatures.add(nestedSignature.toASN1Structure());
        }
        ASN1EncodableVector attributes = unsignedAttributes.remove(AuthenticodeObjectIdentifiers.SPC_NESTED_SIGNATURE_OBJID).toASN1EncodableVector();
        attributes.add(new Attribute(AuthenticodeObjectIdentifiers.SPC_NESTED_SIGNATURE_OBJID, new DERSet(nestedSignatures)));
        unsignedAttributes = new AttributeTable(attributes);
        signerInformation = SignerInformation.replaceUnsignedAttributes(signerInformation, unsignedAttributes);
        return CMSSignedData.replaceSigners(parent, new SignerInformationStore(signerInformation));
    }

    static boolean isTimestamped(CMSSignedData signature) {
        SignerInformation signerInformation = signature.getSignerInfos().iterator().next();
        AttributeTable unsignedAttributes = signerInformation.getUnsignedAttributes();
        if (unsignedAttributes == null) {
            return false;
        }
        boolean authenticode = AuthenticodeObjectIdentifiers.isAuthenticode(signature.getSignedContentTypeOID());
        Attribute authenticodeTimestampAttribute = unsignedAttributes.get(CMSAttributes.counterSignature);
        Attribute rfc3161TimestampAttribute = unsignedAttributes.get(authenticode ? AuthenticodeObjectIdentifiers.SPC_RFC3161_OBJID : PKCSObjectIdentifiers.id_aa_signatureTimeStampToken);
        return authenticodeTimestampAttribute != null || rfc3161TimestampAttribute != null;
    }

    static CMSSignedData removeTimestamp(CMSSignedData signature) {
        SignerInformation signerInformation = signature.getSignerInfos().iterator().next();
        AttributeTable unsignedAttributes = signerInformation.getUnsignedAttributes();
        if (unsignedAttributes == null) {
            return signature;
        }
        unsignedAttributes = unsignedAttributes.remove(CMSAttributes.counterSignature);
        unsignedAttributes = unsignedAttributes.remove(PKCSObjectIdentifiers.id_aa_signatureTimeStampToken);
        unsignedAttributes = unsignedAttributes.remove(AuthenticodeObjectIdentifiers.SPC_RFC3161_OBJID);
        signerInformation = SignerInformation.replaceUnsignedAttributes(signerInformation, unsignedAttributes);
        return CMSSignedData.replaceSigners(signature, new SignerInformationStore(signerInformation));
    }
}

