/*
 * Decompiled with CFR 0.152.
 */
package net.jsign.appx;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.security.DigestOutputStream;
import java.security.MessageDigest;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.jsign.ChannelUtils;
import net.jsign.DigestAlgorithm;
import net.jsign.Signable;
import net.jsign.SignatureUtils;
import net.jsign.asn1.authenticode.AuthenticodeObjectIdentifiers;
import net.jsign.asn1.authenticode.SpcAttributeTypeAndOptionalValue;
import net.jsign.asn1.authenticode.SpcIndirectDataContent;
import net.jsign.asn1.authenticode.SpcSipInfo;
import net.jsign.asn1.authenticode.SpcUuid;
import net.jsign.bouncycastle.asn1.ASN1Object;
import net.jsign.bouncycastle.asn1.DERNull;
import net.jsign.bouncycastle.asn1.x500.X500Name;
import net.jsign.bouncycastle.asn1.x509.AlgorithmIdentifier;
import net.jsign.bouncycastle.asn1.x509.DigestInfo;
import net.jsign.bouncycastle.cms.CMSSignedData;
import net.jsign.commons.io.output.NullOutputStream;
import net.jsign.commons.text.StringEscapeUtils;
import net.jsign.poi.util.IOUtils;
import net.jsign.zip.CentralDirectory;
import net.jsign.zip.ZipFile;

public class APPXFile
extends ZipFile
implements Signable {
    public APPXFile(File file) throws IOException {
        super(file);
        this.verifyPackage();
    }

    private void verifyPackage() throws IOException {
        if (this.centralDirectory.entries.get("[Content_Types].xml") == null) {
            throw new IOException("Invalid APPX/MSIX package, [Content_Types].xml is missing");
        }
    }

    @Override
    public byte[] computeDigest(DigestAlgorithm digestAlgorithm) throws IOException {
        this.addContentType("/AppxSignature.p7x", "application/vnd.ms-appx.signature");
        long endOfContentOffset = this.centralDirectory.centralDirectoryOffset;
        if (this.centralDirectory.entries.containsKey("AppxSignature.p7x")) {
            endOfContentOffset = this.centralDirectory.entries.get("AppxSignature.p7x").getLocalHeaderOffset();
        }
        MessageDigest axpc = digestAlgorithm.getMessageDigest();
        ChannelUtils.updateDigest(this.channel, axpc, 0L, endOfContentOffset);
        MessageDigest axcd = digestAlgorithm.getMessageDigest();
        axcd.update(this.getUnsignedCentralDirectory());
        MessageDigest axct = digestAlgorithm.getMessageDigest();
        IOUtils.copy(this.getInputStream("[Content_Types].xml"), new DigestOutputStream(NullOutputStream.INSTANCE, axct));
        MessageDigest axbm = digestAlgorithm.getMessageDigest();
        IOUtils.copy(this.getInputStream("AppxBlockMap.xml"), new DigestOutputStream(NullOutputStream.INSTANCE, axbm));
        MessageDigest axci = null;
        if (this.centralDirectory.entries.containsKey("AppxMetadata/CodeIntegrity.cat")) {
            axci = digestAlgorithm.getMessageDigest();
            IOUtils.copy(this.getInputStream("AppxMetadata/CodeIntegrity.cat"), new DigestOutputStream(NullOutputStream.INSTANCE, axci));
        }
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        out.write("APPX".getBytes());
        out.write("AXPC".getBytes());
        out.write(axpc.digest());
        out.write("AXCD".getBytes());
        out.write(axcd.digest());
        out.write("AXCT".getBytes());
        out.write(axct.digest());
        out.write("AXBM".getBytes());
        out.write(axbm.digest());
        if (axci != null) {
            out.write("AXCI".getBytes());
            out.write(axci.digest());
        }
        return out.toByteArray();
    }

    private byte[] getUnsignedCentralDirectory() throws IOException {
        CentralDirectory centralDirectory = new CentralDirectory();
        centralDirectory.read(this.channel);
        centralDirectory.removeEntry("AppxSignature.p7x");
        return centralDirectory.toBytes();
    }

    @Override
    public ASN1Object createIndirectData(DigestAlgorithm digestAlgorithm) throws IOException {
        AlgorithmIdentifier algorithmIdentifier = new AlgorithmIdentifier(digestAlgorithm.oid, DERNull.INSTANCE);
        DigestInfo digestInfo = new DigestInfo(algorithmIdentifier, this.computeDigest(digestAlgorithm));
        SpcUuid uuid = new SpcUuid(this.isBundle() ? "B3585F0F-DEAA-9A4B-A434-95742D92ECEB" : "4BDFC50A-07CE-E24D-B76E-23C839A09FD1");
        SpcAttributeTypeAndOptionalValue data = new SpcAttributeTypeAndOptionalValue(AuthenticodeObjectIdentifiers.SPC_SIPINFO_OBJID, new SpcSipInfo(0x1010000, uuid));
        return new SpcIndirectDataContent(data, digestInfo);
    }

    private String normalize(String name) {
        if (name != null) {
            name = name.replaceAll(",\\s*S\\s*=", ",ST=");
        }
        return name;
    }

    @Override
    public void validate(Certificate certificate) throws IOException, IllegalArgumentException {
        X500Name name = X500Name.getInstance(((X509Certificate)certificate).getSubjectX500Principal().getEncoded());
        String publisher = this.getPublisher();
        if (publisher == null || !name.equals(new X500Name(this.normalize(publisher)))) {
            throw new IllegalArgumentException("The app manifest publisher name (" + publisher + ") must match the subject name of the signing certificate (" + name + ")");
        }
    }

    boolean isBundle() {
        return this.centralDirectory.entries.containsKey("AppxMetadata/AppxBundleManifest.xml");
    }

    String getPublisher() throws IOException {
        InputStream in = this.getInputStream(this.isBundle() ? "AppxMetadata/AppxBundleManifest.xml" : "AppxManifest.xml", 0xA00000);
        String manifest = new String(IOUtils.toByteArray(in), StandardCharsets.UTF_8);
        Pattern pattern = Pattern.compile("Publisher\\s*=\\s*\"([^\"]+)", 2);
        Matcher matcher = pattern.matcher(manifest);
        return matcher.find() ? StringEscapeUtils.unescapeXml(matcher.group(1)) : null;
    }

    @Override
    public List<CMSSignedData> getSignatures() throws IOException {
        if (this.centralDirectory.entries.containsKey("AppxSignature.p7x")) {
            InputStream in = this.getInputStream("AppxSignature.p7x", 0x100000);
            in.skip(4L);
            return SignatureUtils.getSignatures(IOUtils.toByteArray(in));
        }
        return Collections.emptyList();
    }

    @Override
    public void setSignature(CMSSignedData signature) throws IOException {
        if (this.centralDirectory.entries.containsKey("AppxSignature.p7x")) {
            this.removeEntry("AppxSignature.p7x");
        }
        if (signature != null) {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            out.write("PKCX".getBytes());
            signature.toASN1Structure().encodeTo(out, "DER");
            this.addEntry("AppxSignature.p7x", out.toByteArray(), false);
        }
    }

    void addContentType(String partName, String contentType) throws IOException {
        String override;
        InputStream in = this.getInputStream("[Content_Types].xml", 0xA00000);
        String contentTypes = new String(IOUtils.toByteArray(in), StandardCharsets.UTF_8);
        if (!contentTypes.contains(override = "<Override PartName=\"" + partName + "\" ContentType=\"" + contentType + "\"/>")) {
            contentTypes = contentTypes.replace("</Types>", "<Override PartName=\"" + partName + "\" ContentType=\"" + contentType + "\"/></Types>");
            this.removeEntry("[Content_Types].xml");
            this.addEntry("[Content_Types].xml", contentTypes.getBytes(), true);
        }
    }

    @Override
    public void save() throws IOException {
    }
}

