/*
 * Decompiled with CFR 0.152.
 */
package net.jsign.asn1.authenticode;

import net.jsign.asn1.authenticode.AuthenticodeSignedData;
import net.jsign.bouncycastle.asn1.ASN1Encodable;
import net.jsign.bouncycastle.asn1.DERSet;
import net.jsign.bouncycastle.asn1.cms.CMSObjectIdentifiers;
import net.jsign.bouncycastle.asn1.cms.ContentInfo;
import net.jsign.bouncycastle.asn1.cms.SignerInfo;
import net.jsign.bouncycastle.cms.CMSException;
import net.jsign.bouncycastle.cms.CMSSignedData;
import net.jsign.bouncycastle.cms.CMSSignedDataGenerator;
import net.jsign.bouncycastle.cms.CMSTypedData;
import net.jsign.bouncycastle.cms.SignerInformation;

public class AuthenticodeSignedDataGenerator
extends CMSSignedDataGenerator {
    @Override
    public CMSSignedData generate(CMSTypedData content, boolean encapsulate) throws CMSException {
        this.digests.clear();
        SignerInfo signerInfo = this.getSignerInfo(content);
        ContentInfo encInfo = new ContentInfo(content.getContentType(), (ASN1Encodable)content.getContent());
        DERSet certificates = new DERSet(this.certs.toArray(new ASN1Encodable[0]));
        AuthenticodeSignedData signedData = new AuthenticodeSignedData(signerInfo.getDigestAlgorithm(), encInfo, certificates, signerInfo);
        ContentInfo contentInfo = new ContentInfo(CMSObjectIdentifiers.signedData, signedData);
        return new CMSSignedData(content, contentInfo);
    }

    private SignerInfo getSignerInfo(CMSTypedData content) throws CMSException {
        if (!this._signers.isEmpty()) {
            return ((SignerInformation)this._signers.get(0)).toASN1Structure();
        }
        CMSSignedData sigData = super.generate(content, true);
        return sigData.getSignerInfos().iterator().next().toASN1Structure();
    }
}

