/*
 * Decompiled with CFR 0.152.
 */
package net.jsign.bouncycastle.asn1.pkcs;

import java.math.BigInteger;
import java.util.Enumeration;
import net.jsign.bouncycastle.asn1.ASN1EncodableVector;
import net.jsign.bouncycastle.asn1.ASN1Integer;
import net.jsign.bouncycastle.asn1.ASN1Object;
import net.jsign.bouncycastle.asn1.ASN1Primitive;
import net.jsign.bouncycastle.asn1.ASN1Sequence;
import net.jsign.bouncycastle.asn1.DERSequence;

public class RSAPrivateKey
extends ASN1Object {
    private BigInteger version;
    private BigInteger modulus;
    private BigInteger publicExponent;
    private BigInteger privateExponent;
    private BigInteger prime1;
    private BigInteger prime2;
    private BigInteger exponent1;
    private BigInteger exponent2;
    private BigInteger coefficient;
    private ASN1Sequence otherPrimeInfos = null;

    public static RSAPrivateKey getInstance(Object object) {
        if (object instanceof RSAPrivateKey) {
            return (RSAPrivateKey)object;
        }
        if (object != null) {
            return new RSAPrivateKey(ASN1Sequence.getInstance(object));
        }
        return null;
    }

    public RSAPrivateKey(BigInteger bigInteger, BigInteger bigInteger2, BigInteger bigInteger3, BigInteger bigInteger4, BigInteger bigInteger5, BigInteger bigInteger6, BigInteger bigInteger7, BigInteger bigInteger8) {
        this.version = BigInteger.valueOf(0L);
        this.modulus = bigInteger;
        this.publicExponent = bigInteger2;
        this.privateExponent = bigInteger3;
        this.prime1 = bigInteger4;
        this.prime2 = bigInteger5;
        this.exponent1 = bigInteger6;
        this.exponent2 = bigInteger7;
        this.coefficient = bigInteger8;
    }

    private RSAPrivateKey(ASN1Sequence aSN1Sequence) {
        Enumeration enumeration = aSN1Sequence.getObjects();
        ASN1Integer aSN1Integer = (ASN1Integer)enumeration.nextElement();
        int n = aSN1Integer.intValueExact();
        if (n < 0 || n > 1) {
            throw new IllegalArgumentException("wrong version for RSA private key");
        }
        this.version = aSN1Integer.getValue();
        this.modulus = ((ASN1Integer)enumeration.nextElement()).getValue();
        this.publicExponent = ((ASN1Integer)enumeration.nextElement()).getValue();
        this.privateExponent = ((ASN1Integer)enumeration.nextElement()).getValue();
        this.prime1 = ((ASN1Integer)enumeration.nextElement()).getValue();
        this.prime2 = ((ASN1Integer)enumeration.nextElement()).getValue();
        this.exponent1 = ((ASN1Integer)enumeration.nextElement()).getValue();
        this.exponent2 = ((ASN1Integer)enumeration.nextElement()).getValue();
        this.coefficient = ((ASN1Integer)enumeration.nextElement()).getValue();
        if (enumeration.hasMoreElements()) {
            this.otherPrimeInfos = (ASN1Sequence)enumeration.nextElement();
        }
    }

    public BigInteger getModulus() {
        return this.modulus;
    }

    public BigInteger getPublicExponent() {
        return this.publicExponent;
    }

    public BigInteger getPrivateExponent() {
        return this.privateExponent;
    }

    public BigInteger getPrime1() {
        return this.prime1;
    }

    public BigInteger getPrime2() {
        return this.prime2;
    }

    public BigInteger getExponent1() {
        return this.exponent1;
    }

    public BigInteger getExponent2() {
        return this.exponent2;
    }

    public BigInteger getCoefficient() {
        return this.coefficient;
    }

    @Override
    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector(10);
        aSN1EncodableVector.add(new ASN1Integer(this.version));
        aSN1EncodableVector.add(new ASN1Integer(this.getModulus()));
        aSN1EncodableVector.add(new ASN1Integer(this.getPublicExponent()));
        aSN1EncodableVector.add(new ASN1Integer(this.getPrivateExponent()));
        aSN1EncodableVector.add(new ASN1Integer(this.getPrime1()));
        aSN1EncodableVector.add(new ASN1Integer(this.getPrime2()));
        aSN1EncodableVector.add(new ASN1Integer(this.getExponent1()));
        aSN1EncodableVector.add(new ASN1Integer(this.getExponent2()));
        aSN1EncodableVector.add(new ASN1Integer(this.getCoefficient()));
        if (this.otherPrimeInfos != null) {
            aSN1EncodableVector.add(this.otherPrimeInfos);
        }
        return new DERSequence(aSN1EncodableVector);
    }
}

