/*
 * Decompiled with CFR 0.152.
 */
package net.jsign.bouncycastle.asn1.x9;

import net.jsign.bouncycastle.asn1.ASN1Object;
import net.jsign.bouncycastle.asn1.ASN1OctetString;
import net.jsign.bouncycastle.asn1.ASN1Primitive;
import net.jsign.bouncycastle.asn1.DEROctetString;
import net.jsign.bouncycastle.math.ec.ECCurve;
import net.jsign.bouncycastle.math.ec.ECPoint;
import net.jsign.bouncycastle.util.Arrays;

public class X9ECPoint
extends ASN1Object {
    private final ASN1OctetString encoding;
    private ECCurve c;
    private ECPoint p;

    public X9ECPoint(ECPoint eCPoint, boolean bl) {
        this.p = eCPoint.normalize();
        this.encoding = new DEROctetString(eCPoint.getEncoded(bl));
    }

    public X9ECPoint(ECCurve eCCurve, byte[] byArray) {
        this.c = eCCurve;
        this.encoding = new DEROctetString(Arrays.clone(byArray));
    }

    public X9ECPoint(ECCurve eCCurve, ASN1OctetString aSN1OctetString) {
        this(eCCurve, aSN1OctetString.getOctets());
    }

    public synchronized ECPoint getPoint() {
        if (this.p == null) {
            this.p = this.c.decodePoint(this.encoding.getOctets()).normalize();
        }
        return this.p;
    }

    @Override
    public ASN1Primitive toASN1Primitive() {
        return this.encoding;
    }
}

