/*
 * Decompiled with CFR 0.152.
 */
package net.jsign.bouncycastle.cms;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import net.jsign.bouncycastle.asn1.ASN1Encodable;
import net.jsign.bouncycastle.asn1.ASN1EncodableVector;
import net.jsign.bouncycastle.asn1.ASN1ObjectIdentifier;
import net.jsign.bouncycastle.asn1.ASN1OctetString;
import net.jsign.bouncycastle.asn1.ASN1Sequence;
import net.jsign.bouncycastle.asn1.ASN1Set;
import net.jsign.bouncycastle.asn1.BERSequence;
import net.jsign.bouncycastle.asn1.DERNull;
import net.jsign.bouncycastle.asn1.DLSet;
import net.jsign.bouncycastle.asn1.cms.ContentInfo;
import net.jsign.bouncycastle.asn1.cms.SignedData;
import net.jsign.bouncycastle.asn1.cms.SignerInfo;
import net.jsign.bouncycastle.asn1.x509.AlgorithmIdentifier;
import net.jsign.bouncycastle.cert.X509CertificateHolder;
import net.jsign.bouncycastle.cms.CMSException;
import net.jsign.bouncycastle.cms.CMSProcessable;
import net.jsign.bouncycastle.cms.CMSProcessableByteArray;
import net.jsign.bouncycastle.cms.CMSSignedHelper;
import net.jsign.bouncycastle.cms.CMSTypedData;
import net.jsign.bouncycastle.cms.CMSUtils;
import net.jsign.bouncycastle.cms.PKCS7ProcessableObject;
import net.jsign.bouncycastle.cms.SignerInformation;
import net.jsign.bouncycastle.cms.SignerInformationStore;
import net.jsign.bouncycastle.cms.SignerInformationVerifier;
import net.jsign.bouncycastle.cms.SignerInformationVerifierProvider;
import net.jsign.bouncycastle.operator.DefaultDigestAlgorithmIdentifierFinder;
import net.jsign.bouncycastle.operator.DigestAlgorithmIdentifierFinder;
import net.jsign.bouncycastle.operator.OperatorCreationException;
import net.jsign.bouncycastle.util.Store;

public class CMSSignedData {
    private static final CMSSignedHelper HELPER = CMSSignedHelper.INSTANCE;
    private static final DefaultDigestAlgorithmIdentifierFinder DIGEST_ALG_ID_FINDER = new DefaultDigestAlgorithmIdentifierFinder();
    SignedData signedData;
    ContentInfo contentInfo;
    CMSTypedData signedContent;
    SignerInformationStore signerInfoStore;
    private Map hashes;

    private CMSSignedData(CMSSignedData cMSSignedData) {
        this.signedData = cMSSignedData.signedData;
        this.contentInfo = cMSSignedData.contentInfo;
        this.signedContent = cMSSignedData.signedContent;
        this.signerInfoStore = cMSSignedData.signerInfoStore;
    }

    public CMSSignedData(byte[] byArray) throws CMSException {
        this(CMSUtils.readContentInfo(byArray));
    }

    public CMSSignedData(InputStream inputStream) throws CMSException {
        this(CMSUtils.readContentInfo(inputStream));
    }

    public CMSSignedData(final CMSProcessable cMSProcessable, ContentInfo contentInfo) throws CMSException {
        this.signedContent = cMSProcessable instanceof CMSTypedData ? (CMSTypedData)cMSProcessable : new CMSTypedData(){

            @Override
            public ASN1ObjectIdentifier getContentType() {
                return CMSSignedData.this.signedData.getEncapContentInfo().getContentType();
            }

            @Override
            public void write(OutputStream outputStream) throws IOException, CMSException {
                cMSProcessable.write(outputStream);
            }

            @Override
            public Object getContent() {
                return cMSProcessable.getContent();
            }
        };
        this.contentInfo = contentInfo;
        this.signedData = this.getSignedData();
    }

    public CMSSignedData(ContentInfo contentInfo) throws CMSException {
        this.contentInfo = contentInfo;
        this.signedData = this.getSignedData();
        ASN1Encodable aSN1Encodable = this.signedData.getEncapContentInfo().getContent();
        this.signedContent = aSN1Encodable != null ? (aSN1Encodable instanceof ASN1OctetString ? new CMSProcessableByteArray(this.signedData.getEncapContentInfo().getContentType(), ((ASN1OctetString)aSN1Encodable).getOctets()) : new PKCS7ProcessableObject(this.signedData.getEncapContentInfo().getContentType(), aSN1Encodable)) : null;
    }

    private SignedData getSignedData() throws CMSException {
        try {
            return SignedData.getInstance(this.contentInfo.getContent());
        }
        catch (ClassCastException classCastException) {
            throw new CMSException("Malformed content.", classCastException);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new CMSException("Malformed content.", illegalArgumentException);
        }
    }

    public SignerInformationStore getSignerInfos() {
        if (this.signerInfoStore == null) {
            ASN1Set aSN1Set = this.signedData.getSignerInfos();
            ArrayList<SignerInformation> arrayList = new ArrayList<SignerInformation>();
            for (int i = 0; i != aSN1Set.size(); ++i) {
                SignerInfo signerInfo = SignerInfo.getInstance(aSN1Set.getObjectAt(i));
                ASN1ObjectIdentifier aSN1ObjectIdentifier = this.signedData.getEncapContentInfo().getContentType();
                if (this.hashes == null) {
                    arrayList.add(new SignerInformation(signerInfo, aSN1ObjectIdentifier, this.signedContent, null));
                    continue;
                }
                Object k = this.hashes.keySet().iterator().next();
                byte[] byArray = k instanceof String ? (byte[])this.hashes.get(signerInfo.getDigestAlgorithm().getAlgorithm().getId()) : (byte[])this.hashes.get(signerInfo.getDigestAlgorithm().getAlgorithm());
                arrayList.add(new SignerInformation(signerInfo, aSN1ObjectIdentifier, null, byArray));
            }
            this.signerInfoStore = new SignerInformationStore(arrayList);
        }
        return this.signerInfoStore;
    }

    public Store<X509CertificateHolder> getCertificates() {
        return HELPER.getCertificates(this.signedData.getCertificates());
    }

    public Set<AlgorithmIdentifier> getDigestAlgorithmIDs() {
        HashSet<AlgorithmIdentifier> hashSet = new HashSet<AlgorithmIdentifier>();
        Enumeration enumeration = this.signedData.getDigestAlgorithms().getObjects();
        while (enumeration.hasMoreElements()) {
            hashSet.add(AlgorithmIdentifier.getInstance(enumeration.nextElement()));
        }
        return Collections.unmodifiableSet(hashSet);
    }

    public String getSignedContentTypeOID() {
        return this.signedData.getEncapContentInfo().getContentType().getId();
    }

    public CMSTypedData getSignedContent() {
        return this.signedContent;
    }

    public ContentInfo toASN1Structure() {
        return this.contentInfo;
    }

    public byte[] getEncoded(String string) throws IOException {
        return this.contentInfo.getEncoded(string);
    }

    public boolean verifySignatures(SignerInformationVerifierProvider signerInformationVerifierProvider, boolean bl) throws CMSException {
        Collection<SignerInformation> collection = this.getSignerInfos().getSigners();
        for (SignerInformation signerInformation : collection) {
            try {
                SignerInformationVerifier signerInformationVerifier = signerInformationVerifierProvider.get(signerInformation.getSID());
                if (!signerInformation.verify(signerInformationVerifier)) {
                    return false;
                }
                if (bl) continue;
                Collection<SignerInformation> collection2 = signerInformation.getCounterSignatures().getSigners();
                Iterator<SignerInformation> iterator = collection2.iterator();
                while (iterator.hasNext()) {
                    if (this.verifyCounterSignature(iterator.next(), signerInformationVerifierProvider)) continue;
                    return false;
                }
            }
            catch (OperatorCreationException operatorCreationException) {
                throw new CMSException("failure in verifier provider: " + operatorCreationException.getMessage(), operatorCreationException);
            }
        }
        return true;
    }

    private boolean verifyCounterSignature(SignerInformation signerInformation, SignerInformationVerifierProvider signerInformationVerifierProvider) throws OperatorCreationException, CMSException {
        SignerInformationVerifier signerInformationVerifier = signerInformationVerifierProvider.get(signerInformation.getSID());
        if (!signerInformation.verify(signerInformationVerifier)) {
            return false;
        }
        Collection<SignerInformation> collection = signerInformation.getCounterSignatures().getSigners();
        Iterator<SignerInformation> iterator = collection.iterator();
        while (iterator.hasNext()) {
            if (this.verifyCounterSignature(iterator.next(), signerInformationVerifierProvider)) continue;
            return false;
        }
        return true;
    }

    public static CMSSignedData replaceSigners(CMSSignedData cMSSignedData, SignerInformationStore signerInformationStore) {
        return CMSSignedData.replaceSigners(cMSSignedData, signerInformationStore, DIGEST_ALG_ID_FINDER);
    }

    public static CMSSignedData replaceSigners(CMSSignedData cMSSignedData, SignerInformationStore signerInformationStore, DigestAlgorithmIdentifierFinder digestAlgorithmIdentifierFinder) {
        CMSSignedData cMSSignedData2 = new CMSSignedData(cMSSignedData);
        cMSSignedData2.signerInfoStore = signerInformationStore;
        HashSet<AlgorithmIdentifier> hashSet = new HashSet<AlgorithmIdentifier>();
        Collection<SignerInformation> collection = signerInformationStore.getSigners();
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector(collection.size());
        for (SignerInformation object2 : collection) {
            CMSUtils.addDigestAlgs(hashSet, object2, digestAlgorithmIdentifierFinder);
            aSN1EncodableVector.add(object2.toASN1Structure());
        }
        Set<AlgorithmIdentifier> set = cMSSignedData.getDigestAlgorithmIDs();
        AlgorithmIdentifier[] algorithmIdentifierArray = set.toArray(new AlgorithmIdentifier[set.size()]);
        ASN1Encodable[] aSN1EncodableArray = hashSet.toArray(new AlgorithmIdentifier[hashSet.size()]);
        CMSSignedData.compareAndReplaceAlgIds(algorithmIdentifierArray, (AlgorithmIdentifier[])aSN1EncodableArray);
        DLSet dLSet = new DLSet(aSN1EncodableArray);
        DLSet dLSet2 = new DLSet(aSN1EncodableVector);
        ASN1Sequence aSN1Sequence = (ASN1Sequence)cMSSignedData.signedData.toASN1Primitive();
        aSN1EncodableVector = new ASN1EncodableVector(aSN1Sequence.size());
        aSN1EncodableVector.add(aSN1Sequence.getObjectAt(0));
        aSN1EncodableVector.add(dLSet);
        for (int i = 2; i != aSN1Sequence.size() - 1; ++i) {
            aSN1EncodableVector.add(aSN1Sequence.getObjectAt(i));
        }
        aSN1EncodableVector.add(dLSet2);
        cMSSignedData2.signedData = SignedData.getInstance(new BERSequence(aSN1EncodableVector));
        cMSSignedData2.contentInfo = new ContentInfo(cMSSignedData2.contentInfo.getContentType(), cMSSignedData2.signedData);
        return cMSSignedData2;
    }

    private static void compareAndReplaceAlgIds(AlgorithmIdentifier[] algorithmIdentifierArray, AlgorithmIdentifier[] algorithmIdentifierArray2) {
        block0: for (int i = 0; i != algorithmIdentifierArray2.length; ++i) {
            AlgorithmIdentifier algorithmIdentifier = algorithmIdentifierArray2[i];
            for (int j = 0; j != algorithmIdentifierArray.length; ++j) {
                AlgorithmIdentifier algorithmIdentifier2 = algorithmIdentifierArray[j];
                if (!algorithmIdentifier.getAlgorithm().equals(algorithmIdentifier2.getAlgorithm()) || algorithmIdentifier.getParameters() != null && !DERNull.INSTANCE.equals(algorithmIdentifier.getParameters())) continue;
                algorithmIdentifierArray2[i] = algorithmIdentifier2;
                continue block0;
            }
        }
    }

    public static CMSSignedData replaceCertificatesAndCRLs(CMSSignedData cMSSignedData, Store store, Store store2, Store store3) throws CMSException {
        Iterable iterable;
        CMSSignedData cMSSignedData2 = new CMSSignedData(cMSSignedData);
        ASN1Set aSN1Set = null;
        Iterable iterable2 = null;
        if (store != null || store2 != null) {
            ASN1Set aSN1Set2;
            iterable = new ArrayList();
            if (store != null) {
                iterable.addAll(CMSUtils.getCertificatesFromStore(store));
            }
            if (store2 != null) {
                iterable.addAll(CMSUtils.getAttributeCertificatesFromStore(store2));
            }
            if ((aSN1Set2 = CMSUtils.createBerSetFromList(iterable)).size() != 0) {
                aSN1Set = aSN1Set2;
            }
        }
        if (store3 != null && ((ASN1Set)(iterable = CMSUtils.createBerSetFromList(CMSUtils.getCRLsFromStore(store3)))).size() != 0) {
            iterable2 = iterable;
        }
        cMSSignedData2.signedData = new SignedData(cMSSignedData.signedData.getDigestAlgorithms(), cMSSignedData.signedData.getEncapContentInfo(), aSN1Set, (ASN1Set)iterable2, cMSSignedData.signedData.getSignerInfos());
        cMSSignedData2.contentInfo = new ContentInfo(cMSSignedData2.contentInfo.getContentType(), cMSSignedData2.signedData);
        return cMSSignedData2;
    }
}

