/*
 * Decompiled with CFR 0.152.
 */
package net.jsign.bouncycastle.crypto;

import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteOrder;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.jar.JarException;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.jsign.bouncycastle.crypto.DefaultNativeServices;
import net.jsign.bouncycastle.crypto.NativeLibIdentity;
import net.jsign.bouncycastle.crypto.NativeServices;
import net.jsign.bouncycastle.crypto.VariantSelector;
import net.jsign.bouncycastle.crypto.digests.SHA256Digest;
import net.jsign.bouncycastle.util.Arrays;
import net.jsign.bouncycastle.util.Properties;
import net.jsign.bouncycastle.util.Strings;
import net.jsign.bouncycastle.util.encoders.Hex;
import net.jsign.bouncycastle.util.io.Streams;

class NativeLoader {
    private static final Logger LOG = Logger.getLogger(NativeLoader.class.getName());
    private static boolean nativeLibsAvailableForSystem = false;
    private static boolean nativeInstalled = false;
    private static boolean nativeEnabled = true;
    private static String nativeStatusMessage = "Driver load not attempted";
    private static String selectedVariant = null;
    private static boolean javaSupportOnly = true;
    private static final NativeServices nativeServices = new DefaultNativeServices();

    NativeLoader() {
    }

    static synchronized boolean isJavaSupportOnly() {
        return javaSupportOnly;
    }

    static synchronized boolean isNativeInstalled() {
        return nativeInstalled;
    }

    static synchronized boolean isNativeAvailable() {
        return nativeLibsAvailableForSystem && nativeInstalled && nativeEnabled;
    }

    static String getFile(String string) {
        String string2;
        try {
            InputStream inputStream = NativeLoader.class.getResourceAsStream(string);
            string2 = Strings.fromByteArray(Streams.readAll(inputStream));
            inputStream.close();
        }
        catch (Exception exception) {
            return null;
        }
        return string2;
    }

    static List<String> loadVariantsDeps(String string, String string2) {
        String string3 = NativeLoader.getFile(string);
        if (string3 == null) {
            return Collections.emptyList();
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        for (String string4 : string3.split("\n")) {
            String[] stringArray = (string4 = string4.trim()).split(":");
            if (!stringArray[0].trim().equals(string2)) continue;
            arrayList.add(stringArray[1].trim());
        }
        return Collections.unmodifiableList(arrayList);
    }

    static File installLib(String string, String string2, String string3, File file, Set<File> set) throws Exception {
        String string4 = System.mapLibraryName(string);
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("attempting to install: " + string4);
        }
        List<String> list = NativeLoader.loadVariantsDeps(string3 + "/deps.list", string4);
        for (String string5 : list) {
            set.remove(NativeLoader.copyFromJar(string3 + "/" + string5, file, string5));
        }
        File file2 = NativeLoader.copyFromJar(string2 + "/" + string4, file, string4);
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("installed " + file2);
        }
        set.remove(file2);
        return file2;
    }

    static boolean isLE() {
        return ByteOrder.nativeOrder().equals(ByteOrder.LITTLE_ENDIAN);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static synchronized void loadDriver() {
        Object object;
        String string;
        File file;
        LOG.log(Level.FINE, "native loader start");
        String string2 = Properties.getPropertyValue("net.jsign.bouncycastle.native.cpu_variant");
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("forced variant is: " + (string2 != null ? string2 : " not defined"));
        }
        if ("java".equals(string2)) {
            javaSupportOnly = true;
            nativeInstalled = false;
            nativeStatusMessage = "java support only";
            LOG.fine("exited with " + nativeStatusMessage);
            return;
        }
        if (LOG.isLoggable(Level.FINE)) {
            LOG.log(Level.FINE, "examining properties to determine platform and architecture");
        }
        String string3 = Strings.toLowerCase(Properties.getPropertyValue("os.arch", ""));
        String string4 = Strings.toLowerCase(Properties.getPropertyValue("os.name", ""));
        String string5 = null;
        String string6 = null;
        boolean bl = false;
        if (LOG.isLoggable(Level.FINE)) {
            LOG.log(Level.FINE, "host ARCH: " + string3);
            LOG.log(Level.FINE, "host OS: " + string4);
        }
        if (string4.contains("linux")) {
            string5 = "linux";
        } else if (string4.contains("mac") || string4.contains("darwin")) {
            string5 = "darwin";
        }
        if (string5 == null) {
            nativeStatusMessage = "OS '" + string4 + "' is not supported.";
            LOG.fine("exited with " + nativeStatusMessage);
            return;
        }
        if (string3.contains("x86") || string3.contains("amd") && string3.contains("64")) {
            string6 = "x86_64";
        } else if (string3.contains("aarch64")) {
            string6 = "arm64";
            bl = true;
        }
        if (string6 == null) {
            nativeStatusMessage = "architecture '" + string3 + "' is not supported";
            LOG.fine("exited with " + nativeStatusMessage);
            return;
        }
        if (LOG.isLoggable(Level.FINE)) {
            LOG.log(Level.FINE, "derived native platform: " + string5);
            LOG.log(Level.FINE, "derived native architecture: " + string6);
        }
        if (LOG.isLoggable(Level.FINE)) {
            LOG.log(Level.FINE, "begin determining path to install native libraries");
        }
        if ((file = AccessController.doPrivileged(new PrivilegedAction<File>(){

            @Override
            public File run() {
                File file = new File(Properties.getPropertyValue("java.io.tmpdir"));
                if (!file.exists()) {
                    nativeInstalled = false;
                    nativeStatusMessage = file + " did not exist";
                    LOG.fine("exited with " + nativeStatusMessage);
                    return null;
                }
                try {
                    File file2 = null;
                    long l = System.nanoTime();
                    for (int i = 0; i < 1000 && !(file2 = new File(file, "bc-lts-jni" + Long.toString(l + (long)i, 32) + "-libs")).mkdirs(); ++i) {
                        file2 = null;
                        Thread.sleep(l % 97L);
                    }
                    if (file2 == null) {
                        nativeInstalled = false;
                        nativeStatusMessage = "unable to create directory in " + file + " after 1000 unique attempts";
                        LOG.fine("exited with " + nativeStatusMessage);
                        return null;
                    }
                    if (!file2.exists()) {
                        nativeInstalled = false;
                        nativeStatusMessage = "unable to create temp directory for jni libs: " + file2;
                        LOG.fine("exited with " + nativeStatusMessage);
                        return null;
                    }
                    final File file3 = file2;
                    Runtime.getRuntime().addShutdownHook(new Thread(new Runnable(){

                        @Override
                        public void run() {
                            if (LOG.isLoggable(Level.FINE)) {
                                LOG.fine("cleanup shutdown hook started");
                            }
                            if (!file3.exists()) {
                                return;
                            }
                            boolean bl = true;
                            if (file3.isDirectory()) {
                                for (File file : file3.listFiles()) {
                                    bl &= file.delete();
                                }
                            }
                            if (!(bl &= file3.delete())) {
                                LOG.fine(" failed to delete: " + file3.getAbsolutePath());
                            } else {
                                LOG.fine("successfully cleaned up: " + file3.getAbsolutePath());
                            }
                        }
                    }));
                    return file3;
                }
                catch (Exception exception) {
                    nativeInstalled = false;
                    nativeStatusMessage = "failed because it was not able to create a temporary file in 'java.io.tmpdir' " + exception.getMessage();
                    LOG.fine("exited with " + nativeStatusMessage);
                    return null;
                }
            }
        })) == null) {
            return;
        }
        if (LOG.isLoggable(Level.FINE)) {
            LOG.log(Level.FINE, "native library install location: " + file.getAbsolutePath());
        }
        HashSet<File> hashSet = new HashSet<File>();
        for (File file2 : file.listFiles()) {
            hashSet.add(file2);
        }
        if (LOG.isLoggable(Level.FINE) && !hashSet.isEmpty()) {
            for (File file3 : hashSet) {
                LOG.log(Level.FINE, "found in install location: " + file3.getAbsolutePath());
            }
        }
        String string7 = String.format("/native/%s/%s", string5, string6);
        if (LOG.isLoggable(Level.FINE)) {
            LOG.log(Level.FINE, "library path within LTS jar: " + (String)string7);
        }
        String string8 = String.format("/native/%s/%s/probe", string5, string6);
        if (LOG.isLoggable(Level.FINE)) {
            LOG.log(Level.FINE, "begin install probe library from: " + string8);
        }
        if (bl) {
            if (!NativeLoader.isLE()) {
                nativeStatusMessage = String.format("ARM big-endian is not supported", string5, string6);
                nativeInstalled = false;
                LOG.fine("exited with " + nativeStatusMessage);
                return;
            }
            string = "bc-probe-le";
        } else {
            string = "bc-probe";
        }
        InputStream inputStream = NativeLoader.class.getResourceAsStream(string8 + "/" + System.mapLibraryName(string));
        if (inputStream == null) {
            nativeStatusMessage = String.format("platform '%s' and architecture '%s' are not supported", string5, string6);
            nativeInstalled = false;
            LOG.fine("exited with " + nativeStatusMessage);
            return;
        }
        try {
            inputStream.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        try {
            object = NativeLoader.installLib(string, string8, string7, file, hashSet);
            AccessController.doPrivileged(new PrivilegedAction<Object>((File)object){
                final /* synthetic */ File val$lib;
                {
                    this.val$lib = file;
                }

                @Override
                public Object run() {
                    System.load(this.val$lib.getAbsolutePath());
                    return new Object();
                }
            });
        }
        catch (Exception exception) {
            nativeStatusMessage = "probe lib failed to load " + exception.getMessage();
            nativeInstalled = false;
            LOG.fine("exited with " + nativeStatusMessage);
            return;
        }
        try {
            selectedVariant = VariantSelector.getBestVariantName();
        }
        catch (Throwable throwable) {
            nativeStatusMessage = "probe lib failed return a variant " + throwable.getMessage();
            nativeInstalled = false;
            LOG.fine("exited with " + nativeStatusMessage);
            return;
        }
        if ("none".equals(selectedVariant)) {
            javaSupportOnly = true;
            nativeInstalled = false;
            nativeStatusMessage = "probe returned no suitable CPU features, java support only";
            LOG.fine("exited with " + nativeStatusMessage);
            return;
        }
        if (string2 != null) {
            selectedVariant = string2;
        }
        object = String.format("/native/%s/%s/%s", string5, string6, selectedVariant);
        try {
            final File file4 = NativeLoader.installLib("bc-lts-" + selectedVariant, (String)object, string7, file, hashSet);
            if (!hashSet.isEmpty()) {
                StringBuilder stringBuilder = new StringBuilder();
                Iterator iterator = hashSet.iterator();
                while (true) {
                    if (!iterator.hasNext()) {
                        nativeStatusMessage = String.format("unexpected files in %s: %s", file.toString(), stringBuilder.toString());
                        nativeInstalled = false;
                        LOG.fine("exited with " + nativeStatusMessage);
                        return;
                    }
                    File file5 = (File)iterator.next();
                    if (stringBuilder.length() != 0) {
                        stringBuilder.append(",");
                    }
                    stringBuilder.append(file5.getName());
                }
            }
            AccessController.doPrivileged(new PrivilegedAction<Object>(){

                @Override
                public Object run() {
                    System.load(file4.getAbsolutePath());
                    return new Object();
                }
            });
        }
        catch (Exception exception) {
            nativeStatusMessage = "native capabilities lib failed to load " + exception.getMessage();
            nativeInstalled = false;
            LOG.fine("exited with " + nativeStatusMessage);
            return;
        }
        if (!selectedVariant.equals(NativeLibIdentity.getLibraryIdent())) {
            nativeStatusMessage = String.format("loaded native library variant is %s but the requested library variant is %s", NativeLibIdentity.getLibraryIdent(), selectedVariant);
            nativeInstalled = false;
            LOG.fine("exited with " + nativeStatusMessage);
            return;
        }
        nativeLibsAvailableForSystem = true;
        nativeStatusMessage = "successfully loaded";
        nativeInstalled = true;
        javaSupportOnly = false;
        if (LOG.isLoggable(Level.FINE)) {
            LOG.log(Level.FINE, nativeStatusMessage);
            LOG.fine("native loader has finished");
        }
    }

    public static boolean isNativeLibsAvailableForSystem() {
        return nativeLibsAvailableForSystem;
    }

    private static byte[] takeSHA256Digest(InputStream inputStream) {
        try {
            int n;
            byte[] byArray = new byte[65535];
            SHA256Digest sHA256Digest = new SHA256Digest();
            while ((n = inputStream.read(byArray)) >= 0) {
                sHA256Digest.update(byArray, 0, n);
            }
            byte[] byArray2 = new byte[sHA256Digest.getDigestSize()];
            sHA256Digest.doFinal(byArray2, 0);
            return byArray2;
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException.getMessage(), iOException);
        }
    }

    private static File copyFromJar(String string, File file, String string2) throws Exception {
        Closeable closeable;
        InputStream inputStream = NativeLoader.class.getResourceAsStream(string);
        if (inputStream == null) {
            throw new JarException(string + " lib not found in jar");
        }
        File file2 = new File(file, string2);
        if (file2.exists()) {
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("installation target exists: " + file2.getAbsolutePath());
            }
            closeable = new FileInputStream(file2);
            byte[] byArray = NativeLoader.takeSHA256Digest((InputStream)closeable);
            ((FileInputStream)closeable).close();
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("existing file digest: " + Hex.toHexString(byArray));
            }
            byte[] byArray2 = NativeLoader.takeSHA256Digest(inputStream);
            inputStream.close();
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("new file digest: " + Hex.toHexString(byArray2));
            }
            if (Arrays.constantTimeAreEqual(byArray, byArray2)) {
                if (LOG.isLoggable(Level.FINE)) {
                    LOG.fine("existing file already exists and is the same");
                }
                return file2;
            }
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("existing file is different and will be replaced");
            }
            inputStream = NativeLoader.class.getResourceAsStream(string);
        }
        closeable = new FileOutputStream(file2);
        Streams.pipeAll(inputStream, (OutputStream)closeable);
        ((OutputStream)closeable).flush();
        ((FileOutputStream)closeable).close();
        inputStream.close();
        return file2;
    }
}

