/*
 * Decompiled with CFR 0.152.
 */
package net.jsign.bouncycastle.crypto;

import net.jsign.bouncycastle.crypto.DataLengthException;
import net.jsign.bouncycastle.crypto.InvalidCipherTextException;
import net.jsign.bouncycastle.crypto.OutputLengthException;

public class PacketCipherException
extends Exception {
    private final Reason reason;

    public static PacketCipherException from(Throwable throwable) {
        if (throwable instanceof PacketCipherException) {
            return (PacketCipherException)throwable;
        }
        if (throwable instanceof InvalidCipherTextException) {
            return new PacketCipherException(Reason.INVALID_CIPHERTEXT, throwable.getMessage(), throwable);
        }
        if (throwable instanceof OutputLengthException) {
            return new PacketCipherException(Reason.OUTPUT_LENGTH, throwable.getMessage(), throwable);
        }
        if (throwable instanceof DataLengthException) {
            return new PacketCipherException(Reason.DATA_LENGTH, throwable.getMessage(), throwable);
        }
        return new PacketCipherException(Reason.OTHER, throwable.getMessage(), throwable);
    }

    private PacketCipherException(Reason reason, String string, Throwable throwable) {
        super(string, throwable);
        this.reason = reason;
    }

    public void throwCauseAsRuntimeException() {
        Throwable throwable = this.getCause();
        if (throwable instanceof RuntimeException) {
            throw (RuntimeException)throwable;
        }
        throw new RuntimeException(throwable.getMessage(), throwable);
    }

    @Override
    public String toString() {
        return this.reason.toString() + " " + super.toString();
    }

    public Reason getReason() {
        return this.reason;
    }

    public static enum Reason {
        INVALID_CIPHERTEXT,
        OUTPUT_LENGTH,
        DATA_LENGTH,
        OTHER;

    }
}

