/*
 * Decompiled with CFR 0.152.
 */
package net.jsign.bouncycastle.crypto;

import net.jsign.bouncycastle.crypto.CharToByteConverter;
import net.jsign.bouncycastle.crypto.PBEParametersGenerator;

public enum PasswordConverter implements CharToByteConverter
{
    ASCII{

        public String getType() {
            return "ASCII";
        }

        @Override
        public byte[] convert(char[] cArray) {
            return PBEParametersGenerator.PKCS5PasswordToBytes(cArray);
        }
    }
    ,
    UTF8{

        public String getType() {
            return "UTF8";
        }

        @Override
        public byte[] convert(char[] cArray) {
            return PBEParametersGenerator.PKCS5PasswordToUTF8Bytes(cArray);
        }
    }
    ,
    PKCS12{

        public String getType() {
            return "PKCS12";
        }

        @Override
        public byte[] convert(char[] cArray) {
            return PBEParametersGenerator.PKCS12PasswordToBytes(cArray);
        }
    };

}

