/*
 * Decompiled with CFR 0.152.
 */
package net.jsign.bouncycastle.crypto.digests;

import net.jsign.bouncycastle.crypto.CryptoServiceProperties;
import net.jsign.bouncycastle.crypto.CryptoServicePurpose;
import net.jsign.bouncycastle.crypto.CryptoServicesRegistrar;
import net.jsign.bouncycastle.crypto.SavableDigest;
import net.jsign.bouncycastle.crypto.digests.Utils;
import net.jsign.bouncycastle.util.Memoable;
import net.jsign.bouncycastle.util.dispose.NativeDisposer;
import net.jsign.bouncycastle.util.dispose.NativeReference;

class SHA224NativeDigest
implements SavableDigest {
    private final CryptoServicePurpose purpose;
    protected DigestRefWrapper nativeRef = null;

    SHA224NativeDigest(CryptoServicePurpose cryptoServicePurpose) {
        this.purpose = cryptoServicePurpose;
        this.nativeRef = new DigestRefWrapper(SHA224NativeDigest.makeNative());
        this.reset();
        CryptoServicesRegistrar.checkConstraints(this.cryptoServiceProperties());
    }

    SHA224NativeDigest() {
        this(CryptoServicePurpose.ANY);
    }

    SHA224NativeDigest(SHA224NativeDigest sHA224NativeDigest) {
        this(CryptoServicePurpose.ANY);
        byte[] byArray = sHA224NativeDigest.getEncodedState();
        SHA224NativeDigest.restoreFullState(this.nativeRef.getReference(), byArray, 0);
    }

    @Override
    public String getAlgorithmName() {
        return "SHA-224";
    }

    @Override
    public int getDigestSize() {
        return SHA224NativeDigest.getDigestSize(this.nativeRef.getReference());
    }

    @Override
    public void update(byte by) {
        SHA224NativeDigest.update(this.nativeRef.getReference(), by);
    }

    @Override
    public void update(byte[] byArray, int n, int n2) {
        SHA224NativeDigest.update(this.nativeRef.getReference(), byArray, n, n2);
    }

    @Override
    public int doFinal(byte[] byArray, int n) {
        return SHA224NativeDigest.doFinal(this.nativeRef.getReference(), byArray, n);
    }

    @Override
    public void reset() {
        SHA224NativeDigest.reset(this.nativeRef.getReference());
    }

    @Override
    public int getByteLength() {
        return SHA224NativeDigest.getByteLength(this.nativeRef.getReference());
    }

    @Override
    public Memoable copy() {
        return new SHA224NativeDigest(this);
    }

    @Override
    public void reset(Memoable memoable) {
        SHA224NativeDigest sHA224NativeDigest = (SHA224NativeDigest)memoable;
        SHA224NativeDigest.restoreFullState(this.nativeRef.getReference(), sHA224NativeDigest.getEncodedState(), 0);
    }

    public byte[] getEncodedState() {
        int n = SHA224NativeDigest.encodeFullState(this.nativeRef.getReference(), null, 0);
        byte[] byArray = new byte[n];
        SHA224NativeDigest.encodeFullState(this.nativeRef.getReference(), byArray, 0);
        return byArray;
    }

    public String toString() {
        return "SHA224[Native]()";
    }

    static native long makeNative();

    static native void destroy(long var0);

    static native int getDigestSize(long var0);

    static native void update(long var0, byte var2);

    static native void update(long var0, byte[] var2, int var3, int var4);

    static native int doFinal(long var0, byte[] var2, int var3);

    static native void reset(long var0);

    static native int getByteLength(long var0);

    static native int encodeFullState(long var0, byte[] var2, int var3);

    static native void restoreFullState(long var0, byte[] var2, int var3);

    protected CryptoServiceProperties cryptoServiceProperties() {
        return Utils.getDefaultProperties(this, 224, this.purpose);
    }

    private static class DigestRefWrapper
    extends NativeReference {
        public DigestRefWrapper(long l) {
            super(l, "SHA224");
        }

        @Override
        public Runnable createAction() {
            return new Disposer(this.reference);
        }
    }

    private static class Disposer
    extends NativeDisposer {
        Disposer(long l) {
            super(l);
        }

        @Override
        protected void dispose(long l) {
            SHA224NativeDigest.destroy(l);
        }
    }
}

