/*
 * Decompiled with CFR 0.152.
 */
package net.jsign.bouncycastle.crypto.digests;

import net.jsign.bouncycastle.crypto.CryptoServiceProperties;
import net.jsign.bouncycastle.crypto.CryptoServicePurpose;
import net.jsign.bouncycastle.crypto.CryptoServicesRegistrar;
import net.jsign.bouncycastle.crypto.SavableDigest;
import net.jsign.bouncycastle.crypto.digests.Utils;
import net.jsign.bouncycastle.util.Memoable;
import net.jsign.bouncycastle.util.dispose.NativeDisposer;
import net.jsign.bouncycastle.util.dispose.NativeReference;

class SHA256NativeDigest
implements SavableDigest {
    private final CryptoServicePurpose purpose;
    protected DigestRefWrapper nativeRef = null;

    SHA256NativeDigest(CryptoServicePurpose cryptoServicePurpose) {
        this.purpose = cryptoServicePurpose;
        this.nativeRef = new DigestRefWrapper(SHA256NativeDigest.makeNative());
        this.reset();
        CryptoServicesRegistrar.checkConstraints(this.cryptoServiceProperties());
    }

    SHA256NativeDigest() {
        this(CryptoServicePurpose.ANY);
    }

    SHA256NativeDigest(SHA256NativeDigest sHA256NativeDigest) {
        this(CryptoServicePurpose.ANY);
        byte[] byArray = sHA256NativeDigest.getEncodedState();
        SHA256NativeDigest.restoreFullState(this.nativeRef.getReference(), byArray, 0);
    }

    @Override
    public String getAlgorithmName() {
        return "SHA-256";
    }

    @Override
    public int getDigestSize() {
        return SHA256NativeDigest.getDigestSize(this.nativeRef.getReference());
    }

    @Override
    public void update(byte by) {
        SHA256NativeDigest.update(this.nativeRef.getReference(), by);
    }

    @Override
    public void update(byte[] byArray, int n, int n2) {
        SHA256NativeDigest.update(this.nativeRef.getReference(), byArray, n, n2);
    }

    @Override
    public int doFinal(byte[] byArray, int n) {
        return SHA256NativeDigest.doFinal(this.nativeRef.getReference(), byArray, n);
    }

    @Override
    public void reset() {
        SHA256NativeDigest.reset(this.nativeRef.getReference());
    }

    @Override
    public int getByteLength() {
        return SHA256NativeDigest.getByteLength(this.nativeRef.getReference());
    }

    @Override
    public Memoable copy() {
        return new SHA256NativeDigest(this);
    }

    @Override
    public void reset(Memoable memoable) {
        SHA256NativeDigest sHA256NativeDigest = (SHA256NativeDigest)memoable;
        SHA256NativeDigest.restoreFullState(this.nativeRef.getReference(), sHA256NativeDigest.getEncodedState(), 0);
    }

    public byte[] getEncodedState() {
        int n = SHA256NativeDigest.encodeFullState(this.nativeRef.getReference(), null, 0);
        byte[] byArray = new byte[n];
        SHA256NativeDigest.encodeFullState(this.nativeRef.getReference(), byArray, 0);
        return byArray;
    }

    public String toString() {
        return "SHA256[Native]()";
    }

    static native long makeNative();

    static native void destroy(long var0);

    static native int getDigestSize(long var0);

    static native void update(long var0, byte var2);

    static native void update(long var0, byte[] var2, int var3, int var4);

    static native int doFinal(long var0, byte[] var2, int var3);

    static native void reset(long var0);

    static native int getByteLength(long var0);

    static native int encodeFullState(long var0, byte[] var2, int var3);

    static native void restoreFullState(long var0, byte[] var2, int var3);

    protected CryptoServiceProperties cryptoServiceProperties() {
        return Utils.getDefaultProperties(this, 256, this.purpose);
    }

    private static class DigestRefWrapper
    extends NativeReference {
        public DigestRefWrapper(long l) {
            super(l, "SHA256");
        }

        @Override
        public Runnable createAction() {
            return new Disposer(this.reference);
        }
    }

    private static class Disposer
    extends NativeDisposer {
        Disposer(long l) {
            super(l);
        }

        @Override
        protected void dispose(long l) {
            SHA256NativeDigest.destroy(l);
        }
    }
}

