/*
 * Decompiled with CFR 0.152.
 */
package net.jsign.bouncycastle.crypto.digests;

import net.jsign.bouncycastle.crypto.CryptoServiceProperties;
import net.jsign.bouncycastle.crypto.CryptoServicePurpose;
import net.jsign.bouncycastle.crypto.CryptoServicesRegistrar;
import net.jsign.bouncycastle.crypto.SavableDigest;
import net.jsign.bouncycastle.crypto.digests.LongDigest;
import net.jsign.bouncycastle.crypto.digests.SHA384NativeDigest;
import net.jsign.bouncycastle.crypto.digests.Utils;
import net.jsign.bouncycastle.util.Memoable;
import net.jsign.bouncycastle.util.Pack;

public class SHA384Digest
extends LongDigest {
    public static SavableDigest newInstance() {
        if (CryptoServicesRegistrar.hasEnabledService("SHA384")) {
            return new SHA384NativeDigest();
        }
        return new SHA384Digest();
    }

    public static SavableDigest newInstance(CryptoServicePurpose cryptoServicePurpose) {
        if (CryptoServicesRegistrar.hasEnabledService("SHA384")) {
            return new SHA384NativeDigest(cryptoServicePurpose);
        }
        return new SHA384Digest(cryptoServicePurpose);
    }

    public SHA384Digest() {
        this(CryptoServicePurpose.ANY);
    }

    public SHA384Digest(CryptoServicePurpose cryptoServicePurpose) {
        super(cryptoServicePurpose);
        CryptoServicesRegistrar.checkConstraints(this.cryptoServiceProperties());
        this.reset();
    }

    public SHA384Digest(SHA384Digest sHA384Digest) {
        super(sHA384Digest);
        CryptoServicesRegistrar.checkConstraints(this.cryptoServiceProperties());
    }

    @Override
    public String getAlgorithmName() {
        return "SHA-384";
    }

    @Override
    public int getDigestSize() {
        return 48;
    }

    @Override
    public int doFinal(byte[] byArray, int n) {
        this.finish();
        Pack.longToBigEndian(this.H1, byArray, n);
        Pack.longToBigEndian(this.H2, byArray, n + 8);
        Pack.longToBigEndian(this.H3, byArray, n + 16);
        Pack.longToBigEndian(this.H4, byArray, n + 24);
        Pack.longToBigEndian(this.H5, byArray, n + 32);
        Pack.longToBigEndian(this.H6, byArray, n + 40);
        this.reset();
        return 48;
    }

    @Override
    public void reset() {
        super.reset();
        this.H1 = -3766243637369397544L;
        this.H2 = 7105036623409894663L;
        this.H3 = -7973340178411365097L;
        this.H4 = 1526699215303891257L;
        this.H5 = 7436329637833083697L;
        this.H6 = -8163818279084223215L;
        this.H7 = -2662702644619276377L;
        this.H8 = 5167115440072839076L;
    }

    @Override
    public Memoable copy() {
        return new SHA384Digest(this);
    }

    @Override
    public void reset(Memoable memoable) {
        SHA384Digest sHA384Digest = (SHA384Digest)memoable;
        super.copyIn(sHA384Digest);
    }

    @Override
    protected CryptoServiceProperties cryptoServiceProperties() {
        return Utils.getDefaultProperties(this, 256, this.purpose);
    }

    public String toString() {
        return "SHA384[Java]()";
    }
}

