/*
 * Decompiled with CFR 0.152.
 */
package net.jsign.bouncycastle.crypto.digests;

import net.jsign.bouncycastle.crypto.CryptoServicePurpose;
import net.jsign.bouncycastle.crypto.CryptoServicesRegistrar;
import net.jsign.bouncycastle.crypto.SavableDigest;
import net.jsign.bouncycastle.crypto.digests.KeccakDigest;
import net.jsign.bouncycastle.crypto.digests.SHA3NativeDigest;
import net.jsign.bouncycastle.util.Memoable;

public class SHA3Digest
extends KeccakDigest
implements SavableDigest {
    private static int checkBitLength(int n) {
        switch (n) {
            case 224: 
            case 256: 
            case 384: 
            case 512: {
                return n;
            }
        }
        throw new IllegalArgumentException("'bitLength' " + n + " not supported for SHA-3");
    }

    public SHA3Digest() {
        this(256, CryptoServicePurpose.ANY);
    }

    public static SavableDigest newInstance(int n) {
        if (CryptoServicesRegistrar.hasEnabledService("SHA3")) {
            return new SHA3NativeDigest(n);
        }
        return new SHA3Digest(n);
    }

    public SHA3Digest(int n) {
        super(SHA3Digest.checkBitLength(n), CryptoServicePurpose.ANY);
    }

    public static SavableDigest newInstance(int n, CryptoServicePurpose cryptoServicePurpose) {
        if (CryptoServicesRegistrar.hasEnabledService("SHA3")) {
            return new SHA3NativeDigest(n, cryptoServicePurpose);
        }
        return new SHA3Digest(n, cryptoServicePurpose);
    }

    public SHA3Digest(int n, CryptoServicePurpose cryptoServicePurpose) {
        super(SHA3Digest.checkBitLength(n), cryptoServicePurpose);
    }

    public SHA3Digest(SHA3Digest sHA3Digest) {
        super(sHA3Digest);
    }

    @Override
    public String getAlgorithmName() {
        return "SHA3-" + this.fixedOutputLength;
    }

    @Override
    public int doFinal(byte[] byArray, int n) {
        this.absorbBits(2, 2);
        return super.doFinal(byArray, n);
    }

    @Override
    public Memoable copy() {
        return new SHA3Digest(this);
    }

    @Override
    public void reset(Memoable memoable) {
        if (!(memoable instanceof SHA3Digest)) {
            throw new IllegalArgumentException("no SHA3Digest instance");
        }
        this.bitsInQueue = ((SHA3Digest)memoable).bitsInQueue;
        this.rate = ((SHA3Digest)memoable).rate;
        this.squeezing = ((SHA3Digest)memoable).squeezing;
        this.fixedOutputLength = ((SHA3Digest)memoable).fixedOutputLength;
        System.arraycopy(((SHA3Digest)memoable).state, 0, this.state, 0, this.state.length);
        this.purpose = ((SHA3Digest)memoable).purpose;
    }

    public String toString() {
        return "SHA3[Java]";
    }
}

