/*
 * Decompiled with CFR 0.152.
 */
package net.jsign.bouncycastle.crypto.digests;

import net.jsign.bouncycastle.crypto.CryptoServiceProperties;
import net.jsign.bouncycastle.crypto.CryptoServicePurpose;
import net.jsign.bouncycastle.crypto.CryptoServicesRegistrar;
import net.jsign.bouncycastle.crypto.SavableDigestXof;
import net.jsign.bouncycastle.crypto.digests.KeccakDigest;
import net.jsign.bouncycastle.crypto.digests.SHAKENativeDigest;
import net.jsign.bouncycastle.crypto.digests.Utils;
import net.jsign.bouncycastle.util.Memoable;

public class SHAKEDigest
extends KeccakDigest
implements SavableDigestXof {
    private static int checkBitLength(int n) {
        switch (n) {
            case 128: 
            case 256: {
                return n;
            }
        }
        throw new IllegalArgumentException("'bitStrength' " + n + " not supported for SHAKE");
    }

    public SHAKEDigest() {
        this(128);
    }

    public static SavableDigestXof newInstance(int n) {
        if (CryptoServicesRegistrar.hasEnabledService("SHAKE")) {
            return new SHAKENativeDigest(n);
        }
        return new SHAKEDigest(n);
    }

    public SHAKEDigest(int n) {
        super(SHAKEDigest.checkBitLength(n), CryptoServicePurpose.ANY);
    }

    public SHAKEDigest(SHAKEDigest sHAKEDigest) {
        super(sHAKEDigest);
    }

    @Override
    public String getAlgorithmName() {
        return "SHAKE" + this.fixedOutputLength;
    }

    @Override
    public int getDigestSize() {
        return this.fixedOutputLength / 4;
    }

    @Override
    public int doFinal(byte[] byArray, int n) {
        return this.doFinal(byArray, n, this.getDigestSize());
    }

    @Override
    public int doFinal(byte[] byArray, int n, int n2) {
        int n3 = this.doOutput(byArray, n, n2);
        this.reset();
        return n3;
    }

    public int doOutput(byte[] byArray, int n, int n2) {
        if (!this.squeezing) {
            this.absorbBits(15, 4);
        }
        this.squeeze(byArray, n, (long)n2 * 8L);
        return n2;
    }

    @Override
    protected CryptoServiceProperties cryptoServiceProperties() {
        return Utils.getDefaultProperties(this, this.purpose);
    }

    public String toString() {
        return "SHAKE[Java]()";
    }

    @Override
    public Memoable copy() {
        return new SHAKEDigest(this);
    }

    @Override
    public void reset(Memoable memoable) {
        if (!(memoable instanceof SHAKEDigest)) {
            throw new IllegalArgumentException("no SHAKEDigest instance");
        }
        this.bitsInQueue = ((SHAKEDigest)memoable).bitsInQueue;
        this.rate = ((SHAKEDigest)memoable).rate;
        this.squeezing = ((SHAKEDigest)memoable).squeezing;
        this.fixedOutputLength = ((SHAKEDigest)memoable).fixedOutputLength;
        System.arraycopy(((SHAKEDigest)memoable).state, 0, this.state, 0, this.state.length);
        this.purpose = ((SHAKEDigest)memoable).purpose;
    }
}

