/*
 * Decompiled with CFR 0.152.
 */
package net.jsign.bouncycastle.crypto.engines;

import net.jsign.bouncycastle.crypto.BlockCipher;
import net.jsign.bouncycastle.crypto.CipherParameters;
import net.jsign.bouncycastle.crypto.DataLengthException;
import net.jsign.bouncycastle.crypto.MultiBlockCipher;
import net.jsign.bouncycastle.crypto.engines.AESEngine;
import net.jsign.bouncycastle.crypto.modes.CTRModeCipher;
import net.jsign.bouncycastle.crypto.params.KeyParameter;
import net.jsign.bouncycastle.crypto.params.ParametersWithIV;
import net.jsign.bouncycastle.util.Arrays;
import net.jsign.bouncycastle.util.dispose.NativeDisposer;
import net.jsign.bouncycastle.util.dispose.NativeReference;

public class AESNativeCTR
implements CTRModeCipher {
    private CTRRefWrapper referenceWrapper = null;
    private int keyLen;
    private byte[] lastKey;

    @Override
    public BlockCipher getUnderlyingCipher() {
        MultiBlockCipher multiBlockCipher = AESEngine.newInstance();
        if (this.lastKey != null) {
            multiBlockCipher.init(true, new KeyParameter(this.lastKey));
        }
        return multiBlockCipher;
    }

    @Override
    public int getBlockSize() {
        return 16;
    }

    @Override
    public int processBlock(byte[] byArray, int n, byte[] byArray2, int n2) throws DataLengthException, IllegalStateException {
        if (this.referenceWrapper == null) {
            throw new IllegalStateException("not initialized");
        }
        return AESNativeCTR.processBytes(this.referenceWrapper.getReference(), byArray, n, this.getBlockSize(), byArray2, n2);
    }

    @Override
    public int getMultiBlockSize() {
        return AESNativeCTR.getMultiBlockSize(this.referenceWrapper.getReference());
    }

    @Override
    public int processBlocks(byte[] byArray, int n, int n2, byte[] byArray2, int n3) throws DataLengthException, IllegalStateException {
        int n4 = this.getBlockSize() * n2;
        if (this.referenceWrapper == null) {
            throw new IllegalStateException("not initialized");
        }
        return AESNativeCTR.processBytes(this.referenceWrapper.getReference(), byArray, n, n4, byArray2, n3);
    }

    @Override
    public void init(boolean bl, CipherParameters cipherParameters) throws IllegalArgumentException {
        if (cipherParameters instanceof ParametersWithIV) {
            int n;
            ParametersWithIV parametersWithIV = (ParametersWithIV)cipherParameters;
            byte[] byArray = parametersWithIV.getIV();
            int n2 = this.getBlockSize();
            int n3 = n = 8 > n2 / 2 ? n2 / 2 : 8;
            if (n2 - byArray.length > n) {
                throw new IllegalArgumentException("CTR mode requires IV of at least: " + (n2 - n) + " bytes.");
            }
            if (this.referenceWrapper == null) {
                this.referenceWrapper = new CTRRefWrapper(AESNativeCTR.makeCTRInstance());
            }
            if (parametersWithIV.getParameters() == null) {
                AESNativeCTR.init(this.referenceWrapper.getReference(), null, byArray);
            } else {
                byte[] byArray2 = ((KeyParameter)parametersWithIV.getParameters()).getKey();
                switch (byArray2.length) {
                    case 16: 
                    case 24: 
                    case 32: {
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("invalid key length, key must be 16,24 or 32 bytes");
                    }
                }
                AESNativeCTR.init(this.referenceWrapper.getReference(), byArray2, byArray);
                this.lastKey = Arrays.clone(byArray2);
                this.keyLen = byArray2.length * 8;
            }
        } else {
            throw new IllegalArgumentException("CTR mode requires ParametersWithIV");
        }
        this.reset();
    }

    static native long makeCTRInstance();

    @Override
    public String getAlgorithmName() {
        return "AES/CTR";
    }

    @Override
    public void reset() {
        if (this.referenceWrapper == null) {
            return;
        }
        AESNativeCTR.reset(this.referenceWrapper.getReference());
    }

    private static native int getMultiBlockSize(long var0);

    static native void init(long var0, byte[] var2, byte[] var3);

    private static native int processBytes(long var0, byte[] var2, int var3, int var4, byte[] var5, int var6);

    private static native void reset(long var0);

    static native void dispose(long var0);

    public String toString() {
        if (this.keyLen > 0) {
            return "CTR[Native](AES[Native](" + this.keyLen + "))";
        }
        return "CTR[Native](AES[Native](not initialized))";
    }

    private static class CTRRefWrapper
    extends NativeReference {
        public CTRRefWrapper(long l) {
            super(l, "CTR");
        }

        @Override
        public Runnable createAction() {
            return new Disposer(this.reference);
        }
    }

    private static class Disposer
    extends NativeDisposer {
        Disposer(long l) {
            super(l);
        }

        @Override
        protected void dispose(long l) {
            AESNativeCTR.dispose(l);
        }
    }
}

