/*
 * Decompiled with CFR 0.152.
 */
package net.jsign.bouncycastle.crypto.engines;

import net.jsign.bouncycastle.crypto.CipherParameters;
import net.jsign.bouncycastle.crypto.CryptoServicePurpose;
import net.jsign.bouncycastle.crypto.CryptoServicesRegistrar;
import net.jsign.bouncycastle.crypto.DataLengthException;
import net.jsign.bouncycastle.crypto.DefaultMultiBlockCipher;
import net.jsign.bouncycastle.crypto.NativeBlockCipherProvider;
import net.jsign.bouncycastle.crypto.constraints.DefaultServiceProperties;
import net.jsign.bouncycastle.crypto.engines.AESEngine;
import net.jsign.bouncycastle.crypto.engines.AESNativeCBC;
import net.jsign.bouncycastle.crypto.engines.AESNativeCCM;
import net.jsign.bouncycastle.crypto.engines.AESNativeCFB;
import net.jsign.bouncycastle.crypto.engines.AESNativeCTR;
import net.jsign.bouncycastle.crypto.engines.AESNativeGCM;
import net.jsign.bouncycastle.crypto.modes.CBCBlockCipher;
import net.jsign.bouncycastle.crypto.modes.CBCModeCipher;
import net.jsign.bouncycastle.crypto.modes.CCMBlockCipher;
import net.jsign.bouncycastle.crypto.modes.CCMModeCipher;
import net.jsign.bouncycastle.crypto.modes.CFBBlockCipher;
import net.jsign.bouncycastle.crypto.modes.CFBModeCipher;
import net.jsign.bouncycastle.crypto.modes.CTRModeCipher;
import net.jsign.bouncycastle.crypto.modes.GCMBlockCipher;
import net.jsign.bouncycastle.crypto.modes.GCMModeCipher;
import net.jsign.bouncycastle.crypto.modes.NativeCCMProvider;
import net.jsign.bouncycastle.crypto.modes.SICBlockCipher;
import net.jsign.bouncycastle.crypto.params.KeyParameter;
import net.jsign.bouncycastle.util.dispose.NativeDisposer;
import net.jsign.bouncycastle.util.dispose.NativeReference;

class AESNativeEngine
extends DefaultMultiBlockCipher
implements NativeBlockCipherProvider,
NativeCCMProvider {
    protected NativeReference wrapper = null;
    private int keyLen = 0;

    AESNativeEngine() {
        CryptoServicesRegistrar.checkConstraints(new DefaultServiceProperties(this.getAlgorithmName(), 256));
    }

    @Override
    public void init(boolean bl, CipherParameters cipherParameters) throws IllegalArgumentException {
        if (cipherParameters instanceof KeyParameter) {
            byte[] byArray = ((KeyParameter)cipherParameters).getKey();
            switch (byArray.length) {
                case 16: 
                case 24: 
                case 32: {
                    this.wrapper = new ECBNativeRef(AESNativeEngine.makeInstance(byArray.length, bl));
                    break;
                }
                default: {
                    throw new IllegalArgumentException("key must be 16, 24 or 32 bytes");
                }
            }
            CryptoServicesRegistrar.checkConstraints(new DefaultServiceProperties(this.getAlgorithmName(), byArray.length * 8, cipherParameters, bl ? CryptoServicePurpose.ENCRYPTION : CryptoServicePurpose.DECRYPTION));
            AESNativeEngine.init(this.wrapper.getReference(), byArray);
            this.keyLen = byArray.length * 8;
            return;
        }
        throw new IllegalArgumentException("invalid parameter passed to AES init - " + cipherParameters.getClass().getName());
    }

    @Override
    public String getAlgorithmName() {
        return "AES";
    }

    @Override
    public int getBlockSize() {
        return AESNativeEngine.getBlockSize(0L);
    }

    @Override
    public int processBlock(byte[] byArray, int n, byte[] byArray2, int n2) throws DataLengthException, IllegalStateException {
        if (this.wrapper == null) {
            throw new IllegalStateException("not initialized");
        }
        return AESNativeEngine.process(this.wrapper.getReference(), byArray, n, 1, byArray2, n2);
    }

    @Override
    public int getMultiBlockSize() {
        return AESNativeEngine.getMultiBlockSize(0L);
    }

    @Override
    public int processBlocks(byte[] byArray, int n, int n2, byte[] byArray2, int n3) throws DataLengthException, IllegalStateException {
        if (this.wrapper == null) {
            throw new IllegalStateException("not initialized");
        }
        return AESNativeEngine.process(this.wrapper.getReference(), byArray, n, n2, byArray2, n3);
    }

    @Override
    public void reset() {
        if (this.wrapper == null) {
            return;
        }
        AESNativeEngine.reset(this.wrapper.getReference());
    }

    private static native void reset(long var0);

    private static native int process(long var0, byte[] var2, int var3, int var4, byte[] var5, int var6);

    private static native int getMultiBlockSize(long var0);

    private static native int getBlockSize(long var0);

    static native long makeInstance(int var0, boolean var1);

    static native void dispose(long var0);

    static native void init(long var0, byte[] var2);

    @Override
    public GCMModeCipher createGCM() {
        if (CryptoServicesRegistrar.hasEnabledService("AES/GCM")) {
            return new AESNativeGCM();
        }
        return new GCMBlockCipher(new AESEngine());
    }

    @Override
    public CBCModeCipher createCBC() {
        if (CryptoServicesRegistrar.hasEnabledService("AES/CBC")) {
            return new AESNativeCBC();
        }
        return new CBCBlockCipher(new AESNativeEngine());
    }

    @Override
    public CFBModeCipher createCFB(int n) {
        if (n % 8 != 0 || n == 0 || n > 128) {
            throw new IllegalArgumentException("invalid CFB bitsize: " + n);
        }
        if (CryptoServicesRegistrar.hasEnabledService("AES/CFB")) {
            return new AESNativeCFB(n);
        }
        return new CFBBlockCipher(new AESNativeEngine(), n);
    }

    @Override
    public CTRModeCipher createCTR() {
        if (CryptoServicesRegistrar.hasEnabledService("AES/CTR")) {
            return new AESNativeCTR();
        }
        return new SICBlockCipher(AESEngine.newInstance());
    }

    @Override
    public CCMModeCipher createCCM() {
        if (CryptoServicesRegistrar.hasEnabledService("AES/CCM")) {
            return new AESNativeCCM();
        }
        return new CCMBlockCipher(AESEngine.newInstance());
    }

    public String toString() {
        return "AES[Native](" + this.keyLen + ")";
    }

    private static class Disposer
    extends NativeDisposer {
        Disposer(long l) {
            super(l);
        }

        @Override
        protected void dispose(long l) {
            AESNativeEngine.dispose(l);
        }
    }

    private static class ECBNativeRef
    extends NativeReference {
        public ECBNativeRef(long l) {
            super(l, "ECB");
        }

        @Override
        protected Runnable createAction() {
            return new Disposer(this.reference);
        }
    }
}

