/*
 * Decompiled with CFR 0.152.
 */
package net.jsign.bouncycastle.crypto.engines;

import net.jsign.bouncycastle.crypto.BlockCipher;
import net.jsign.bouncycastle.crypto.CipherParameters;
import net.jsign.bouncycastle.crypto.DataLengthException;
import net.jsign.bouncycastle.crypto.InvalidCipherTextException;
import net.jsign.bouncycastle.crypto.MultiBlockCipher;
import net.jsign.bouncycastle.crypto.engines.AESEngine;
import net.jsign.bouncycastle.crypto.modes.GCMModeCipher;
import net.jsign.bouncycastle.crypto.params.AEADParameters;
import net.jsign.bouncycastle.crypto.params.KeyParameter;
import net.jsign.bouncycastle.crypto.params.ParametersWithIV;
import net.jsign.bouncycastle.util.Arrays;
import net.jsign.bouncycastle.util.dispose.NativeDisposer;
import net.jsign.bouncycastle.util.dispose.NativeReference;

class AESNativeGCM
implements GCMModeCipher {
    private GCMRefWrapper refWrapper;
    private int macSize = 0;
    private byte[] nonce;
    private byte[] lastKey;
    private byte[] initialAssociatedText;
    private boolean forEncryption = false;
    private boolean initialised = false;
    private byte[] keptMac = null;
    private boolean finalCalled = false;

    AESNativeGCM() {
    }

    @Override
    public BlockCipher getUnderlyingCipher() {
        MultiBlockCipher multiBlockCipher = AESEngine.newInstance();
        if (this.lastKey != null) {
            multiBlockCipher.init(true, new KeyParameter(this.lastKey));
        }
        return multiBlockCipher;
    }

    @Override
    public void init(boolean bl, CipherParameters cipherParameters) throws IllegalArgumentException {
        KeyParameter keyParameter;
        this.forEncryption = bl;
        byte[] byArray = null;
        this.keptMac = null;
        if (cipherParameters instanceof AEADParameters) {
            AEADParameters aEADParameters = (AEADParameters)cipherParameters;
            byArray = aEADParameters.getNonce();
            this.initialAssociatedText = aEADParameters.getAssociatedText();
            int n = aEADParameters.getMacSize();
            if (n < 32 || n > 128 || n % 8 != 0) {
                throw new IllegalArgumentException("invalid value for MAC size: " + n);
            }
            this.macSize = n;
            keyParameter = aEADParameters.getKey();
        } else if (cipherParameters instanceof ParametersWithIV) {
            ParametersWithIV parametersWithIV = (ParametersWithIV)cipherParameters;
            byArray = parametersWithIV.getIV();
            this.initialAssociatedText = null;
            this.macSize = 128;
            keyParameter = (KeyParameter)parametersWithIV.getParameters();
        } else {
            throw new IllegalArgumentException("invalid parameters passed to GCM");
        }
        if (byArray == null || byArray.length < 12) {
            throw new IllegalArgumentException("IV must be at least 12 bytes");
        }
        if (bl && this.nonce != null && Arrays.areEqual(this.nonce, byArray)) {
            if (keyParameter == null) {
                throw new IllegalArgumentException("cannot reuse nonce for GCM encryption");
            }
            if (this.lastKey != null && Arrays.areEqual(this.lastKey, keyParameter.getKey())) {
                throw new IllegalArgumentException("cannot reuse nonce for GCM encryption");
            }
        }
        this.nonce = byArray;
        if (keyParameter != null) {
            this.lastKey = keyParameter.getKey();
        }
        switch (this.lastKey.length) {
            case 16: 
            case 24: 
            case 32: {
                break;
            }
            default: {
                throw new IllegalStateException("key must be only 16,24,or 32 bytes long.");
            }
        }
        this.initRef(this.lastKey.length);
        AESNativeGCM.initNative(this.refWrapper.getReference(), bl, this.lastKey, this.nonce, this.initialAssociatedText, this.macSize);
        this.finalCalled = false;
        this.initialised = true;
    }

    private void initRef(int n) {
        this.refWrapper = new GCMRefWrapper(AESNativeGCM.makeInstance(n, this.forEncryption));
    }

    @Override
    public String getAlgorithmName() {
        return "AES/GCM";
    }

    @Override
    public void processAADByte(byte by) {
        AESNativeGCM.processAADByte(this.refWrapper.getReference(), by);
    }

    @Override
    public void processAADBytes(byte[] byArray, int n, int n2) {
        if (this.refWrapper == null) {
            throw new IllegalStateException("GCM is uninitialized");
        }
        AESNativeGCM.processAADBytes(this.refWrapper.getReference(), byArray, n, n2);
    }

    @Override
    public int processBytes(byte[] byArray, int n, int n2, byte[] byArray2, int n3) throws DataLengthException {
        if (this.refWrapper == null) {
            throw new IllegalStateException("GCM is uninitialized");
        }
        return AESNativeGCM.processBytes(this.refWrapper.getReference(), byArray, n, n2, byArray2, n3);
    }

    @Override
    public int doFinal(byte[] byArray, int n) throws IllegalStateException, InvalidCipherTextException {
        this.checkStatus();
        int n2 = AESNativeGCM.doFinal(this.refWrapper.getReference(), byArray, n);
        this.resetKeepMac();
        return n2;
    }

    @Override
    public byte[] getMac() {
        if (this.keptMac != null) {
            return Arrays.clone(this.keptMac);
        }
        return AESNativeGCM.getMac(this.refWrapper.getReference());
    }

    @Override
    public int getUpdateOutputSize(int n) {
        return AESNativeGCM.getUpdateOutputSize(this.refWrapper.getReference(), n);
    }

    @Override
    public int getOutputSize(int n) {
        return AESNativeGCM.getOutputSize(this.refWrapper.getReference(), n);
    }

    @Override
    public void reset() {
        if (this.refWrapper == null) {
            return;
        }
        this.reset(this.refWrapper.getReference());
        this.initialised = false;
    }

    private void resetKeepMac() {
        if (this.refWrapper == null) {
            return;
        }
        this.keptMac = this.getMac();
        this.reset(this.refWrapper.getReference());
        this.initialised = false;
    }

    private void checkStatus() {
        if (!this.initialised) {
            if (this.forEncryption) {
                throw new IllegalStateException("GCM cipher cannot be reused for encryption");
            }
            throw new IllegalStateException("GCM cipher needs to be initialised");
        }
    }

    private native void reset(long var1);

    static native void initNative(long var0, boolean var2, byte[] var3, byte[] var4, byte[] var5, int var6);

    static native long makeInstance(int var0, boolean var1);

    static native void dispose(long var0);

    private static native void processAADByte(long var0, byte var2);

    private static native void processAADBytes(long var0, byte[] var2, int var3, int var4);

    private static native int processBytes(long var0, byte[] var2, int var3, int var4, byte[] var5, int var6);

    private static native int doFinal(long var0, byte[] var2, int var3);

    private static native int getUpdateOutputSize(long var0, int var2);

    private static native int getOutputSize(long var0, int var2);

    public static native byte[] getMac(long var0);

    public String toString() {
        if (this.lastKey != null) {
            return "GCM[Native](AES[Native](" + this.lastKey.length * 8 + "))";
        }
        return "GCM[Native](AES[Native](not initialized))";
    }

    private static class Disposer
    extends NativeDisposer {
        Disposer(long l) {
            super(l);
        }

        @Override
        protected void dispose(long l) {
            AESNativeGCM.dispose(l);
        }
    }

    private static class GCMRefWrapper
    extends NativeReference {
        public GCMRefWrapper(long l) {
            super(l, "GCM");
        }

        @Override
        public Runnable createAction() {
            return new Disposer(this.reference);
        }
    }
}

