/*
 * Decompiled with CFR 0.152.
 */
package net.jsign.bouncycastle.crypto.engines;

import javax.security.auth.DestroyFailedException;
import net.jsign.bouncycastle.crypto.CipherParameters;
import net.jsign.bouncycastle.crypto.PacketCipherException;
import net.jsign.bouncycastle.crypto.modes.AESGCMModePacketCipher;
import net.jsign.bouncycastle.crypto.params.AEADParameters;
import net.jsign.bouncycastle.crypto.params.KeyParameter;
import net.jsign.bouncycastle.crypto.params.ParametersWithIV;
import net.jsign.bouncycastle.util.Arrays;

public class AESNativeGCMPacketCipher
implements AESGCMModePacketCipher {
    private byte[] lastKey;
    private byte[] lastNonce;
    private boolean destroyed;

    @Override
    public int getOutputSize(boolean bl, CipherParameters cipherParameters, int n) {
        int n2 = this.checkParameters(cipherParameters);
        return AESNativeGCMPacketCipher.getOutputSize(bl, n, n2);
    }

    @Override
    public int processPacket(boolean bl, CipherParameters cipherParameters, byte[] byArray, int n, int n2, byte[] byArray2, int n3) throws PacketCipherException {
        byte[] byArray3;
        int n4;
        int n5;
        byte[] byArray4;
        byte[] byArray5;
        block9: {
            try {
                CipherParameters cipherParameters2;
                if (cipherParameters instanceof AEADParameters) {
                    cipherParameters2 = (AEADParameters)cipherParameters;
                    byArray5 = ((AEADParameters)cipherParameters2).getNonce();
                    byArray4 = ((AEADParameters)cipherParameters2).getAssociatedText();
                    n5 = ((AEADParameters)cipherParameters2).getMacSize();
                    if (n5 < 32 || n5 > 128 || (n5 & 7) != 0) {
                        throw new IllegalArgumentException("invalid mac size: " + n5);
                    }
                    n4 = n5 >> 3;
                    byArray3 = ((AEADParameters)cipherParameters2).getKey().getKey();
                    if (bl && Arrays.areEqual(byArray3, this.lastKey) && Arrays.areEqual(byArray5, this.lastNonce)) {
                        throw new IllegalArgumentException("cannot reuse nonce for GCM encryption");
                    }
                    this.lastKey = Arrays.clone(byArray3);
                    this.lastNonce = Arrays.clone(byArray5);
                    break block9;
                }
                if (cipherParameters instanceof ParametersWithIV) {
                    cipherParameters2 = (ParametersWithIV)cipherParameters;
                    byArray5 = (byte[])((ParametersWithIV)cipherParameters2).getIV().clone();
                    byArray4 = null;
                    n4 = 16;
                    byArray3 = ((KeyParameter)((ParametersWithIV)cipherParameters2).getParameters()).getKey();
                    if (bl && Arrays.areEqual(byArray3, this.lastKey) && Arrays.areEqual(byArray5, this.lastNonce)) {
                        throw new IllegalArgumentException("cannot reuse nonce for GCM encryption");
                    }
                    this.lastKey = Arrays.clone(byArray3);
                    this.lastNonce = Arrays.clone(byArray5);
                    break block9;
                }
                throw new IllegalArgumentException("invalid parameters passed to GCM");
            }
            catch (Exception exception) {
                throw PacketCipherException.from(exception);
            }
        }
        int n6 = byArray2 != null ? byArray2.length - n3 : 0;
        try {
            n5 = AESNativeGCMPacketCipher.processPacket(bl, byArray3, byArray5, byArray4, n4, byArray, n, n2, byArray2, n3, n6);
        }
        catch (Exception exception) {
            throw PacketCipherException.from(exception);
        }
        return n5;
    }

    static native int getOutputSize(boolean var0, int var1, int var2);

    static native int processPacket(boolean var0, byte[] var1, byte[] var2, byte[] var3, int var4, byte[] var5, int var6, int var7, byte[] var8, int var9, int var10);

    public String toString() {
        return "GCM-PS[Native](AES[Native])";
    }

    @Override
    public void destroy() throws DestroyFailedException {
        Arrays.clear(this.lastKey);
        Arrays.clear(this.lastNonce);
        this.lastKey = null;
        this.lastNonce = null;
        this.destroyed = true;
    }

    @Override
    public boolean isDestroyed() {
        return this.destroyed;
    }
}

