/*
 * Decompiled with CFR 0.152.
 */
package net.jsign.bouncycastle.crypto.engines;

import net.jsign.bouncycastle.crypto.CipherParameters;
import net.jsign.bouncycastle.crypto.PacketCipherException;
import net.jsign.bouncycastle.crypto.modes.AESGCMSIVModePacketCipher;
import net.jsign.bouncycastle.crypto.params.AEADParameters;
import net.jsign.bouncycastle.crypto.params.KeyParameter;
import net.jsign.bouncycastle.crypto.params.ParametersWithIV;

public class AESNativeGCMSIVPacketCipher
implements AESGCMSIVModePacketCipher {
    @Override
    public int getOutputSize(boolean bl, CipherParameters cipherParameters, int n) {
        this.checkParameters(cipherParameters);
        return AESNativeGCMSIVPacketCipher.getOutputSize(bl, n);
    }

    @Override
    public int processPacket(boolean bl, CipherParameters cipherParameters, byte[] byArray, int n, int n2, byte[] byArray2, int n3) throws PacketCipherException {
        int n4;
        byte[] byArray3;
        byte[] byArray4;
        byte[] byArray5;
        CipherParameters cipherParameters2;
        if (cipherParameters instanceof AEADParameters) {
            cipherParameters2 = (AEADParameters)cipherParameters;
            byArray5 = ((AEADParameters)cipherParameters2).getNonce();
            byArray4 = ((AEADParameters)cipherParameters2).getAssociatedText();
            byArray3 = ((AEADParameters)cipherParameters2).getKey().getKey();
        } else if (cipherParameters instanceof ParametersWithIV) {
            cipherParameters2 = (ParametersWithIV)cipherParameters;
            byArray5 = (byte[])((ParametersWithIV)cipherParameters2).getIV().clone();
            byArray4 = null;
            byArray3 = ((KeyParameter)((ParametersWithIV)cipherParameters2).getParameters()).getKey();
        } else {
            throw PacketCipherException.from(new IllegalArgumentException("invalid parameters passed to GCM-SIV"));
        }
        int n5 = byArray2 != null ? byArray2.length - n3 : 0;
        try {
            n4 = AESNativeGCMSIVPacketCipher.processPacket(bl, byArray3, byArray5, byArray4, byArray, n, n2, byArray2, n3, n5);
        }
        catch (Exception exception) {
            throw PacketCipherException.from(exception);
        }
        return n4;
    }

    static native int getOutputSize(boolean var0, int var1);

    static native int processPacket(boolean var0, byte[] var1, byte[] var2, byte[] var3, byte[] var4, int var5, int var6, byte[] var7, int var8, int var9);

    public String toString() {
        return "GCMSIV-PS[Native](AES[Native])";
    }
}

