/*
 * Decompiled with CFR 0.152.
 */
package net.jsign.bouncycastle.crypto.macs;

import net.jsign.bouncycastle.crypto.CipherParameters;
import net.jsign.bouncycastle.crypto.DataLengthException;
import net.jsign.bouncycastle.crypto.InvalidCipherTextException;
import net.jsign.bouncycastle.crypto.Mac;
import net.jsign.bouncycastle.crypto.modes.GCMModeCipher;
import net.jsign.bouncycastle.crypto.params.AEADParameters;
import net.jsign.bouncycastle.crypto.params.KeyParameter;
import net.jsign.bouncycastle.crypto.params.ParametersWithIV;

public class GMac
implements Mac {
    private final GCMModeCipher cipher;
    private final int macSizeBits;

    public GMac(GCMModeCipher gCMModeCipher) {
        this.cipher = gCMModeCipher;
        this.macSizeBits = 128;
    }

    @Override
    public void init(CipherParameters cipherParameters) throws IllegalArgumentException {
        if (!(cipherParameters instanceof ParametersWithIV)) {
            throw new IllegalArgumentException("GMAC requires ParametersWithIV");
        }
        ParametersWithIV parametersWithIV = (ParametersWithIV)cipherParameters;
        byte[] byArray = parametersWithIV.getIV();
        KeyParameter keyParameter = (KeyParameter)parametersWithIV.getParameters();
        this.cipher.init(true, new AEADParameters(keyParameter, this.macSizeBits, byArray));
    }

    @Override
    public String getAlgorithmName() {
        return this.cipher.getUnderlyingCipher().getAlgorithmName() + "-GMAC";
    }

    @Override
    public int getMacSize() {
        return this.macSizeBits / 8;
    }

    @Override
    public void update(byte by) throws IllegalStateException {
        this.cipher.processAADByte(by);
    }

    @Override
    public void update(byte[] byArray, int n, int n2) throws DataLengthException, IllegalStateException {
        this.cipher.processAADBytes(byArray, n, n2);
    }

    @Override
    public int doFinal(byte[] byArray, int n) throws DataLengthException, IllegalStateException {
        try {
            return this.cipher.doFinal(byArray, n);
        }
        catch (InvalidCipherTextException invalidCipherTextException) {
            throw new IllegalStateException(invalidCipherTextException.toString());
        }
    }

    @Override
    public void reset() {
        this.cipher.reset();
    }
}

