/*
 * Decompiled with CFR 0.152.
 */
package net.jsign.bouncycastle.crypto.modes;

import net.jsign.bouncycastle.crypto.CipherParameters;
import net.jsign.bouncycastle.crypto.PacketCipher;
import net.jsign.bouncycastle.crypto.PacketCipherException;
import net.jsign.bouncycastle.crypto.engines.AESPacketCipher;
import net.jsign.bouncycastle.crypto.params.KeyParameter;
import net.jsign.bouncycastle.crypto.params.ParametersWithIV;

public interface AESCBCModePacketCipher
extends PacketCipher {
    default public void checkParameters(CipherParameters cipherParameters) throws PacketCipherException {
        KeyParameter keyParameter = null;
        if (cipherParameters instanceof KeyParameter) {
            keyParameter = (KeyParameter)cipherParameters;
        } else if (cipherParameters instanceof ParametersWithIV) {
            keyParameter = (KeyParameter)((ParametersWithIV)cipherParameters).getParameters();
            if (((ParametersWithIV)cipherParameters).getIV().length != 16) {
                throw PacketCipherException.from(new IllegalArgumentException("iv must be only 16 bytes"));
            }
        } else {
            throw PacketCipherException.from(new IllegalArgumentException("invalid parameter type"));
        }
        AESPacketCipher.checkKeyLength(keyParameter.getKeyLength());
    }
}

