/*
 * Decompiled with CFR 0.152.
 */
package net.jsign.bouncycastle.crypto.modes;

import net.jsign.bouncycastle.crypto.CipherParameters;
import net.jsign.bouncycastle.crypto.CryptoServicesRegistrar;
import net.jsign.bouncycastle.crypto.PacketCipherException;
import net.jsign.bouncycastle.crypto.engines.AESNativeCBCPacketCipher;
import net.jsign.bouncycastle.crypto.engines.AESPacketCipher;
import net.jsign.bouncycastle.crypto.modes.AESCBCModePacketCipher;
import net.jsign.bouncycastle.crypto.modes.PacketCipherChecks;
import net.jsign.bouncycastle.crypto.params.KeyParameter;
import net.jsign.bouncycastle.crypto.params.ParametersWithIV;
import net.jsign.bouncycastle.util.Arrays;
import net.jsign.bouncycastle.util.Bytes;

public class AESCBCPacketCipher
implements AESCBCModePacketCipher {
    public static AESCBCModePacketCipher newInstance() {
        if (CryptoServicesRegistrar.hasEnabledService("AES/CBC-PC")) {
            return new AESNativeCBCPacketCipher();
        }
        return new AESCBCPacketCipher();
    }

    @Override
    public int getOutputSize(boolean bl, CipherParameters cipherParameters, int n) {
        if (n < 0) {
            throw new IllegalArgumentException("input len is negative");
        }
        if (n % 16 != 0) {
            throw new IllegalArgumentException("input len not multiple of block size");
        }
        if (cipherParameters instanceof ParametersWithIV) {
            if (((ParametersWithIV)cipherParameters).getIV().length != 16) {
                throw new IllegalArgumentException("iv must be only 16 bytes");
            }
            cipherParameters = ((ParametersWithIV)cipherParameters).getParameters();
        }
        if (cipherParameters instanceof KeyParameter) {
            PacketCipherChecks.checkKeyLenIllegalArgumentException(((KeyParameter)cipherParameters).getKeyLength());
        }
        return n;
    }

    @Override
    public int processPacket(boolean bl, CipherParameters cipherParameters, byte[] byArray, int n, int n2, byte[] byArray2, int n3) throws PacketCipherException {
        byte[] byArray3;
        Object object;
        PacketCipherChecks.checkBoundsInputAndOutputWithBlockSize_16(byArray, n, n2, byArray2, n3);
        if (n2 == 0) {
            return n2;
        }
        int n4 = n2 / 16;
        if (cipherParameters instanceof ParametersWithIV) {
            object = (ParametersWithIV)cipherParameters;
            byArray3 = Arrays.clone(((ParametersWithIV)object).getIV());
            if (byArray3.length != 16) {
                throw PacketCipherException.from(new IllegalArgumentException("iv must be only 16 bytes"));
            }
            cipherParameters = ((ParametersWithIV)cipherParameters).getParameters();
        } else {
            byArray3 = new byte[16];
        }
        if (!(cipherParameters instanceof KeyParameter)) {
            throw PacketCipherException.from(new IllegalArgumentException("invalid parameter type"));
        }
        object = (KeyParameter)cipherParameters;
        PacketCipherChecks.checkKeyLength(((KeyParameter)object).getKeyLength());
        byte[] byArray4 = Arrays.clone(((KeyParameter)object).getKey());
        object = AESPacketCipher.createS(bl);
        int[][] nArray = AESPacketCipher.generateWorkingKey(bl, byArray4);
        byte[] byArray5 = Arrays.clone(byArray3);
        byte[] byArray6 = new byte[16];
        for (int i = 0; i < n4; ++i) {
            if (bl) {
                Bytes.xorTo(16, byArray, n, byArray5, 0);
                AESPacketCipher.processBlock(bl, nArray, (byte[])object, byArray5, 0, byArray2, n3);
                System.arraycopy(byArray2, n3, byArray5, 0, byArray5.length);
            } else {
                System.arraycopy(byArray, n, byArray6, 0, 16);
                AESPacketCipher.processBlock(bl, nArray, (byte[])object, byArray, n, byArray2, n3);
                Bytes.xorTo(16, byArray5, 0, byArray2, n3);
                byte[] byArray7 = byArray5;
                byArray5 = byArray6;
                byArray6 = byArray7;
            }
            n3 += 16;
            n += 16;
        }
        Arrays.clear(byArray4);
        Arrays.clear(byArray3);
        Arrays.clear(byArray6);
        Arrays.fill(byArray5, (byte)0);
        Arrays.clear(nArray);
        Arrays.clear((byte[])object);
        return n4 * 16;
    }

    public String toString() {
        return "CBC-PS[Java](AES[Java])";
    }
}

