/*
 * Decompiled with CFR 0.152.
 */
package net.jsign.bouncycastle.crypto.modes;

import net.jsign.bouncycastle.crypto.CipherParameters;
import net.jsign.bouncycastle.crypto.CryptoServicesRegistrar;
import net.jsign.bouncycastle.crypto.InvalidCipherTextException;
import net.jsign.bouncycastle.crypto.OutputLengthException;
import net.jsign.bouncycastle.crypto.PacketCipherException;
import net.jsign.bouncycastle.crypto.engines.AESNativeCCMPacketCipher;
import net.jsign.bouncycastle.crypto.engines.AESPacketCipher;
import net.jsign.bouncycastle.crypto.modes.AESCCMModePacketCipher;
import net.jsign.bouncycastle.crypto.modes.PacketCipherChecks;
import net.jsign.bouncycastle.crypto.params.AEADParameters;
import net.jsign.bouncycastle.crypto.params.KeyParameter;
import net.jsign.bouncycastle.crypto.params.ParametersWithIV;
import net.jsign.bouncycastle.util.Arrays;
import net.jsign.bouncycastle.util.Bytes;

public class AESCCMPacketCipher
implements AESCCMModePacketCipher {
    public static AESCCMModePacketCipher newInstance() {
        if (CryptoServicesRegistrar.hasEnabledService("AES/CCM-PC")) {
            return new AESNativeCCMPacketCipher();
        }
        return new AESCCMPacketCipher();
    }

    @Override
    public int getOutputSize(boolean bl, CipherParameters cipherParameters, int n) {
        if (n < 0) {
            throw new IllegalArgumentException("input len is negative");
        }
        int n2 = this.getMacSize(bl, cipherParameters);
        if (bl) {
            return PacketCipherChecks.addCheckInputOverflow(n, n2);
        }
        if (n < n2) {
            throw new OutputLengthException("output buffer too short");
        }
        return n - n2;
    }

    @Override
    public int processPacket(boolean bl, CipherParameters cipherParameters, byte[] byArray, int n, int n2, byte[] byArray2, int n3) throws PacketCipherException {
        int n4;
        KeyParameter keyParameter;
        byte[] byArray3;
        byte[] byArray4;
        int n5;
        Object object;
        PacketCipherChecks.checkBoundsInput(byArray, n, n2, byArray2, n3);
        byte[] byArray5 = new byte[16];
        byte[] byArray6 = new byte[16];
        byte[] byArray7 = new byte[16];
        byte[] byArray8 = null;
        if (!bl) {
            byArray8 = new byte[16];
        }
        try {
            if (cipherParameters instanceof AEADParameters) {
                object = (AEADParameters)cipherParameters;
                n5 = this.getCCMMacSize(bl, ((AEADParameters)object).getMacSize());
                byArray4 = ((AEADParameters)object).getNonce();
                byArray3 = ((AEADParameters)object).getAssociatedText();
                keyParameter = ((AEADParameters)object).getKey();
            } else if (cipherParameters instanceof ParametersWithIV) {
                object = (ParametersWithIV)cipherParameters;
                n5 = 8;
                byArray4 = Arrays.clone(((ParametersWithIV)object).getIV());
                byArray3 = null;
                keyParameter = (KeyParameter)((ParametersWithIV)object).getParameters();
            } else {
                throw new IllegalArgumentException("invalid parameters passed to CCM");
            }
            PacketCipherChecks.checkInputAndOutputAEAD(bl, byArray, n, n2, byArray2, n3, n5);
            if (byArray4 == null || byArray4.length < 7 || byArray4.length > 13) {
                throw new IllegalArgumentException("nonce must have length from 7 to 13 octets");
            }
            PacketCipherChecks.checkKeyLength(keyParameter.getKeyLength());
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw PacketCipherException.from(illegalArgumentException);
        }
        object = AESPacketCipher.generateWorkingKey(true, keyParameter.getKey());
        byte[] byArray9 = AESPacketCipher.createS(true);
        int n6 = 15 - byArray4.length;
        if (n6 < 4 && n2 >= (n4 = 1 << (n6 << 3))) {
            throw PacketCipherException.from(new IllegalStateException("CCM packet too large for choice of q."));
        }
        PacketCipherException packetCipherException = null;
        int n7 = 0;
        try {
            int n8;
            byArray6[0] = (byte)(n6 - 1 & 7);
            System.arraycopy(byArray4, 0, byArray6, 1, byArray4.length);
            int n9 = n3;
            if (bl) {
                n7 = PacketCipherChecks.addCheckInputOverflow(n2, n5);
                AESCCMPacketCipher.calculateMac(byArray, n, n2, byArray5, n5, byArray3, byArray4, (int[][])object, byArray9);
                AESCCMPacketCipher.ctrProcessBlock(byArray6, byArray7, byArray5, 0, byArray5, 0, (int[][])object, byArray9);
                System.arraycopy(byArray5, 0, byArray2, n3 + n2, n5);
                for (n8 = n; n8 < n + n2 - 16; n8 += 16) {
                    AESCCMPacketCipher.ctrProcessBlock(byArray6, byArray7, byArray, n8, byArray2, n9, (int[][])object, byArray9);
                    n9 += 16;
                }
                System.arraycopy(byArray, n8, byArray5, 0, n2 + n - n8);
                AESCCMPacketCipher.ctrProcessBlock(byArray6, byArray7, byArray5, 0, byArray5, 0, (int[][])object, byArray9);
                System.arraycopy(byArray5, 0, byArray2, n9, n2 + n - n8);
            } else {
                n7 = n2 - n5;
                System.arraycopy(byArray, n + n7, byArray5, 0, n5);
                AESCCMPacketCipher.ctrProcessBlock(byArray6, byArray7, byArray5, 0, byArray5, 0, (int[][])object, byArray9);
                Arrays.fill(byArray5, n5, 16, (byte)0);
                while (n8 < n + n7 - 16) {
                    AESCCMPacketCipher.ctrProcessBlock(byArray6, byArray7, byArray, n8, byArray2, n9, (int[][])object, byArray9);
                    n9 += 16;
                    n8 += 16;
                }
                System.arraycopy(byArray, n8, byArray8, 0, n7 - (n8 - n));
                AESCCMPacketCipher.ctrProcessBlock(byArray6, byArray7, byArray8, 0, byArray8, 0, (int[][])object, byArray9);
                System.arraycopy(byArray8, 0, byArray2, n9, n7 - (n8 - n));
                AESCCMPacketCipher.calculateMac(byArray2, n3, n7, byArray8, n5, byArray3, byArray4, (int[][])object, byArray9);
                if (!Arrays.constantTimeAreEqual(byArray5, byArray8)) {
                    throw new InvalidCipherTextException("mac check in CCM failed");
                }
            }
        }
        catch (Exception exception) {
            packetCipherException = PacketCipherException.from(exception);
            throw packetCipherException;
        }
        finally {
            if (packetCipherException != null) {
                int n10 = Math.min(n7, byArray2.length - n3);
                Arrays.clear(byArray2, n3, n10);
            }
        }
        Arrays.clear((int[][])object);
        Arrays.clear(byArray5);
        Arrays.clear(byArray6);
        Arrays.clear(byArray7);
        Arrays.clear(byArray8);
        Arrays.clear(byArray9);
        return n7;
    }

    private static void calculateMac(byte[] byArray, int n, int n2, byte[] byArray2, int n3, byte[] byArray3, byte[] byArray4, int[][] nArray, byte[] byArray5) {
        byte[] byArray6 = new byte[16];
        int n4 = 0;
        if (byArray3 != null && byArray3.length > 0) {
            byArray6[0] = (byte)(byArray6[0] | 0x40);
        }
        byArray6[0] = (byte)(byArray6[0] | ((n3 - 2 >> 1 & 7) << 3 | 15 - byArray4.length - 1 & 7));
        System.arraycopy(byArray4, 0, byArray6, 1, byArray4.length);
        int n5 = 1;
        for (int i = n2; i > 0; i >>>= 8) {
            byArray6[byArray6.length - n5++] = (byte)(i & 0xFF);
        }
        AESPacketCipher.processBlock(true, nArray, byArray5, byArray6, 0, byArray2, 0);
        if (byArray3 != null && byArray3.length > 0) {
            int n6 = byArray3.length;
            if (n6 < 65280) {
                byArray6[0] = (byte)(n6 >> 8);
                byArray6[1] = (byte)n6;
                n4 = 2;
            } else {
                byArray6[0] = -1;
                byArray6[1] = -2;
                byArray6[2] = (byte)(n6 >> 24);
                byArray6[3] = (byte)(n6 >> 16);
                byArray6[4] = (byte)(n6 >> 8);
                byArray6[5] = (byte)n6;
                n4 = 6;
            }
            n4 = AESCCMPacketCipher.cbcmacUpdate(byArray6, byArray2, n4, byArray3, 0, byArray3.length, nArray, byArray5);
            if (n4 != 0) {
                Arrays.fill(byArray6, n4, 16, (byte)0);
                Bytes.xorTo(16, byArray2, 0, byArray6, 0);
                AESPacketCipher.processBlock(true, nArray, byArray5, byArray6, 0, byArray2, 0);
                n4 = 0;
            }
        }
        if (n2 != 0) {
            n4 = AESCCMPacketCipher.cbcmacUpdate(byArray6, byArray2, n4, byArray, n, n2, nArray, byArray5);
            Arrays.fill(byArray6, n4, 16, (byte)0);
            Bytes.xorTo(16, byArray6, byArray2);
            AESPacketCipher.processBlock(true, nArray, byArray5, byArray2, 0, byArray2, 0);
        }
        Arrays.fill(byArray2, n3, 16, (byte)0);
        Arrays.clear(byArray6);
    }

    private static int cbcmacUpdate(byte[] byArray, byte[] byArray2, int n, byte[] byArray3, int n2, int n3, int[][] nArray, byte[] byArray4) {
        int n4 = 16 - n;
        if (n3 > n4) {
            System.arraycopy(byArray3, n2, byArray, n, n4);
            Bytes.xorTo(16, byArray, byArray2);
            AESPacketCipher.processBlock(true, nArray, byArray4, byArray2, 0, byArray2, 0);
            n = 0;
            n3 -= n4;
            n2 += n4;
            while (n3 > 16) {
                Bytes.xor(16, byArray2, 0, byArray3, n2, byArray2, 0);
                AESPacketCipher.processBlock(true, nArray, byArray4, byArray2, 0, byArray2, 0);
                n3 -= 16;
                n2 += 16;
            }
        }
        System.arraycopy(byArray3, n2, byArray, n, n3);
        return n += n3;
    }

    protected static void ctrProcessBlock(byte[] byArray, byte[] byArray2, byte[] byArray3, int n, byte[] byArray4, int n2, int[][] nArray, byte[] byArray5) {
        AESPacketCipher.processBlock(true, nArray, byArray5, byArray, 0, byArray2, 0);
        int n3 = byArray.length;
        while (--n3 >= 0) {
            int n4 = n3;
            byArray[n4] = (byte)(byArray[n4] + 1);
            if (byArray[n4] == 0) continue;
        }
        Bytes.xorTee(16, byArray3, n, byArray2, 0, byArray4, n2);
    }

    public String toString() {
        return "CCM-PS[Java](AES[Java])";
    }
}

